/*****************************************************************************
 *          Library for loading OpenGL textures from PNG files               *
 *                                                                           *
 * Author: Jens-Peer Kuska <kuska@izbi.uni-leipzig.de>                       *
 * Licence: Public Domain                                                     *
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <png.h>
#include <GL/gl.h>

typedef struct Texture {
	int texid;
	int type;
	int width, height;
	GLubyte *image;
} Texture;

int textureCount;
Texture *textureHandles;

/**
 * Loads a texture from a given PNG file
 */
int LoadPNGTexture( Texture*, const char* );

/**
 * For each given filename an Texture structure is created and LoadPNGTexture
 * is called.
 */
void initTextures( const char**, int );

/**
 * Frees the memory reserved by initTextures. Call this in the exit-handler.
 *
 * Added by Martin Christian.
 */
void discardTextures();

