/******************************************************************************
 * Im Rahmen des Seminars zur Vorlesung "Netzwerksicherheit" an der           *
 * Universitaet Leipzig entstand dieser Netzwerksniffer.                      *
 * Er steht jedem Interessierten zum Lernen und Weiterentwickeln als          *
 * Allgemeingut zur Verfuegung.                                               *
 *                                                                            *
 * Leipzig im Sommersemester 2004, Martin Christian.                          *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include "list.h"
#include "inet.h"

#define SHORTBUF 16
#define ACTION_SNIFFING 0
#define ACTION_SPOOFING 1
#define ACTION_WATCHING 2

struct options_t {
	char dev[SHORTBUF];
	struct libnet_ether_addr *target_mac;
	struct libnet_ether_addr *sender_mac;
	uint32_t target_ip;
	uint32_t sender_ip;
	char proto[SHORTBUF];
	uint16_t op;
	uint8_t action;
};

/*
 * usage( name des programms )
 */
void usage( char* cmd );

/*
 * scanip( ip als string )
 */
uint32_t scanip( const char *ipstring );

/*
 * scanmac( mac adresse als string )
 */
struct libnet_ether_addr* scanmac( const char *macstring );

/*
 * maccmp( struct ether_addr*, struct ether_addr* )
 */
int maccmp( struct libnet_ether_addr *ea0, struct libnet_ether_addr *ea1 );

/*
 * cleanup( libnet kontext )
 */
void cleanup( libnet_t *l );

/*
 * init( die parameter der main() )
 */
struct options_t* init( int argc, char** argv );

/*
 * analyze_arp( arp paket )
 */
void analyze_arp( const struct arp_t *arphdr );

/*
 * analyze_tcp( tcp paket )
 */
void analyze_tcp( const struct tcp_t *tcphdr );

/*
 * analyze_udp( udp paket )
 */
void analyze_udp( const struct udp_t *udphdr );

/*
 * analyze_ip6( ip version 6 paket )
 */
void analyze_ip6( const struct ip6_t *iphdr );

/*
 * analyze_ip( ip version 4 paket )
 */
void analyze_ip( const struct ip4_t *iphdr );

/*
 * sniff_packet( parameter gemaess pcap vorgabe )
 */
void sniff_packet( u_char* args, const struct pcap_pkthdr *header,
									 const u_char* data );

/*
 * watch_arp( parameter gemaess pcap vorgabe )
 */
void watch_arp( u_char* args, const struct pcap_pkthdr *header, const u_char* data );

/*
 * send_arp( libnet kontext )
 */
int send_arp( libnet_t *libnetcon );

/*
 * send_packet( libnet kontext )
 */
int send_packet( libnet_t *libnetcon );
