/*********************************************************************
 *                                                                   *
 *                     Generic List                                  *
 *                                                                   *
 *  Author:  Martin Christian                                        *
 *  Date:    13/04/03                                                *
 *  Licence: LGPL                                                    *
 *********************************************************************/

#include <stdlib.h>
#ifdef DEBUG
    #include <stdio.h>
#endif
#include "list.h"

LISTFRAME *start;
int counter;

void list_init() {
	#ifdef DEBUG
		printf( "list_init...\n" );
	#endif
	start = NULL;
	counter = 0;
}

void list_destroy() {
	LISTFRAME *element;
	LISTFRAME *next;

	#ifdef DEBUG
		printf( "list_destroy...\n" );
	#endif
	element = start;
	while ( element != NULL ) {
		next = element->next;
		free( element );
		element = next;
	}
}

int list_insert( void *content ) {
	LISTFRAME *new;
	LISTFRAME *last;

	#ifdef DEBUG
		printf( "list_insert...\n" );
	#endif
	if ( start == NULL ) {
		start = (LISTFRAME*)malloc( sizeof(LISTFRAME) );
		new = start;
		last = NULL;
	}
	else {
		new = (LISTFRAME*)malloc( sizeof(LISTFRAME) );
		last = list_bottom();
		last->next = new;
	}

	new->prev = last;
	new->next = NULL;
	new->content = content;

	counter++;
	return 0;
}

int list_remove( int n ) {
	LISTFRAME *element;
	int i;

	#ifdef DEBUG
		printf( "list_remove...\n" );
	#endif
	if ( n < counter ) {
		element = start;
		for (i=0; i<n; i++) element = element->next;
		if ( element->prev != NULL )
			element->prev->next = element->next;
		else
			start = element->next;
		if ( element->next != NULL )
			element->next->prev = element->prev;
		free( element );
		counter--;
		return 0;
	}
	else return -1;
}

void* list_get( int n ) {
    LISTFRAME *element;
    int i;

    #ifdef DEBUG
      printf( "list_get...\n" );
    #endif
    if ( n >= counter ) return NULL;
    element=start;
    for (i=0; i<n; i++) element = element->next;
    return element->content;
}

int list_get_count() {
    #ifdef DEBUG
      printf( "list_get_count...\n" );
    #endif
    return counter;
}

LISTFRAME* list_top() {
    return start;
}

LISTFRAME* list_bottom() {
	LISTFRAME *element;

	#ifdef DEBUG
	printf( "list_bottom...\n" );
	#endif

	element = start;
	if ( element != NULL )
		while ( element->next != NULL )
			element = element->next;

	return element;
}

/*
 * Todo: + Error handling
 *
 * Muell:
 * start = (LISTFRAME*)malloc( sizeof(LISTFRAME) );
 * start->prev = NULL;
 * start->next = NULL;
 * start->content = NULL;
 */
