/******************************************************************************
 * Deklaration von Netzwerkprotokollen                                        *
 *                                                                            *
 *                          Leipzig im Sommersemester 2004, Martin Christian. *
 ******************************************************************************/

#include <pcap.h>
#include <libnet.h>
#include <netinet/in.h>
#include <netinet/ether.h>

/* === Ethernet === */
struct ether_t {
	struct libnet_ether_addr ether_dhost;   /* destination eth addr */
	struct libnet_ether_addr ether_shost;   /* source ether addr    */
	uint16_t  ether_type;                   /* packet type ID field */
	uint8_t   ether_data[];                 /* packet data          */
};

struct vether_t {
	struct libnet_ether_addr ether_dhost;   /* destination eth addr      */
	struct libnet_ether_addr ether_shost;   /* source ether addr         */
	uint16_t  ether_tpid;                   /* tag protocol ID           */
	uint16_t  ether_tci;                    /* tag control information   */
	uint8_t   ether_erif;                   /* routing information field */
	uint16_t  ether_type;                   /* packet type ID field      */
	uint8_t   ether_data[];                 /* packet data               */
};

const struct libnet_ether_addr ether_broadcast = { {0xff, 0xff, 0xff, 0xff, 0xff, 0xff} };

/* === ARP === */
struct arp_t {
	uint16_t ar_hrd;
	uint16_t ar_pro;
	uint8_t ar_hln;
	uint8_t ar_pln;
	uint16_t ar_op;
	uint8_t ar_sha[6];
	uint8_t ar_sip[4];
	uint8_t ar_tha[6];
	uint8_t ar_tip[4];
};

struct arp_watch_info {
	struct libnet_ether_addr macaddr;
	uint32_t ipaddr;
	time_t time;
};

/* === IPv4 === */
#define IP_RF 0x8000                      /* reserved fragment flag    */
#define IP_DF 0x4000                      /* dont fragment flag        */
#define IP_MF 0x2000                      /* more fragments flag       */
#define IP_OFFMASK 0x1fff                 /* mask for fragmenting bits */

#ifndef IPPROTO_TCP
	#define IPPROTO_TCP 6                   /* Transmission Control Protocol */
#endif
#ifndef IPPROTO_UDP
	#define IPPROTO_UDP 17                  /* User Datagram Protocol        */
#endif
#ifndef IPPROTO_IPV6
	#define IPPROTO_IPV6 41                 /* IPv6 header                   */
#endif

struct ip4_t {
	uint8_t  ip_hdrlen:4;                   /* header length           */
	uint8_t  ip_vers:4;                     /* version                 */
	uint8_t  ip_tos;                        /* type of service         */
	uint16_t ip_total_len;                  /* total length            */
	uint16_t ip_id;                         /* identification          */
	uint16_t ip_offset;                     /* fragment offset field   */
	uint8_t  ip_ttl;                        /* time to live            */
	uint8_t  ip_proto;                      /* protocol                */
	uint16_t ip_sum;                        /* checksum                */
	uint8_t  ip_src_addr[4];                /* source address          */
	uint8_t  ip_dst_addr[4];                /* destination address     */
};

const uint32_t ip_broadcast = 0xffffffff;

/* === IPv6 === */
struct ip6_t {
	uint8_t  ip6_vers:4;                    /* 4 bit version */
	uint8_t  ip6_class:8;                   /* 8 bit TC */
	uint32_t ip6_flow:20;                   /* 20 bit flow-ID */
	uint16_t ip6_paylen;                    /* payload length */
	uint8_t  ip6_nextheader;                /* next header */
	uint8_t  ip6_hoplimit;                  /* hop limit */
	uint16_t ip6_src[8];                    /* source address */
	uint16_t ip6_dst[8];                    /* destination address */
};

/* === TCP === */
#  define TCP_FIN        0x01
#  define TCP_SYN        0x02
#  define TCP_RST        0x04
#  define TCP_PUSH       0x08
#  define TCP_ACK        0x10
#  define TCP_URG        0x20

struct tcp_t {
	uint16_t tcp_src_port;                  /* source port             */
	uint16_t tcp_dst_port;                  /* destination port        */
	uint32_t tcp_seqnr;                     /* sequence number         */
	uint32_t tcp_ack;                       /* acknowledgement number  */
	uint8_t  tcp_hdr_len:4;                 /* data offset             */
	uint8_t  tcp_x2:4;                      /* (unused)                */
	uint8_t  tcp_flags;                     /* flags                   */
	uint16_t tcp_winsize;                   /* window size             */
	uint16_t tcp_chksum;                    /* checksum                */
	uint16_t tcp_urgentptr;                 /* urgent pointer          */
};

/* === UDP === */
struct udp_t {
	uint16_t udp_src_port;
	uint16_t udp_dst_port;
	uint16_t udp_len;
	uint16_t udp_chksum;
	uint8_t  udp_data[];
};
