/*
 * DMCMain.java
 *
 * Author: Martin Christian <martin@christianix.de>
 * Created on 18. April 2003, 17:51
 */

package parser;

import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;

/**
 *
 * @author  mai01edz
 */
public class DMCMain extends javax.swing.JFrame {
	
	private String filename = null;
	private String dir = null;
	private DMCDataset data = null;
	private DMCStatistics statistics = null;
	private DMCMethod method = null;

	/** Creates new form DMCParser */
	public DMCMain() {
		initComponents();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
  private void initComponents() {//GEN-BEGIN:initComponents
    menubar = new javax.swing.JMenuBar();
    m_file = new javax.swing.JMenu();
    i_open = new javax.swing.JMenuItem();
    i_exit = new javax.swing.JMenuItem();
    m_tools = new javax.swing.JMenu();
    i_bayes = new javax.swing.JMenuItem();
    m_help = new javax.swing.JMenu();
    i_about = new javax.swing.JMenuItem();
    p_head = new javax.swing.JPanel();
    l_headline = new javax.swing.JLabel();
    p_middle = new javax.swing.JPanel();
    l_result = new javax.swing.JLabel();
    p_middle_n = new javax.swing.JPanel();
    sp_data = new javax.swing.JScrollPane();
    tbl_data = new javax.swing.JTable();
    p_middle_s = new javax.swing.JPanel();
    sp_result = new javax.swing.JScrollPane();
    tbl_result = new javax.swing.JTable();
    p_bottom = new javax.swing.JPanel();
    b_exit = new javax.swing.JButton();
    b_save = new javax.swing.JButton();

    m_file.setText("File");
    i_open.setText("Open");
    i_open.setActionCommand("iopen");
    i_open.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        menuActionHandler(evt);
      }
    });

    m_file.add(i_open);
    i_exit.setText("Exit");
    i_exit.setActionCommand("iexit");
    i_exit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        menuActionHandler(evt);
      }
    });

    m_file.add(i_exit);
    menubar.add(m_file);
    m_tools.setText("Tools");
    i_bayes.setText("Bayes");
    i_bayes.setActionCommand("ibayes");
    i_bayes.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        menuActionHandler(evt);
      }
    });

    m_tools.add(i_bayes);
    menubar.add(m_tools);
    m_help.setText("Help");
    i_about.setText("About");
    i_about.setActionCommand("iabout");
    i_about.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        menuActionHandler(evt);
      }
    });

    m_help.add(i_about);
    menubar.add(m_help);

    setTitle("DMC 2003");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });

    p_head.setLayout(new java.awt.BorderLayout());

    l_headline.setFont(new java.awt.Font("Default", 1, 14));
    l_headline.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    l_headline.setText("DMC Data Parser");
    p_head.add(l_headline, java.awt.BorderLayout.CENTER);

    getContentPane().add(p_head, java.awt.BorderLayout.NORTH);

    p_middle.setLayout(new java.awt.BorderLayout(10, 10));

    l_result.setFont(new java.awt.Font("Default", 1, 12));
    l_result.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    l_result.setText("Result Statistics:");
    p_middle.add(l_result, java.awt.BorderLayout.CENTER);

    p_middle_n.setLayout(new java.awt.BorderLayout());

    sp_data.setPreferredSize(new java.awt.Dimension(400, 100));
    tbl_data.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));
    tbl_data.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][] {
        {"n/a", new Integer(0), new Integer(0)},
        {"n/a", new Integer(0), new Integer(0)},
        {"n/a", new Integer(0), new Integer(0)}
      },
      new String [] {
        "Role", "Spam", "NoSpam"
      }
    ) {
      Class[] types = new Class [] {
        java.lang.String.class, java.lang.Integer.class, java.lang.Integer.class
      };

      public Class getColumnClass(int columnIndex) {
        return types [columnIndex];
      }
    });
    sp_data.setViewportView(tbl_data);

    p_middle_n.add(sp_data, java.awt.BorderLayout.NORTH);

    p_middle.add(p_middle_n, java.awt.BorderLayout.NORTH);

    p_middle_s.setLayout(new java.awt.BorderLayout());

    sp_result.setPreferredSize(new java.awt.Dimension(400, 100));
    tbl_result.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));
    tbl_result.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][] {
        {"n/a", null, null, null, null},
        {"n/a", null, null, null, null}
      },
      new String [] {
        "Role", "FalseSpam_n", "FalseSpam_p", "FalseNoSpam_n", "FalseNoSpam_p"
      }
    ) {
      Class[] types = new Class [] {
        java.lang.String.class, java.lang.Integer.class, java.lang.Double.class, java.lang.Integer.class, java.lang.Double.class
      };

      public Class getColumnClass(int columnIndex) {
        return types [columnIndex];
      }
    });
    sp_result.setViewportView(tbl_result);

    p_middle_s.add(sp_result, java.awt.BorderLayout.NORTH);

    p_middle.add(p_middle_s, java.awt.BorderLayout.SOUTH);

    getContentPane().add(p_middle, java.awt.BorderLayout.CENTER);

    this.setJMenuBar( menubar );
    b_exit.setText("Exit");
    b_exit.setActionCommand("exit");
    b_exit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        b_exitActionPerformed(evt);
      }
    });

    p_bottom.add(b_exit);

    b_save.setText("Save");
    b_save.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        b_saveActionPerformed(evt);
      }
    });

    p_bottom.add(b_save);

    getContentPane().add(p_bottom, java.awt.BorderLayout.SOUTH);

    pack();
  }//GEN-END:initComponents

	private void b_saveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_saveActionPerformed
		BufferedWriter spamidwriter = null;
		BufferedWriter passidwriter = null;
		BufferedWriter statwriter = null;
		DMCDataset statdata = null;
		int[] spamids;
		int[] vector;
		int i, j, n;

		if ( this.statistics != null ) {
			spamids = this.statistics.getSpamIDs();
			statdata = this.statistics.getDataset();
			if ( spamids != null ) {
				n = spamids.length;
				try {
					spamidwriter = new BufferedWriter( new FileWriter( this.dir+"spamids.txt") );
					passidwriter = new BufferedWriter( new FileWriter(this.dir+"passids.txt") );
					statwriter = new BufferedWriter( new FileWriter(this.dir+"statistics.txt") );

					// Write Spam IDs to file
					for ( i=0; i<n; i++ ) {
						spamidwriter.write( String.valueOf(spamids[i]) );
						spamidwriter.newLine();
					}
					spamidwriter.close();

					// Write NoSpam IDs to file
					n = statdata.getN();
					for ( i=0; i<n; i++ ) {
						vector = statdata.getRow( i );
						if ( Arrays.binarySearch(spamids, vector[0]) < 0 ) {
							passidwriter.write( String.valueOf(vector[0]) );
							passidwriter.newLine();
						}
					}
					passidwriter.close();

					// Write statistical information to file
					statwriter.write( "Actual data statistics\n" );
					statwriter.write( "======================\n" );
					statwriter.newLine();
					statwriter.write( "Observations: " );
					statwriter.write( String.valueOf(this.statistics.getTotal()) );
					statwriter.newLine();
					statwriter.write( "Attributes: " );
					statwriter.write( String.valueOf(this.data.getAttributes().length) );
					statwriter.newLine();
					statwriter.write( "Threshold: " );
					statwriter.write( String.valueOf( this.method.getThreshold()) );
					statwriter.newLine();
					statwriter.write( "Error Spam: " );
					statwriter.write( String.valueOf(this.statistics.getSpamError()) );
					statwriter.newLine();
					statwriter.write( "Error NoSpam: ");
					statwriter.write( String.valueOf(this.statistics.getNoSpamError()) );
					statwriter.newLine();

					statwriter.close();
				} catch ( IOException ioe ) {
					System.err.println( "Can't create output file!" );
					try {
						if ( spamidwriter != null ) spamidwriter.close();
						if ( passidwriter != null ) passidwriter.close();
						if ( statwriter != null ) statwriter.close();
					} catch ( IOException ioee ) {};
				}
			}
		}
		else System.out.println( "\nNo statistical data available!\n" );
	}//GEN-LAST:event_b_saveActionPerformed

	private void menuActionHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuActionHandler
		String cmd = evt.getActionCommand();

		if ( cmd.equals("iopen") ) {
			java.awt.FileDialog fd = new java.awt.FileDialog( 
				this, "File Open", java.awt.FileDialog.LOAD );
			fd.addWindowListener( new java.awt.event.WindowAdapter() {
				public void windowClosing( java.awt.event.WindowEvent evt ) {
					setVisible(false);
					dispose();
				}
			} );
			fd.setFilenameFilter( new java.io.FilenameFilter() {
				public boolean accept( java.io.File dir, String n) {
					return n.endsWith( ".txt" );
				}
			} );
			fd.show();
			this.filename = fd.getFile();
			this.dir = fd.getDirectory();

			if ( this.filename != null ) {
				data = new DMCDataset( this.dir + this.filename );
				tbl_data.setValueAt( "Total", 0, 0 );
				tbl_data.setValueAt( new Integer( data.getSpam() ), 0, 1 );
				tbl_data.setValueAt( new Integer( data.getNoSpam() ), 0, 2 );
			}
		}
		else if ( cmd.equals("iexit") ) {
			System.exit(0);
		}
		else if ( cmd.equals("ibayes") ) {
			DMCMethodDialog mdialog;
			DMCDataset[] datasets;
			double alpha;
			double partition;
			boolean training;
			boolean application;

			mdialog = new DMCMethodDialog( this, true );
			mdialog.show();
			if ( mdialog.isCanceled() ) return;

			try {
				alpha = mdialog.getAlpha();
			}
			catch ( NumberFormatException nfe ) {
				System.err.println( "Alpha not a valid double! Using default..." );
				alpha = 0.95;
			}
			partition = mdialog.getPartitioning();
			training = mdialog.isTraining();
			application = mdialog.isApplication();

			if ( partition <= 0.0 ) {
				datasets = new DMCDataset[2];
				datasets[0] = data;
				datasets[1] = data;
			}
			else datasets = this.data.splitData( partition );

			// Show dataset information
			tbl_data.setValueAt( "Train", 1, 0 );
			tbl_data.setValueAt( new Integer( datasets[0].getSpam() ), 1, 1 );
			tbl_data.setValueAt( new Integer( datasets[0].getNoSpam() ), 1, 2 );
			
			tbl_data.setValueAt( "Test", 2, 0 );
			tbl_data.setValueAt( new Integer( datasets[1].getSpam() ), 2, 1 );
			tbl_data.setValueAt( new Integer( datasets[1].getNoSpam() ), 2, 2 );
			
			// Train and show results
			if ( training ) {
				this.method = new DMCBayes( alpha );
				this.statistics = method.eval( datasets[0], DMCMethod.DMC_ALL );
				tbl_result.setValueAt( "Train", 0, 0 );
				tbl_result.setValueAt( new Integer( statistics.getFalseSpam() ), 0, 1 );
				tbl_result.setValueAt( new Double( statistics.getSpamError() ), 0, 2 );
				tbl_result.setValueAt( new Integer( statistics.getFalseNoSpam() ), 0, 3 );
				tbl_result.setValueAt( new Double( statistics.getNoSpamError() ), 0, 4 );
			}

			// Apply and show results
			if ( application ) {
				if ( this.method != null ) {
					this.method.setThreshold( alpha );
					this.statistics = this.method.eval( datasets[1], DMCMethod.DMC_APPLY );
					tbl_result.setValueAt( "Test", 1, 0 );
					tbl_result.setValueAt( new Integer( statistics.getFalseSpam() ), 1, 1 );
					tbl_result.setValueAt( new Double( statistics.getSpamError() ), 1, 2 );
					tbl_result.setValueAt( new Integer( statistics.getFalseNoSpam() ), 1, 3 );
					tbl_result.setValueAt( new Double( statistics.getNoSpamError() ), 1, 4 );
				}
				else
					System.out.println( "Can't apply model, there was no training before!" );
			}
		}
		else if ( cmd.equals("iabout") ) {
			DMCAbout ad = new DMCAbout( this, false );
			ad.show();
		}
	}//GEN-LAST:event_menuActionHandler

	private void b_exitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_exitActionPerformed
			System.exit(0);
	}//GEN-LAST:event_b_exitActionPerformed
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
		System.exit(0);
	}//GEN-LAST:event_exitForm

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		new DMCMain().show();
	}
	
	
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuItem i_about;
  private javax.swing.JLabel l_result;
  private javax.swing.JMenuItem i_bayes;
  private javax.swing.JMenuBar menubar;
  private javax.swing.JMenuItem i_exit;
  private javax.swing.JPanel p_middle_n;
  private javax.swing.JPanel p_middle_s;
  private javax.swing.JLabel l_headline;
  private javax.swing.JScrollPane sp_result;
  private javax.swing.JScrollPane sp_data;
  private javax.swing.JPanel p_bottom;
  private javax.swing.JPanel p_middle;
  private javax.swing.JTable tbl_data;
  private javax.swing.JButton b_save;
  private javax.swing.JTable tbl_result;
  private javax.swing.JMenu m_file;
  private javax.swing.JButton b_exit;
  private javax.swing.JMenu m_help;
  private javax.swing.JMenuItem i_open;
  private javax.swing.JPanel p_head;
  private javax.swing.JMenu m_tools;
  // End of variables declaration//GEN-END:variables

}
