/*
 * DMCCleaner.java
 *
 * Author: Martin Christian <martin@christianix.de>
 * Created on 1. Mai 2003, 23:57
 */

package parser;

import java.io.*;
import java.util.*;

/**
 *
 * @author  mai01edz
 */
public class DMCCleaner {

	String[] lables;
	int[][] table;
	int[] occurrences;
	int m, n;

	/** Creates a new instance of DMCCleaner */
	public DMCCleaner() {
	}

	public void read( String filename ) {
		StringTokenizer tokenizer = null;
		BufferedReader reader = null;
		String line;
		int i, j, input;

		try {
			reader = new BufferedReader( new FileReader(filename) );
			line = reader.readLine();
			tokenizer = new StringTokenizer( line );
			m = tokenizer.countTokens();
			lables = new String[m];
			
			// read column lables
			for ( i=0; i<m; i++ ) lables[i] = tokenizer.nextToken();

  		// count lines
			n=0;
			while ( (line=reader.readLine()) != null ) n++;
			reader.close();
			reader = new BufferedReader( new FileReader(filename) );
			line = reader.readLine();

			// read data
			table = new int[n][m];
			for ( i=0; i<n; i++ ) {
				line = reader.readLine();
				tokenizer = new StringTokenizer( line );
				for ( j=0; j<m; j++ ) {
					input = Integer.parseInt( tokenizer.nextToken() );
					table[i][j] = input;
				}
			}
		} catch ( IOException ioe ) {
			  try {
				  if ( reader != null ) reader.close();
				} catch ( IOException e ) {}
				ioe.printStackTrace();
				System.exit(-1);
		} catch ( NumberFormatException nfe ) {
				nfe.printStackTrace();
				System.exit(-1);
		}
	  try {
		  if ( reader != null ) reader.close();
		} catch ( IOException e ) {}
	}

	public void clean() {
		int i, j;
		occurrences = new int[m];
		for ( j=1; j<m; j++ ) {
			occurrences[j] = 0;
			for ( i=0; i<n; i++ ) occurrences[j] += table[i][j];
		}
	}

	public void write( String filename ) {
		BufferedWriter writer = null;
		BufferedWriter deleted = null;
		StringBuffer linewriter = null;
		StringBuffer linedeleted = null;
		int i, j;

		try {
			writer = new BufferedWriter( new FileWriter(filename) );
			deleted = new BufferedWriter( new FileWriter(filename+".deleted") );
			linewriter = new StringBuffer( lables[0] );
			linedeleted = new StringBuffer();
			for ( j=1; j<m; j++ ) {
				if ( occurrences[j] == 0 ) linedeleted.append( "\n"+lables[j] );
				else linewriter.append( " "+lables[j] );
			}
			writer.write( linewriter.toString() );
			deleted.write( linedeleted.toString().trim() );
			writer.newLine();
			deleted.newLine();
			deleted.close();

			for ( i=0; i<n; i++ ) {
				linewriter.delete( 0, linewriter.length() );
				linewriter.append( table[i][0] );
				for ( j=1; j<m; j++ ) {
					if ( occurrences[j] > 0 )
						linewriter.append( " "+String.valueOf(table[i][j]) );
				}
				writer.write( linewriter.toString().trim() );
				writer.newLine();
			}
			writer.close();
		} catch ( IOException ioe ) {
			  try {
				  if ( writer != null ) writer.close();
				  if ( deleted != null ) deleted.close();
				} catch ( IOException e ) {}
				ioe.printStackTrace();
				System.exit(-1);
		}
	}

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		DMCCleaner cleaner = new DMCCleaner();
		cleaner.read( "data.csv" );
		cleaner.clean();
		cleaner.write( "data-new.csv" );
	}
}
