#ifndef _L4_SYSTEM_H
#define _L4_SYSTEM_H

#include <asm/macros.h>
#include <asm/percpu.h>
#include <linux/smp.h>
#include <linux/linkage.h>

struct task_struct;
extern asmlinkage void *__switch_to(struct task_struct *prev, struct task_struct *next);

#include <l4/kdebug.h>

extern DEFINE_PER_CPU(unsigned long, _l4_irq_state);
#define IRQ_state(cpu) (per_cpu(_l4_irq_state, cpu))

#define switch_to(prev,next,last)		\
do {						\
	(last) = __switch_to(prev, next);	\
} while(0)


// FIXME: Implement these
static inline void local_irq_enable(void)
{
	IRQ_state(smp_processor_id()) = 0;
}

static inline void local_irq_disable(void)
{
	IRQ_state(smp_processor_id()) = 1;
}

#define local_save_flags(x)			\
do {						\
	x = IRQ_state(smp_processor_id());	\
} while (0)

#define local_irq_save(x)			\
do {						\
	x = IRQ_state(smp_processor_id());	\
	local_irq_disable();			\
} while (0)

#define local_irq_restore(flags)		\
do {						\
	IRQ_state(smp_processor_id()) = flags;	\
} while (0)

#define irqs_disabled()		IRQ_state(smp_processor_id())

#include INC_SYSTEM2(system.h)

#endif /* _L4_SYSTEM_H */
