#ifndef _ASM_L4_SIGNAL_L4_H_
#define _ASM_L4_SIGNAL_L4_H_


extern int l4_do_signal(sigset_t *oldset, int syscall);

static inline int need_syscall_trace(void)
{
	return unlikely(test_thread_flag(TIF_SYSCALL_TRACE));
}

extern void do_syscall_trace(int, void *);

extern inline void
syscall_entry(void)
{
	if (need_syscall_trace())
	{
		local_irq_enable();
//printk("%s (%d): syscall entry trace\n", current->comm, current->pid);
#ifdef CONFIG_ARCH_ARM
		do_syscall_trace(0, current_regs());
#endif
		local_irq_disable();
	}
}

extern inline void
syscall_exit(int syscall)
{
	if (syscall && need_syscall_trace())
	{
		local_irq_enable();
//printk("%s (%d): syscall exit trace\n", current->comm, current->pid);
#ifdef CONFIG_ARCH_ARM
		do_syscall_trace(1, current_regs());
#endif
		local_irq_disable();
	}
}

extern inline int
work_pending(int syscall)
{
	if (need_resched()) {
		schedule();
	}

	if (signal_pending(current)) {
		return l4_do_signal(NULL, syscall);
	}
	return 0;
}

extern inline int
work_pending_preempt(void)
{
	if (need_resched()) {
		/* Prevent current from running */
		//int r = L4_Set_Priority(current_thread_info()->user_tid, 0);
		//assert(r != 0);
		L4_Stop_Thread (current_thread_info()->user_tid);

		schedule();

		//r = L4_Set_Priority(current_thread_info()->user_tid, 98);
		//assert(r != 0);
		L4_Start(current_thread_info()->user_tid);
	}

	if (signal_pending(current)) {
		return l4_do_signal(NULL, 0);
	}
	return 0;
}

#endif /* _ASM_L4_SIGNAL_L4_H_ */
