#ifndef __L4_I386_PROCESSOR_H
#define __L4_I386_PROCESSOR_H

#define cpu_relax()	barrier()

struct thread_struct {
};

#define INIT_THREAD  { }

/*
 * User space process size: 2GB. This is hardcoded into a few places,
 * so don't change it unless you know what you are doing.
 */
#define TASK_SIZE	0x7fff8000UL

/*
 * This decides where the kernel will search for a free chunk of vm
 * space during mmap's.
 */
#define TASK_UNMAPPED_BASE	(PAGE_ALIGN(TASK_SIZE / 3))

/*
 * This decides where the kernel will map the __wombat_user_sig_handler
 * page to for signal and thread startup/modification.
 * This must not conflict with the utcb and kip area setup in
 * arch/l4/kernel/setup.c
 */
#define TASK_SIG_BASE	(0x98765000UL)

#endif /* __L4_I386_PROCESSOR_H */
