#ifndef __UM_BUG_H
#define __UM_BUG_H

#ifndef __ASSEMBLY__

#include <iguana/pd.h>

#define BUG() do { \
	/*panic("kernel BUG at %s:%d!\n", __FILE__, __LINE__);*/ \
	printk("kernel BUG at %s:%d!\n", __FILE__, __LINE__); \
	pd_delete(pd_myself());	\
} while (0)

#define BUG_ON(condition) do { \
	if (unlikely((condition)!=0)) \
		BUG(); \
} while(0)

#define PAGE_BUG(page) do { \
	BUG(); \
} while (0)

#define WARN_ON(condition) do { \
	if (unlikely((condition)!=0)) { \
		printk("Badness in %s at %s:%d\n", __FUNCTION__, __FILE__, __LINE__); \
		dump_stack(); \
	} \
} while (0)

extern int foo;

#endif

#endif
