#ifndef _L4_ARM_EXCEPTION_H_
#define _L4_ARM_EXCEPTION_H_

inline void l4_arch_handle_exception(struct pt_regs *regs)
{
	if ( (ARM_EXCEPT_number(regs) & 0xff0) == 0x100 )
	{
		printk(KERN_INFO "arm mmu fault (fs = %ld) @ %lx in: %s (%d)\n",
				ARM_EXCEPT_number(regs) & 0x0f,
				ARM_EXCEPT_pc(regs), current->comm, current->pid);
	} else {
		switch ( ARM_EXCEPT_number(regs) ) {
		case 1:
			printk(KERN_INFO "undefined instruction @ %lx in: %s (%d)\n",
					ARM_EXCEPT_pc(regs), current->comm, current->pid);
			break;
		default:
			printk(KERN_INFO "unhandled user exception (%lx) in %s (%d)\n",
					ARM_EXCEPT_number(regs), current->comm, current->pid);
		}
	}
	send_sig(SIGILL, current, 1);
}

#endif /* _L4_ARM_EXCEPTION_H_ */
