/*********************************************************************
 *                
 * Copyright (C) 2004,  National ICT Australia
 *                
 ********************************************************************/

#include <asm/constants.h>
#include <asm-i386/errno.h>
#include <asm-i386/unistd.h>
#include <l4/ia32/vregs_asm.h>

	.section .exregspage
	.global __wombat_user_sig_fault;
__wombat_user_sig_fault:
	ret

	.global __wombat_user_fork_handler;
__wombat_user_fork_handler:
	movl	%gs:0,	%eax	    /* Get utcb pointer */
	movl	(__L4_TCR_USER_DEFINED_HANDLE*4)(%eax), %eax	/* Load user defined handle */
	add	$2,	%eax	    /* handle = fork-ip - 2, so add 2 */
	movl	%eax,	-8(%esp)    /* store on the stack so we can clear eax */
	movl	$0,	%eax
	jmpl	*-8(%esp)	    /* Jump to fork-ip */

	.global __wombat_user_sigentry_int;
__wombat_user_sigentry_int:
	movl	$-EINTR,    %eax

	.global __wombat_user_sigentry_restart;
__wombat_user_sigentry_restart:
	movl	%eax, L4_SIGFRAME_EAX_OFFSET(%esp)

	.global __wombat_user_sigentry;
__wombat_user_sigentry:
	movl	%edi, L4_SIGFRAME_EDI_OFFSET(%esp)
	movl	%esi, L4_SIGFRAME_ESI_OFFSET(%esp)
	movl	%ebp, L4_SIGFRAME_EBP_OFFSET(%esp)
	movl	%ebx, L4_SIGFRAME_EBX_OFFSET(%esp)
	movl	%ecx, L4_SIGFRAME_ECX_OFFSET(%esp)
	movl	%edx, L4_SIGFRAME_EDX_OFFSET(%esp)

	jmpl	*L4_SIGFRAME_SIGIP_OFFSET(%esp)

	.global __wombat_user_sigreturn;
__wombat_user_sigreturn:
	popl %eax		/* XXX does this mean it needs unwind info? */
	movl $__NR_sigreturn, %eax
	int $0x80

	.global __wombat_user_rt_sigentry_int;
__wombat_user_rt_sigentry_int:
	movl	$-EINTR,    %eax

	.global __wombat_user_rt_sigentry_restart;
__wombat_user_rt_sigentry_restart:
	movl	%eax, L4_SIGRTFRAME_EAX_OFFSET(%esp)

	.global __wombat_user_rt_sigentry;
__wombat_user_rt_sigentry:
	movl	%edi, L4_SIGRTFRAME_EDI_OFFSET(%esp)
	movl	%esi, L4_SIGRTFRAME_ESI_OFFSET(%esp)
	movl	%ebp, L4_SIGRTFRAME_EBP_OFFSET(%esp)
	movl	%ebx, L4_SIGRTFRAME_EBX_OFFSET(%esp)
	movl	%ecx, L4_SIGRTFRAME_ECX_OFFSET(%esp)
	movl	%edx, L4_SIGRTFRAME_EDX_OFFSET(%esp)

	jmpl	*L4_SIGRTFRAME_SIGIP_OFFSET(%esp)

	.global __wombat_user_rt_sigreturn;
__wombat_user_rt_sigreturn:
	movl $__NR_rt_sigreturn, %eax
	int $0x80

	.global __wombat_user_sigrestore;
__wombat_user_sigrestore:
	movl	L4_RESTORE_EDI_OFFSET(%esp), %edi
	movl	L4_RESTORE_ESI_OFFSET(%esp), %esi
	movl	L4_RESTORE_EBP_OFFSET(%esp), %ebp
	movl	L4_RESTORE_EAX_OFFSET(%esp), %eax
	movl	L4_RESTORE_EBX_OFFSET(%esp), %ebx
	movl	L4_RESTORE_ECX_OFFSET(%esp), %ecx
	movl	L4_RESTORE_EDX_OFFSET(%esp), %edx
                                                 
	movl	L4_RESTORE_ESP_OFFSET(%esp), %esp

	jmpl	*L4_RESTORE_FRAME_EPC_OFFSET(%esp)

