#include <l4.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <asm/bug.h>

#define PCMCIA_IO_0_BASE 0x20000000
#define MECR_BASE	 0xA0000000
#define MECR		 0x00000018

#define GP_BASE		0x90040000
#define GPDR		0x00000004
#define GPCR		0x0000000C

#define GPIO_GPIO(Nb)                   /* GPIO [0..27]                    */ \
                        (0x00000001 << (Nb))

#define GPIO_ETH0_EN		GPIO_GPIO (26)
#define GPIO_ETH0_IRQ		GPIO_GPIO (21)

static unsigned long arm_io_encode(unsigned long port);
static void arm_barrier(void);

struct io_space io_space[1] = {
    { -1ul, arm_io_encode, arm_barrier },
};

void l4_init_io_space(unsigned int num)
{
#if 0
	unsigned long mecr_base, gp_base;
	if (num != 0)
		BUG();

	//io_space[num].mmio_base = l4e_request_uncached_area(
	//		PCMCIA_IO_0_BASE, 0x1000 );

	if (io_space[num].mmio_base == -1ul)
		BUG();

	if (num == 0)
	{
		//mecr_base = l4e_request_uncached_area(
		//		MECR_BASE, 0x1000 );

		*((volatile unsigned long *)(mecr_base + MECR)) =
			((2<<10) | (2<<5) | (2<<0));

		//gp_base = l4e_request_uncached_area(
		//		GP_BASE, 0x1000 );

		*((volatile unsigned long *)(gp_base + GPDR)) |= GPIO_ETH0_EN;   /* set to output */
		*((volatile unsigned long *)(gp_base + GPCR)) = GPIO_ETH0_EN;   /* clear MCLK (enable smc) */

//		*((volatile unsigned long *)(gp_base + GPDR)) &= ~GPIO_ETH0_IRQ;
//		        set_GPIO_IRQ_edge( GPIO_ETH0_IRQ, GPIO_FALLING_EDGE);
	}
#endif
}

static unsigned long arm_io_encode(unsigned long port)
{
	return port;
}

static void arm_barrier(void)
{
}


