#include "assert.h"

#include <iguana/eas.h>
#include <iguana/thread.h>

#include <linux/init.h>
#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/mmu_context.h>

extern L4_Fpage_t kip_area, utcb_area;

void activate_mm(struct mm_struct *old, struct mm_struct *new)
{
	L4_ThreadId_t old_thrd = current_thread_info()->user_tid;
	//printk("%s: %p, old = %p, new = %p\n", __func__, current->thread_info, old, new);

	if (old_thrd.raw != L4_nilthread.raw)
	{
		int r;
		thread_delete(old_thrd);
		current_thread_info()->user_tid =
			eas_create_thread(new->context,
					L4_Myself(), L4_Myself(),
					(void*) L4_Address(utcb_area));

		assert(current_thread_info()->user_tid.raw != 0);
		r  = L4_Set_Priority(current_thread_info()->user_tid, 98);
		assert(r != 0);

		{
			char name[16];
			snprintf(name, 15, "L_%d", current->pid);
			L4_KDB_SetThreadName(current_thread_info()->user_tid, name);
		}

	}

}

int init_new_context(struct task_struct *task, struct mm_struct *mm)
{
	//printk("%s: %p mm=%p\n", __func__, task->thread_info, mm);
	/* Create new space */
	mm->context = eas_create(kip_area, utcb_area);
	if (!mm->context)
		return -ENOMEM;
	return 0;
}

void destroy_context(struct mm_struct *mm)
{
	//printk("%s: %p\n", __func__, mm);
	eas_delete(mm->context);
	mm->context = 0;
}

void deactivate_mm(struct task_struct *tsk, struct mm_struct *mm)
{
	//printk("%s: %p mm=%p\n", __func__, task->thread_info, mm);
	L4_ThreadId_t tid = tsk->thread_info->user_tid;

	tsk->thread_info->user_tid = L4_nilthread;

	if ((tid.raw != L4_nilthread.raw)) {
		thread_delete(tid);
	}
}
