/*
 *  linux/arch/l4/mm/iguanamap.c
 *
 *  Copyright (C) 2004-2005, National ICT Australia
 *	Carl van Schaik
 *
 *  Taken from m32r version.
 *    (C) Copyright 2001, 2002  Hiroyuki Kondo
 *    (C) Copyright 1995 1996 Linus Torvalds
 *    (C) Copyright 2001 Ralf Baechle
 */

/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 */

#include <linux/module.h>
#include <asm/byteorder.h>

#include <linux/vmalloc.h>
#include <asm/io.h>
#include <asm/pgalloc.h>
#include <asm/cacheflush.h>
#include <asm/tlbflush.h>

#include <iguana/hardware.h>
#include <iguana/memsection.h>

/*
 * Generic mapping function (not visible outside):
 */

static int
map_iguana_phys_pages(unsigned long *address, unsigned long phys_addr,
		 unsigned long size, unsigned long flags)
{
	int error = 0;
	unsigned long memsection;
	unsigned long base;

	/* Let us actually allocate the backed memory.. */
	memsection = memsection_create_user(size, &base);
	if (memsection == 0) {
		return -EACCES;	// return access denied
	}

	/* FIXME: These should be passed into the server properly */
//	hardware_back_memsection(memsection, phys_addr, ((flags >> 4) & 3));
	hardware_back_memsection(memsection, phys_addr, 0);

	*address = base;

	return error;
}

/*
 * Map an arbitrary physical address space into the wombat "physical"
 * address space. Needed when the kernel wants to access hardware physical
 * memory directly.
 *
 * NOTE! We need to allow non-page-aligned mappings too: we will obviously
 * have to convert them into an offset in a page-aligned mapping, but the
 * caller shouldn't need to know that small detail.
 */

void *
iguana_map_phys(unsigned long phys_addr, unsigned long size, unsigned long flags)
{
	unsigned long addr;
	unsigned long offset, last_addr;

	/* Don't allow wraparound or zero size */
	last_addr = phys_addr + size - 1;
	if (!size || last_addr < phys_addr)
		return NULL;

	/*
	 * Mappings have to be page-aligned
	 */
	offset = phys_addr & ~PAGE_MASK;
	phys_addr &= PAGE_MASK;
	size = PAGE_ALIGN(last_addr + 1) - phys_addr;

	/*
	 * Ok, go for it..
	 */
	addr = 0;
	if (map_iguana_phys_pages(&addr, phys_addr, size, flags)) {
		vunmap((void __force *) addr);
		return NULL;
	}

	return (void *) (offset + (char *)addr);
}

void
iguana_unmap(volatile void *addr)
{
	// XXX unmap

	return;
}

