#include <asm-generic/vmlinux.lds.h>
#include <linux/config.h>

OUTPUT_ARCH(ELF_ARCH)
ENTRY(_start)
jiffies = jiffies_64;
SECTIONS
{
  . = 0x1000			;
#ifdef CONFIG_ARCH_MIPS64
#define PAGE_SIZE	4096
#endif
#ifdef CONFIG_ARCH_ARM
#define PAGE_SIZE	4096
#endif
#ifdef CONFIG_ARCH_I386
#define PAGE_SIZE	4096
#endif
  /* read-only */
  .text : {
    _text = .;			/* Text and read-only data */
    *(.text)
    SCHED_TEXT
    LOCK_TEXT
    *(.fixup)
    *(.gnu.warning)
    . = ALIGN(PAGE_SIZE);
    __user_exregs_page = .;
    *(.exregspage)
    . = ALIGN(PAGE_SIZE);
  } =0

  _etext = .;

  . = ALIGN(16);		/* Exception table */
  __start___ex_table = .;
  __ex_table : { *(__ex_table) }
  __stop___ex_table = .;

  RODATA

  . = ALIGN(PAGE_SIZE); 
	
  .data : {			/* Data */
   /* Align the initial ramdisk image (INITRD) on page boundaries. */
/*
   __rd_start = .;
   *(.initrd)
   . = ALIGN(PAGE_SIZE);
   __rd_end = .;
*/

    *(.data)

    CONSTRUCTORS
   . = ALIGN(PAGE_SIZE);
  }

  . = ALIGN(32);
  .data.cacheline_aligned : { *(.data.cacheline_aligned) }

  .unprotected : { *(.unprotected) }
  . = ALIGN(PAGE_SIZE);
  PROVIDE (_unprotected_end = .);
  __start___param = .;
  __param : { *(__param) }
  __stop___param = .;

  . = ALIGN(32);
  __per_cpu_start = . ; 
  .data.percpu : { *(.data.percpu) }
  __per_cpu_end = . ;

  _edata = .;			/* End of data section */

  /* will be freed after init */
  . = ALIGN(PAGE_SIZE);		/* Init code and data */
  __init_begin = .;
  /* /DISCARD/ doesn't work for .reginfo */
  .reginfo : { *(.reginfo) }
  .init.text : {
	_sinittext = .;
	*(.init.text)
	_einittext = .;
  }
  .init.data : { *(.init.data) }
  . = ALIGN(16);
  __setup_start = .;
  .init.setup : { *(.init.setup) }
  __setup_end = .;

  . = ALIGN(16);
  __initcall_start = .;
  .initcall.init : {
	*(.initcall1.init)
	*(.initcall2.init)
	*(.initcall3.init)
	*(.initcall4.init)
	*(.initcall5.init)
	*(.initcall6.init)
	*(.initcall7.init)
  }
  __initcall_end = .;
  __con_initcall_start = .;
  .con_initcall.init : { *(.con_initcall.init) }
  __con_initcall_end = .;
  SECURITY_INIT
  . = ALIGN(PAGE_SIZE);
  __initramfs_start = .;
  .init.ramfs : { *(.init.ramfs) }
  __initramfs_end = .;
  . = ALIGN(PAGE_SIZE);
  __init_end = .;
  /* freed after init ends here */

  __exitcall_begin = .;
  .exitcall : { *(.exitcall.exit) }
  __exitcall_end = .;
}
