/*
 *	linux/arch/l4/kernel/sys_iguana.c
 */

#define timer_t	    timer_t_linux
#include <l4.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/init.h>
#undef timer_t

#include <iguana/memsection.h>
#include <iguana/thread.h>

#include <naming/naming.h>

#include <timer/timer.h>

#include "assert.h"
#include "irq_impl.h"

#include <cb.h>

/*
 * Iguana generic
 */

/*
 * Iguana supports up to N CPUs
 */
#if 0
static unsigned long iguana_cpu_irq_affinity[4] = { ~0UL, ~0UL, ~0UL, ~0UL };
#endif

/*
 * Mask is set (1) if enabled
 */
static unsigned long iguana_cached_irq_mask;

/*
 * Need SMP-safe access to interrupt CSRs
 */
spinlock_t iguana_irq_lock = SPIN_LOCK_UNLOCKED;

static void
iguana_update_irq_hw(unsigned long mask)
{
	// XXX write me
#ifdef CONFIG_SMP
#else
#endif
}

static inline void
iguana_enable_irq(unsigned int irq)
{
	spin_lock(&iguana_irq_lock);
	iguana_cached_irq_mask |= 1UL << (irq);
	iguana_update_irq_hw(iguana_cached_irq_mask);
	spin_unlock(&iguana_irq_lock);
}

static inline void
iguana_disable_irq(unsigned int irq)
{
	spin_lock(&iguana_irq_lock);
	iguana_cached_irq_mask &= ~(1UL << (irq));
	iguana_update_irq_hw(iguana_cached_irq_mask);
	spin_unlock(&iguana_irq_lock);
}

static unsigned int
iguana_startup_irq(unsigned int irq)
{
	iguana_enable_irq(irq);
	return 0;	/* never anything pending */
}

static void
iguana_end_irq(unsigned int irq)
{
	if (!(irq_desc[irq].status & (IRQ_DISABLED|IRQ_INPROGRESS)))
		iguana_enable_irq(irq);
}

static void
iguana_cpu_set_irq_affinity(unsigned int irq, cpumask_t affinity)
{
	// XXX fixme
	printk("%s called\n", __func__);
#if 0
	int cpu;

	for (cpu = 0; cpu < 4; cpu++) {
		if (affinity & (1UL << cpu))
			iguana_cpu_irq_affinity[cpu] |= 1UL << irq;
		else
			iguana_cpu_irq_affinity[cpu] &= ~(1UL << irq);
	}
#endif
}

static void
iguana_set_irq_affinity(unsigned int irq, cpumask_t affinity)
{ 
	spin_lock(&iguana_irq_lock);
	iguana_cpu_set_irq_affinity(irq, affinity);
	iguana_update_irq_hw(iguana_cached_irq_mask);
	spin_unlock(&iguana_irq_lock);
}

#if 0
static void
iguana_device_interrupt(unsigned long vector, struct pt_regs * regs)
{
	printk("iguana_device_interrupt: NOT IMPLEMENTED YET!! \n");
}
#endif

static void __init
init_iguana_irqs(struct hw_interrupt_type * ops, int imin, int imax)
{
	long i;
	for (i = imin; i <= imax; ++i) {
		irq_desc[i].status = IRQ_DISABLED | IRQ_LEVEL;
		irq_desc[i].handler = ops;
	}
}

static struct hw_interrupt_type iguana_irq_type = {
       .typename       = "iguana",
       .startup        = iguana_startup_irq,
       .shutdown       = iguana_disable_irq,
       .enable         = iguana_enable_irq,
       .disable        = iguana_disable_irq,
       .ack            = iguana_disable_irq,
       .end            = iguana_end_irq,
       .set_affinity   = iguana_set_irq_affinity,
};

#if 0
static irqreturn_t
iguana_intr_nop(int irq, void *dev_id, struct pt_regs *regs)                    
{
      /*
       * This is a NOP interrupt handler for the purposes of
       * event counting -- just return.
       */                                                                     
       return IRQ_HANDLED;
}
#endif

static void __init
iguana_init_irq(void)
{
	iguana_update_irq_hw(0);

	init_iguana_irqs(&iguana_irq_type, 0, NR_IRQS-1);
}
  
void __init
init_IRQ(void)
{
	iguana_init_irq();
}

void
iguana_dispatch_irqs(u64 mask, struct pt_regs *regs)
{
//	unsigned long vector;

	/*
	 * Mask down to those interrupts which are enable on this processor
	 */
#if 0
	mask &= iguana_cpu_irq_affinity[smp_processor_id()];
#endif

	/*
	 * Dispatch all requested interrupts 
	 */
	while (mask) {
		/* dispatch it */
		printk("xxx deliver interrupt\n");
	}
}
  
/*
 * Iguana Family
 */
extern uintptr_t temp_cap_slot;
extern uintptr_t temp_cap_used;
extern uintptr_t temp_cap_size;
extern uintptr_t temp_cap_addr;

extern void 
__cap_init(uintptr_t cap_slot, uintptr_t cap_used, uintptr_t cap_size, uintptr_t cap_addr);

memsection_ref_t vmalloc_memsect;
uintptr_t vmalloc_start, vmalloc_end;

static int __init
iguana_arch_init(void)
{
	uintptr_t ignore;
	objref_t vmalloc_obj;
	/*
	 * Enable the system error interrupts. These interrupts are 
	 * all reported to the kernel as machine checks, so the handler
	 * is a nop so it can be called to count the individual events.
	 */

	/* 
	   FIXME: We need to setup capabilties library properly now!
	   Ideally we would do this really early, but this is about as early
	   as we get! 
	*/
	__cap_init(temp_cap_slot, temp_cap_used, temp_cap_size, temp_cap_addr);

	vmalloc_obj = naming_lookup("vmalloc_area");
	assert(vmalloc_obj != 0);

	vmalloc_memsect = memsection_lookup(vmalloc_obj, &ignore);
	assert(vmalloc_memsect != 0);

	vmalloc_start = (uintptr_t)memsection_base(vmalloc_memsect);
	assert(vmalloc_start != 0);
	vmalloc_end = vmalloc_start + memsection_size(vmalloc_memsect) - 1;

	return 0;
}

arch_initcall(iguana_arch_init);

#if 0
static int __devinit
iguana_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{
	u8 intline;
	int irq;

 	/* Get the current intline.  */
	pci_read_config_byte(dev, PCI_INTERRUPT_LINE, &intline);
	irq = intline;

 	/* Is it explicitly routed through ISA?  */
 	if ((irq & 0xF0) == 0xE0)
 		return irq;
 
 	/* Offset by 16 to make room for ISA interrupts 0 - 15.  */
 	return irq + 16;
}

static void __init
iguana_init_pci(void)
{
 	/*
 	 * This isn't really the right place, but there's some init
 	 * that needs to be done after everything is basically up.
 	 */
// 	iguana_late_init();
 
	pci_probe_only = 1;
	common_init_pci();
	SMC669_Init(0);
#ifdef CONFIG_VGA_HOSE
	locate_and_init_vga(NULL);
#endif
}

/*
 * Privateer
 */
static void __init
privateer_init_pci(void)
{
	/*
	 * Hook a couple of extra err interrupts that the
	 * common iguana code won't.
	 */
	request_irq(53+16, iguana_intr_nop, SA_INTERRUPT, 
		    "NMI", NULL);
	request_irq(50+16, iguana_intr_nop, SA_INTERRUPT, 
		    "Temperature Warning", NULL);

	/*
	 * Finish with the common version.
	 */
	return iguana_init_pci();
}
#endif


extern L4_ThreadId_t main_thread;
extern void * __callback_buffer;
void l4e_serial_receive_chars(char *addr, int length);


void
interrupt_loop(void)
{
	timer_t timer;//, timer_ret;
	int r;
#ifdef CONFIG_L4E_CONSOLE
	struct cb_get_handle *iguana_cb_handle;
	struct cb_get_handle _iguana_cb_handle;

	/* Console session hack! */
	struct cb_get_handle *console_cb_handle;
	struct cb_get_handle _console_cb_handle;

	int console_attached  = 0;
#endif
	/* Wait for wake up messge from timer init */
	L4_Receive(main_thread);

#ifdef CONFIG_L4E_CONSOLE
	iguana_cb_handle = &_iguana_cb_handle;
	console_cb_handle = &_console_cb_handle;
	cb_attach_allocated(__callback_buffer, iguana_cb_handle);
#endif
	timer_init();

	timer = timer_create();
	assert(timer != NULL);

	r = timer_request(timer, MILLISECS(10), TIMER_PERIODIC);
	assert(r == 0);

	while(1) {
		int timeout = 0;
#ifdef CONFIG_L4E_CONSOLE
		uintptr_t *size;
	
		size = cb_get(iguana_cb_handle, sizeof(uintptr_t));
		if (size) {
			uintptr_t *cmd;
			cmd = cb_get(iguana_cb_handle, *size);
			if (*cmd == 0x37) {
				cmd++;
				printk("Session with thread: %lx\n", *cmd);
			} 
			if (*cmd == 0x38) {
				uintptr_t call_buf, return_buf;
				cmd++;
				call_buf = *cmd;
				cmd++;
				return_buf = *cmd;
				cb_attach_allocated((void*) call_buf, console_cb_handle);
				console_attached = 1;
				/* Ber ! */ 
			}
			cb_sync_get(iguana_cb_handle);
		}
		/* Try the console one */
		if (console_attached) {
			size = cb_get(console_cb_handle, sizeof(uintptr_t));
			if (size) {
				uintptr_t *cmd;
				uintptr_t addr, length;
				char *buf;
				cmd = cb_get(console_cb_handle, *size);
				cmd++;
				addr = *cmd;
				cmd++;
				length = *cmd;
				//printk("command: %lx %lx\n", addr, length);
				buf = (char*) addr;
				l4e_serial_receive_chars((char *)addr, length);
				cb_sync_get(console_cb_handle);
			}
		}
#endif

		{
			L4_MsgTag_t tag;
			L4_ThreadId_t unused;

			L4_Set_NotifyMask(0xffffffff);
			L4_Accept(L4_AsynchItemsAcceptor);
			tag = L4_Wait(&unused);
			if (L4_IpcFailed(tag)) {
				printk("Error Code: %lx -- %lx\n", tag.raw, L4_ErrorCode());
			}
			/* Check that we have received an async ipc. */
			if (L4_IpcSucceeded(tag) && (unused.raw == L4_nilthread.raw))
			{
				timeout = 1;
			}
		}

		/* If timeout (!interrupt) */
		if (!irqs_disabled() && timeout)
		{
			irq_enter();

			do_timer(NULL);	/* we relay on do_timer to only use user_mode(regs) */

			irq_exit();

			if (need_resched()) {
#if 0
				int r;
				/* If waiting on idle thread, wake it up */
				if (current_thread_info()->user_tid.raw == L4_anythread.raw)
				{
					L4_Send_Timeout(main_thread, L4_ZeroTime);
				}
				/* If process has a user part */
				else if (current_thread_info()->user_tid.raw)
				{
					/* printk("need to resched %p (%lx)\n", current_thread_info(),
						    current_thread_info()->user_tid.raw); */
					r = L4_Set_Timeslice (current_thread_info()->user_tid,
							L4_TimePeriod(10000),	/* Timeslice  XXX -
										   get this properly*/
							L4_ZeroTime);		/* Quantum */

					assert(r != 0);
				}
#else	/* Experimental fast user-premption - improves Linux scheduler */
				L4_MsgTag_t msgtag = L4_Niltag;
				L4_Msg_t msg;

				L4_Set_MsgMsgTag( &msg, msgtag );
				L4_MsgLoad( &msg );

				L4_Send_Nonblocking(main_thread);
#endif
			}
		} else if (timeout) {
			jiffies_64++;
		}
	}
}
