#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/highmem.h>

#include <asm/uaccess.h>

#include <l4/ipc.h>
#include "assert.h"

#include <iguana/pd.h>
#include <iguana/session.h>
#include <iguana/thread.h>
#include <iguana/memsection.h>

#ifdef CONFIG_ARCH_I386
extern void __L4_Ipc(void);
EXPORT_SYMBOL(__L4_Ipc);
#endif

EXPORT_SYMBOL(init_mm);
EXPORT_SYMBOL(init_task);
EXPORT_PER_CPU_SYMBOL(_l4_current_tinfo);

EXPORT_SYMBOL(request_irq);
EXPORT_SYMBOL(free_irq);
EXPORT_SYMBOL(probe_irq_on);
EXPORT_SYMBOL(probe_irq_off);

EXPORT_SYMBOL(do_gettimeofday);
EXPORT_SYMBOL(do_settimeofday);

EXPORT_SYMBOL(flush_dcache_page);
EXPORT_SYMBOL(flush_icache_range);

EXPORT_SYMBOL(copy_from_user);
EXPORT_SYMBOL(copy_to_user);

EXPORT_SYMBOL(start_thread);
EXPORT_SYMBOL(kernel_thread);

#ifdef CONFIG_DISCONTIGMEM
EXPORT_SYMBOL(node_data);
EXPORT_SYMBOL(pfn_hash);
#endif

EXPORT_SYMBOL(__assert);

EXPORT_SYMBOL(thread_myself);
EXPORT_SYMBOL(pd_myself);

EXPORT_SYMBOL(session_provide_access);
EXPORT_SYMBOL(session_create);
EXPORT_SYMBOL(pd_delete);
EXPORT_SYMBOL(pd_create_memsection);
EXPORT_SYMBOL(memsection_register_server);

