#include "l4.h"
#include "assert.h"

#include <linux/config.h>

#include <linux/mm.h>
#include <linux/kernel.h>
#include <linux/root_dev.h>
#include <linux/initrd.h>
#include <linux/init.h>
#include <asm/page.h>
#include <asm/tlbflush.h>
#include <asm/setup.h>

#include <iguana/memsection.h>
#include <iguana/cap.h>

#include <naming/naming.h>

#ifdef CONFIG_VT
#include <linux/tty.h>
#include <linux/console.h>
#endif

#define PFN_UP(x)	(((x) + PAGE_SIZE - 1) >> PAGE_SHIFT)
#define PFN_DOWN(x)	((x) >> PAGE_SHIFT)
#define PFN_PHYS(x)	((x) << PAGE_SHIFT)

extern char saved_command_line[];
L4_Fpage_t kip_area, utcb_area;

extern unsigned long start_phys_mem, end_phys_mem;
extern void * __rd_start, * __rd_end;

extern void setup_machine_name(void);
extern void setup_tls(int thread_num);

/* Setup L4 architecture requirements
 *   kip_area, utcb_area, physical memory, current,
 *   init's user address space, ramdisk
 */
void __init
setup_arch (char **command_line) 
{ 
	unsigned long base, area;
	L4_KernelInterfacePage_t *kip = L4_GetKernelInterface();

	setup_tls(1);
	saved_command_line[COMMAND_LINE_SIZE-1] = '\0';
	*command_line = saved_command_line;

	/* Find some area to put the kip and utcb in outside user's area */
	kip_area = L4_FpageLog2(PAGE_ALIGN(TASK_SIZE) +
			(L4_KipAreaSize(kip) * 16), L4_KipAreaSizeLog2(kip));

	/* Currently hardcoded to 1024 L4 threads per linux user address space */
	area = L4_UtcbAreaSize(kip) * 1024;
	base = L4_Address(kip_area) + L4_KipAreaSize(kip) + area;
	base = (base + (area-1)) & (~(area-1));

	utcb_area = L4_Fpage(base, L4_UtcbSize(kip) * 1024);

	setup_machine_name();

	/* FIXME - Get size from iguana. Create a 16MB window for memory */
	//_cap_memsection_create(16 * 1024 * 1024, &start_phys_mem); 
	//end_phys_mem = start_phys_mem + (16 * 1024 * 1024);
	/* FIXME: */
	start_phys_mem = __pa(start_phys_mem);
	end_phys_mem = __pa(end_phys_mem);

	paging_init();

	/* Thread info setup. XXX remember for SMP startup */
	current_tinfo(smp_processor_id()) = (unsigned long)&init_thread_union.thread_info;

	current->thread_info->user_tid = L4_nilthread;

	/* Ramdisk setup */
#ifdef CONFIG_BLK_DEV_INITRD
	/* Board specific code should have set up initrd_start and initrd_end */
	ROOT_DEV = Root_RAM0;
#if 0
	if (&__rd_start != &__rd_end) {
		initrd_start = (unsigned long)&__rd_start;
		initrd_end = (unsigned long)&__rd_end;
	}
#endif
	initrd_start = naming_lookup("ramdisk");
	initrd_end = naming_lookup("ramdisk_end");
	printk("end: %lx\n", initrd_end);
	initrd_below_start_ok = 1;

	if (initrd_start) {
		unsigned long initrd_size =
			((unsigned char *)initrd_end) -
			((unsigned char *)initrd_start);
		printk("Initial ramdisk at: 0x%p (%lu bytes)\n",
			(void *)initrd_start, initrd_size);
	}
#endif /* CONFIG_BLK_DEV_INITRD  */

#ifdef CONFIG_VT
#if defined(CONFIG_VGA_CONSOLE)
	conswitchp = &vga_con;
#elif defined(CONFIG_DUMMY_CONSOLE)
	conswitchp = &dummy_con;
#endif
#endif
} 

#if defined(CONFIG_VGA_CONSOLE) || defined(CONFIG_DUMMY_CONSOLE)
struct screen_info screen_info = {
 .orig_video_lines	= 30,
 .orig_video_cols	= 80,
 .orig_video_mode	= 0,
 .orig_video_ega_bx	= 0,
 .orig_video_isVGA	= 1,
 .orig_video_points	= 8
};

#endif

