#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/seq_file.h>

void
check_bugs (void)
{
	/* No arch L4 bugs */
} 

void
trap_init (void) 
{
	/* No trap vectors required on L4 */
} 

struct task_struct;

const char *get_system_type(void)
{
	return "L4 Default arch";
}

void machine_halt (void)
{
	L4_KDB_Enter("machine_halt called");
} 
void machine_restart (void)
{
	L4_KDB_Enter("machine_restart called");
} 

void per_cpu__mmu_gathers (void) { printk("per_cpu__mmu_gathers called\n"); } 
void ptrace_disable (void) { printk("ptrace_disable called\n"); } 
//void search_extable (void) { printk("search_extable called\n"); } 
void show_stack(struct task_struct *task, unsigned long *sp) { printk("show_stack called\n"); }
void dump_fpu (void) { /* printk("dump_fpu called\n"); */ }
void free_initrd_mem (void) { printk("free_initrd_mem called\n"); }

/* ARM specific */
void __memzero (void) { printk("__memzero called\n"); } 

#include "l4.h"
void __div0(void)
{
	L4_KDB_Enter("Division by zero in kernel.");
}

void __cpu_up (void) { printk("__cpu_up called"); } 
//void cpu_online_map (void) { printk("cpu_online_map called"); } 
void setup_profiling_timer (void) { printk("setup_profiling_timer called"); } 
//void smp_call_function (void) { printk("smp_call_function called"); } 
//void smp_prepare_boot_cpu (void) { printk("smp_prepare_boot_cpu called"); } 
void smp_prepare_cpus (void) { printk("smp_prepare_cpus called"); } 
//void smp_send_reschedule (void) { printk("smp_send_reschedule called"); } 
void smp_send_stop (void) { printk("smp_send_stop called"); } 
