/* Magpie service main loop. */

/*LOOP interface = generator.get_interfaces()*/
/* Interface {*-?interface.get_name()-*} */
/*LOOP function = interface.get_functions()*/

/*-run(templates.get('clientservice_function_params_maker'))-*/

/*-function_args_name_in = function.get_name() + '_args_in' -*/
/*-function_args_name_out = function.get_name() + '_args_out' -*/
/*-function_implementation_name = function.get_name() + '_implementation' -*/

/*-func_signature= ', '.join (['L4_ThreadId_t caller'] + ['%s %s%s%s' % (param['typename'], param['c_impl_indirection'], param['indirection'], param['name']) for param in function.get_call_params()])-*/
/* Prototype for the function which implements this service. Implement this. */
/*-?function.get_return_type()-*/ /*-?function_implementation_name-*/(/*-?func_signature-*/);

/* Code to manage this function */
typedef struct {
	long _msgtag;
	/*LOOP msg_params_in*//*-?'%s %s' % (LOOPITEM[0], LOOPITEM[1])-*/;
	/*ENDLOOP*/
} /*-?function_args_name_in-*/;

typedef struct {
	long _msgtag;
	/*LOOP msg_params_out*//*-?'%s %s' % (LOOPITEM[0], LOOPITEM[1])-*/;
	/*ENDLOOP*/
} /*-?function_args_name_out-*/;

/*-func_paramlist = []
for item in function.get_params():
	if item['direction'] == 'return':
		continue # Ignore return parameters
	prefix = {None: '', 'in': 'args_in.', 'out': 'args_out.'}[item['direction']]
	dereference = item['c_impl_indirection'].replace('*', '&')
	if 'priv' in item['flags']:
		param_name = '(args_in._msgtag >> 16) & 7'
	else:
		param_name = '%s%s%s' % (dereference, prefix, item['name'])
	func_paramlist.append(param_name)
-*/

/*-FUNCTION_NAME = function.get_name().upper() -*/
/* Number of output words is the size of the structure minus padding and message tag. */
/*-if function.get_fpages_count() == 0*/
#define _MAGPIE_/*-?FUNCTION_NAME-*/_OUTPUT_BYTES (sizeof(_par->_out) - (sizeof(long) * __L4_NUM_MRS) - (sizeof(long)))
/*fi-*/
/*-if function.get_fpages_count() > 0*//* Fpages (map items) also count. */
#define _MAGPIE_/*-?FUNCTION_NAME-*/_OUTPUT_BYTES (sizeof(_par->_out) - (sizeof(long) * __L4_NUM_MRS) - (sizeof(long)) - (/*-?function.get_fpages_count()-*/ * sizeof(idl4_mapitem)))
/*fi-*/

static inline L4_MsgTag_t
handle_/*-?function.get_name()-*/(L4_ThreadId_t caller, /*-?function_args_name_in-*/ *args_in,
		/*-?function_args_name_out-*/ *args_out)
{
	/*-if function.get_return_type() != 'void'*/args_out.__retval = /*fi-*//*-?function_implementation_name-*/(/*-?', '.join(['caller'] + func_paramlist)-*/);
	args_out._msgtag = (/*-?2 * function.get_fpages_count()-*/ << 6) + \
			(_MAGPIE_/*-?FUNCTION_NAME-*/_OUTPUT_BYTES / MAGPIE_BYTES_PER_WORD); 
	return args_out._msgtag;
}

/*ENDLOOP*/
/* End of function {*-?function.get_name()-*}*/

/*ENDLOOP*/

/* Service template helper functions. */
/* ... Reply and wait, copying message registers all over the place */
static inline void
idl4_reply_and_wait(L4_ThreadId_t *partner, L4_Msg_t *msg_in, L4_Msg_t *msg_out)
{
	L4_MsgTag_t _result;
	
	L4_MsgLoad(msg_out);
	_result = L4_ReplyWait(*partner, partner);
	L4_MsgStore(_result, &msg_in);
	//*msgtag = _result;
}

static inline unsigned
idl4_is_error(L4_MsgTag_t *msgtag)
{
	return (msgtag->X.flags & 8);
}

static inline long magpie_get_interface_bigid(L4_Msg_t *msg_in)
{
	/* Return the first word after the message tag; this is the
	* uuid in this platform. 
	*/
	return msg_in.msg[1];
}

static inline unsigned
idl4_get_function_id(L4_MsgTag_t *msgtag)
{
	return (msgtag->X.label & ((1<<IDL4_FID_BITS)-1));
}


/* Dispatchers for individual interfaces */
/*LOOP interface = generator.get_interfaces()*/
static inline int
dispatch_/*-?interface.get_name()-*/(L4_ThreadId_t *partner, L4_Msg_t *msg_in, L4_Msg_t *msg_out)
{
	switch(idl4_get_function_id(L4_MsgMsgTag(msg))) {
	/*LOOP function = interface.get_functions()*/
		case /*-?function.get_number()-*/:
			handle_/*-?function.get_name()-*/(partner, msg_in, msg_out);
			break;
	/*ENDLOOP*/
	}
}
/*ENDLOOP*/


/* Service template mainloop. */
void
server(void)
{
	L4_ThreadId_t partner = L4_nilthread; /* Our initial reply is to the nilthread. */
	L4_Msg_t msg_in, msg_out;

	while(1) {
		idl4_reply_and_wait(&partner, &msg_in, &msg_out);
		if (idl4_is_error(L4_MsgMsgTag(&msg_in))) {
			/* FIXME: Add your error handler here. */
			printf("server: error sending IPC reply\n");
			partner = L4_nilthread; /* Our initial reply is to the nilthread. */
		} else {
			switch(magpie_get_interface_bigid(&msg_in)) {
				/*LOOP interface = generator.get_interfaces()*/
				case /*-?interface.get_uuid()-*/:
					dispatch_/*-?interface.get_name()-*/(&partner, &msg_in, &msg_out);
					//idl4_process_request(&partner, &msgtag, &msgbuf, &cnt,
					//		/*-?interface.get_name()-*/_vtable
					//		[idl4_get_function_id(&msgtag) & /*-?interface.get_name().upper()-*/_FID_MASK]);
					break;
				/*ENDLOOP*/
			}
		}
	}
}

