from optparse import OptionParser
from migparser import parse_to_pt
from migparser.astgen import gen
from targets.shared.inputparser import CASTImporter as Importer
from magpidl4 import IDL4OptionParser
from targets.shared.options import options
from magpietypes.builtin import create_basictype_ast
from magpietypes.infogripper import dump_types_n_size
from helper import positive_id

REGISTRY_MACHINE_TYPE = "MIG"

def main():
	# Parse command-line arguments and dispatch to appropriate tester.
	parser_inst = IDL4OptionParser()
	parser_inst.setup()
	parser_inst.parser.add_option('--pt', dest = "pt", action = 'store_true', default = False,
			help = 'Display the MIG parse tree')
	parser_inst.parser.add_option('--ast', dest = 'ast', action = 'store_true', default = False,
			help = 'Display the MIG AST')
	parser_inst.parser.add_option('--types', dest = 'types', action = 'store_true', default = False,
			help = 'Import types and display the type registry')
	cmdlineoptions, cmdlineargs = parser_inst.parse_options()
	if cmdlineoptions.print_version:
		print VERSION_STRING
		sys.exit(0)
	if cmdlineargs == []: # No files, so exit
		parser_inst.print_help()
		print >>sys.stderr, "\nExiting because no IDL files were specified.\n"
		sys.exit(1)
		
	if cmdlineoptions.ugly_includepath_hack is not None:
		cmdlineoptions.include_dirs = [os.path.join(cmdlineoptions.ugly_includepath_hack, i)
			for i in cmdlineoptions.include_dirs]
	
	
	
	#parser = OptionParser()
	
			
	parser_inst.set_options()
	options.add_files(cmdlineargs)
	options['target'] = parser_inst.get_target()
	options.set_initialised()
	importer = Importer(options.filenames)
	data = importer.preprocess_and_grab_data(options.filenames)
	hardware_arch = options['hardware_arch']
	generator_type = 'mig' #options['generator']
	
	
	pt = parse_to_pt(data)

	if cmdlineoptions.pt:
		print "*** PT:"
		pt.print_tree()
		print "*** PT ends"
	
	if cmdlineoptions.ast:
		basicast = create_basictype_ast(hardware_arch, generator_type)
		#print "*** BASIC-AST:"
		#basicast.print_tree()
		#print "*** BASIC-AST ends"
		ast = gen(pt, basicast, options.filenames)
		#basicast.add_child(ast)
		print "*** AST:"
		basicast.print_tree()
		print "*** AST ends"
		
	if cmdlineoptions.types and basicast:
		print "*** Types list:"
		type_list = dump_types_n_size(basicast, '')
		for element in type_list:
			print 'Name: %s \t size = %s (node-reference: 0x%x)' %(element[0], element[1],  positive_id(element[2]))
		print "*** Types list ends"
		
	
	
if __name__ == '__main__':
	main()
