import math
import sys
from parser_common import *
#from helper import positive_id

SCOPES = ['module','interface','valuetype','struct','union','function','exception','eventtype','component','home']

def getBasicTypenode(typename, ast):
	#print 'getting: ', typename ,'from ', ast.type, ' ', ast.leaf
	returntype = getTypenode(typename, ast)
	return returntype
	
def getTypenode(typename, ast):
	return getNode(typename, ast, 'type')

def getNode(typename, ast, nodetype):
	"""
	Rules for scope-resolution:
		1. go to correct scope,i.e. A::B::C::TypeName
		   -> working_node == C; typename == TypeName
		2. check if typename is in (local) scope of working_node
		   if YES:
		   	return with result
		   else (if NO):
		3. for all scopes inher_scope in Inherited_Scopes of working_node:
			check if typename is in inher_scope (and recursive in the inherited scopes of inher_scope)
		4. move one scope_level up (from working_node!)
		   -> new working_node = working_node.parent
		   -> check for typename and if this fails ... repeat step 4
		5. (last step of 4.): search in filescope (Basictypes)
	"""
	debug_print = False
	if not isinstance(typename, list):
		typename = typename.split('::')
		
	if len(typename) > 1:
		working_node = find_scope(ast, typename[:-1])
		typename = typename[-1]
	else:
		working_node = ast
		typename = typename[0]

	if debug_print:
		if working_node.parent is not None:
			print 'searching for %s %s in ast = %s [%s] with parent = %s [%s]' %(nodetype, typename, working_node.type, working_node.leaf, working_node.parent.type, working_node.parent.leaf)
		else:
			print 'searching for %s %s in ast = %s [%s] with parent = None' %(nodetype, typename, working_node.type, working_node.leaf)
	#working_node.print_tree()
	if working_node.leaf == typename:
		return working_node
	#print 'calling from: ', sys._getframe(1).f_code.co_name
	#root= working_node
	#while root.parent != None:
	#	root = root.parent
	#print 'whole tree =>'
	#root.print_tree()
	if working_node.parent != None:
		if not ast in working_node.parent.children:
			#we are searching from an unfinished node
			#print "we are searching from an unfinished node"
			parent = ast.parent
			child = parent.last_child
			while child == None and parent.parent != None:
				# check inherited scopes
				if parent.type in SCOPES and len(parent['inherits']) != 0:
					inher_list = [element.get_attribute('target_scope')[0] for element in parent['inherits']]
					for inher_scope_name in inher_list:
						scope_node = find_scope(parent, inher_scope_name)
						assert scope_node is not None
						scope_result = find_node_in_scope(scope_node, typename, nodetype)
						if scope_result is not None:
							return scope_result
				# not found in inherited scopes!!
				# -> search in upper scopes
				parent = parent.parent
				child = parent.last_child
				
		else:
			child = working_node.left_sibling
	else:
		child = working_node.left_sibling
	if child == None:
		child = working_node.parent
		if child == None:
			return None
		else:
			if child.leaf == typename and child.type == nodetype:
				return child
			
		#print 'child = %s [%s]  working_node = %s' %( child.type, child.leaf, working_node)
		
		if not working_node in child.children:
			newchild = child.last_child
		else:
			newchild = working_node.left_sibling
			
		#print 'newchild = ', newchild
		parent = child
		while not newchild:
			#print 'parent = ', parent
			child = parent

			parent = child.parent
			
			if parent == None:
				#print 'type not found!'
				return None
			#print parent.type
			# check inherited scopes (is this is a scope with inheritance)
			if parent.type in SCOPES and len(parent['inherits']) != 0:
				inher_list = [element.get_attribute('target_scope')[0] for element in parent['inherits']]
				for inher_scope_name in inher_list:
					scope_node = inher_scope_name
					assert isinstance(inher_scope_name,Node)
					assert scope_node is not None
					scope_result = find_node_in_scope(scope_node, typename, nodetype)
					if scope_result is not None:
						return scope_result
			# not found in inherited scopes!!
			# -> search in upper scopes
			
			if parent == None:
				#print 'type not found!'
				return None
				
			if not child in parent.children:
				newchild = parent.last_child
			else:
				newchild = child.left_sibling

		
			#print 'child = ',child.type
		result = newchild.find_node(nodetype, typename)
		if result is not None:
			return result
		else:
			return getNode(typename, newchild, nodetype)
	else:
		#print 'found child.type = %s  child.name = %s child.parent(%s) = %s' %(child.type, child.leaf, child.parent.type, child.parent.leaf)
		result = child.find_node(nodetype, typename)
		if result is not None:
			return result
		else:
			return getNode(typename, child, nodetype)
	#if typenamenode == None:
	#	print "%s in ast %s not found!!" %(typename, ast.type)
	#else:
	#	print typenamenode	
	return typenamenode
	

def dump_types_n_size(node, prefix = None):
	returnlist = []
	if node.type in SCOPES:
		prefix = prefix + node.leaf + '_'
	if node.type == 'type' and node.leaf != None:
		type_size = size(node)
		name = prefix + node.leaf
		returnlist.append([name, type_size, node])
	for child in node.children:
		child_list = dump_types_n_size(child, prefix)
		if child_list != []:
			returnlist.extend(child_list)
	return returnlist

	
def find_type_in_scope(scope_node, typename):
	return find_node_in_scope(scope_node, typename, 'type')
	
def find_node_in_scope(scope_node, typename, nodetype):
	# look for type typename without descending into a node of SCOPES (i.e. a new scope)
	type_node = scope_node.find_node(nodetype,typename, SCOPES)
	if type_node != None:
		return type_node
	# else: look for typename in inherited scopes
	if scope_node.has_attribute('inheritance'):
		inher_list = scope_node.get_attribute('inheritance')
		for inher_scope_name in inher_list:
			inher_scope = find_scope(scope_node, inher_scope_name.split('::'))
			assert inher_scope is not None
			inher_result = find_node_in_scope(inher_scope, typename, nodetype)
			if inher_result != None:
				return inher_result
	return None
	
			
			
	
def find_scope(startnode, name):	
	#print 'trying to find %s from startnode: %s(%s)' %(name, startnode.type, startnode)
	if not isinstance(name, list):
		name = name.split('::')
	
	#first scope to be searched
	find = name[0]
	if find == '':
		# root_scope ...
		working_node = get_root_scope(startnode)
	else:
		# -> just bottom-up till a "scope"-node
		working_node = startnode
		while working_node != None and ((working_node.type not in SCOPES) or (working_node.leaf != find)):
			while working_node.left_sibling:
				working_node = working_node.left_sibling
				#print '1working_node is now: %s(%s)' %(working_node.type, working_node)
				result_node = working_node.find_node(SCOPES, name, SCOPES)
				if result_node is not None:
					#print 'returning1: %s' %(result_node)
					return result_node
			#print '2working_node is now: %s(%s)' %(working_node.type, working_node)
			working_node = working_node.parent
		if working_node == None:
			#print 'returning2: %s' %('None')			
			return None
		
	for scope in name[1:]:
		working_node = working_node.find_node(SCOPES, scope, SCOPES)		
		if working_node == None:
			#print 'returning3: %s' %('None')
			return None
			
	#print 'returning4: %s' %(working_node)
	return working_node
		
def get_root_scope(startnode):
	root = startnode
	while root.parent != None:
		root = root.parent
	return root
	
def get_full_scope(node):
	if node == None:
		return ''
	root = node.parent
	#print node
	scope_list = []
	while root != None:
		if root.type in SCOPES:
			scope_list.append(root)
		root = root.parent
		
	scope_list.reverse()
	#print scope_list
	return scope_list
		
def get_full_scope_string(node):
	if node == None:
		return ''
	root = node.parent
	#print node
	scope_list = []
	while root != None:
		if root.type in SCOPES:
			scope_list.append(root.leaf)
		root = root.parent
		
	scope_list.reverse()
	#print scope_list
	return scope_list
	
	
def get_param_type_spec(node, side='client'):
	#possible meta_types: basic, alias, string, wstring, scoped_name, pointer
	meta_type = node.get_attribute('meta_type')[0]
	if meta_type in ['basic','alias']:
		scopelist = get_full_scope(node)
		scopelist.append(node.leaf)
		return '_'.join(scopelist)
	elif meta_type in ['string','wstring']:
		return 
	elif meta_type == 'pointer':
		return '*' + get_param_type_spec(node.get_attribute('target_type')[0])
	elif meta_type == 'polymorphic':
		if side == 'client':
			return get_param_type_spec(node.the('info').get_attribute('receiver_type')[0])
		else:
			return get_param_type_spec(node.the('info').get_attribute('sender_type')[0])		
	elif meta_type == 'scoped_name':
	
		target = node.the('info').get_attribute('target_type')
		return '_'.join(get_full_scope(target).append(target.leaf))
	else:
		print 'meta_type unknown: ', meta_type
		assert False
	
	
	
def basic_size(type_node):
	#print isinstance(type_node.the('info').get_attribute('size')[0], str), ' ->', type_node.the('info').get_attribute('size')[0]
	if isinstance(type_node.the('info').get_attribute('size')[0], str):
		try:
			return int(eval(type_node.the('info').get_attribute('size')[0]))
		except Exception:
			print 'Exception in basic_size-calculation of ', type_node.the('info').get_attribute('size')[0]
			return -1
	else:
		return type_node.the('info').get_attribute('size')[0]
		
def sized_alias_size(type_node):
	#type_node.print_tree()
	return basic_size(type_node)

def alias_size(type_node):
	
	#print 'alias_size of:'
	#type_node.print_tree()
	target_node = type_node.the('info').get_attribute('target_type')[0]
	if target_node == None:
		type_node.print_tree()
		assert False
	return size(target_node)

def union_size(type_node):
	case_list = [case.the('type_instance') for case in type_node.the('members')['case']]
	maxsize = 0
	for case in case_list:
		target_type = case.get_attribute('target_type')[0]
		target_size = size(target_type)
		if target_size > maxsize:
			maxsize = target_size
	return maxsize
	
def enum_size(type_node):
	length = len(type_node.the('info').get_attribute('enumeration'))
	enumsize = math.ceil(math.log(math.ceil(math.log(length, 2)),32)) * 32
	return enumsize
	
def struct_size(type_node):
	type_list = [ type_inst.get_attribute('target_type')[0] for type_inst in type_node.the('members')['type_instance']]
	structsize = 0
	for inst_type in type_list:
		structsize += size(inst_type)
	return structsize
	
def array_size(type_node):
	shape = type_node.the('info').get_attribute('shape')
	base_size = size(type_node.the('info').get_attribute('target_type')[0])
	if shape is None:
		return 0
	else:
		for dim in shape:
			if dim.isdigit():
				base_size *= eval(dim)
			else:
				base_size *= eval(constant_lookup(dim))
		return base_size
	
def sequence_size(type_node):
	shape = type_node.the('info').get_attribute('shape')
	base_size = size(type_node.the('info').get_attribute('target_type')[0])
	if shape is None:
		return 0
	else:
		for dim in shape:
			if dim.isdigit():
				base_size *= eval(dim)
			else:
				base_size *= eval(constant_lookup(dim))
		return base_size
	
def polymorphic_size(type_node):
	sender_size = size(type_node.the('info').get_attribute('sender_type')[0])
	receiver_size = size(type_node.the('info').get_attribute('receiver_type')[0])
	return (sender_size, receiver_size)
	
def pointer_size(type_node):		
	int_node = getTypenode('int', type_node)
	if int_node != None:
		return size(int_node)
	else:
		print 'int-Node in infogripper.py -> pointer_size not found!'
		return 32
def string_size(type_node):
	return pointer_size(type_node)

def word_size(type_node):
	int_node = getTypenode('int', type_node)
	if int_node != None:
		return size(int_node)
	else:
		print 'int-Node in infogripper.py -> word_size not found!'
		return 32
		
def size(type_node):
	if not type_node.has_attribute('meta_type'):
		type_node.print_tree()
		assert False
	meta_type = type_node.get_attribute('meta_type')[0] + '_size'
	#print globals()[meta_type]
	#print 'meta_type = ', meta_type
	return globals()[meta_type](type_node)
