#
# Australian Public Licence B (OZPLB)
# 
# Version 1-0
# 
# Copyright (c) 2004 National ICT Australia
# 
# All rights reserved. 
# 
# Developed by: Embedded Real-time and Operating Systems Group (ERTOS)
#               National ICT Australia
#               http://www.ertos.nicta.com.au
# 
# Permission is granted by National ICT Australia, free of charge, to
# any person obtaining a copy of this software and any associated
# documentation files (the "Software") to deal with the Software without
# restriction, including (without limitation) the rights to use, copy,
# modify, adapt, merge, publish, distribute, communicate to the public,
# sublicense, and/or sell, lend or rent out copies of the Software, and
# to permit persons to whom the Software is furnished to do so, subject
# to the following conditions:
# 
#    # Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimers.
# 
#    # Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimers in the documentation and/or other materials provided
#       with the distribution.
# 
#    # Neither the name of National ICT Australia, nor the names of its
#       contributors, may be used to endorse or promote products derived
#       from this Software without specific prior written permission.
# 
# EXCEPT AS EXPRESSLY STATED IN THIS LICENCE AND TO THE FULL EXTENT
# PERMITTED BY APPLICABLE LAW, THE SOFTWARE IS PROVIDED "AS-IS", AND
# NATIONAL ICT AUSTRALIA AND ITS CONTRIBUTORS MAKE NO REPRESENTATIONS,
# WARRANTIES OR CONDITIONS OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
# BUT NOT LIMITED TO ANY REPRESENTATIONS, WARRANTIES OR CONDITIONS
# REGARDING THE CONTENTS OR ACCURACY OF THE SOFTWARE, OR OF TITLE,
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT,
# THE ABSENCE OF LATENT OR OTHER DEFECTS, OR THE PRESENCE OR ABSENCE OF
# ERRORS, WHETHER OR NOT DISCOVERABLE.
# 
# TO THE FULL EXTENT PERMITTED BY APPLICABLE LAW, IN NO EVENT SHALL
# NATIONAL ICT AUSTRALIA OR ITS CONTRIBUTORS BE LIABLE ON ANY LEGAL
# THEORY (INCLUDING, WITHOUT LIMITATION, IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHERWISE) FOR ANY CLAIM, LOSS, DAMAGES OR OTHER
# LIABILITY, INCLUDING (WITHOUT LIMITATION) LOSS OF PRODUCTION OR
# OPERATION TIME, LOSS, DAMAGE OR CORRUPTION OF DATA OR RECORDS; OR LOSS
# OF ANTICIPATED SAVINGS, OPPORTUNITY, REVENUE, PROFIT OR GOODWILL, OR
# OTHER ECONOMIC LOSS; OR ANY SPECIAL, INCIDENTAL, INDIRECT,
# CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES, ARISING OUT OF OR IN
# CONNECTION WITH THIS LICENCE, THE SOFTWARE OR THE USE OF OR OTHER
# DEALINGS WITH THE SOFTWARE, EVEN IF NATIONAL ICT AUSTRALIA OR ITS
# CONTRIBUTORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH CLAIM, LOSS,
# DAMAGES OR OTHER LIABILITY.
# 
# If applicable legislation implies representations, warranties, or
# conditions, or imposes obligations or liability on National ICT
# Australia or one of its contributors in respect of the Software that
# cannot be wholly or partly excluded, restricted or modified, the
# liability of National ICT Australia or the contributor is limited, to
# the full extent permitted by the applicable legislation, at its
# option, to:
# a.  in the case of goods, any one or more of the following:
# i.  the replacement of the goods or the supply of equivalent goods;
# ii.  the repair of the goods;
# iii. the payment of the cost of replacing the goods or of acquiring
#  equivalent goods;
# iv.  the payment of the cost of having the goods repaired; or
# b.  in the case of services:
# i.  the supplying of the services again; or
# ii.  the payment of the cost of having the services supplied again.
# 
# The construction, validity and performance of this licence is governed
# by the laws in force in New South Wales, Australia.
#

from debugging import debug_castwalker, debug_flags
#from magpietypes.magpietype import UnknownMembers
from evaluator import evaluate
from helper import positive_id

#from magpietypes.castwalker import *
from idlparser import parse_to_pt_cached,parse_to_pt_noncached, parse_to_ast

def debug_tree(ast):
	if debug_flags['idlastwalker']:
		ast.print_tree()

class IDLASTWalker:
	""" Walk the IDL AST and import types as appropriate. """
	def __init__(self, type_registry):
		self.registry = type_registry
		self.ast_list = []
	
	'''	
	def _add_typedef(self, ast):
		typename = ast.the('type').leaf
		if ast.the('type').has_attribute('meta_type'):
			type_inst = self.proc_sequence(ast.the('type'))
		else:
			type_inst = self.registry[typename]
		self.proc_declarator_aliases(type_inst, ast)
	'''
	
	def proc_const(self, def_list):
		for child in def_list:
			self.proc_constant(child)
	
	def proc_constant(self, ast):
                #print ast
                #ast = ast.the('declarator')
                declarator_name = ast.leaf
                initialiser = ast.get_attribute('value')[0]
                type_name = ast.the('type').leaf
                type_inst = self.registry[ast.the('type').leaf]
                #print type_inst, declarator_name, initialiser
                self.registry.make_instance_add_instance(type_inst, declarator_name, initialiser)
		
	def find_types(self, ast):
		assert ast not in self.ast_list
		self.ast_list.append(ast)
		

				
		# idlimports #
		for idlimport in ast['import']:
			data = file(idlimport.leaf).read()
			pt = parse_to_pt_noncached(data)
			ast = parse_to_ast(pt)
			self.find_types(self, ast)
			
		# this idlfile #
		self.proc_definition(ast)
		#self.registry.exit_namespace('IDLFile')
		
	def proc_definition(self, ast):
		def_list = self.get_definitions(ast)
		#print 'def_list = ', def_list
		#return None

		for def_child in def_list:
                    if def_child.type == 'module':
                            self.proc_module(def_child)
                    elif def_child.type == 'interface':
                            self.proc_interface(def_child)
                    elif def_child.type == 'value':
                            pass
                    elif def_child.type == 'exception':
                            pass
                    elif def_child.type == 'event':
                            pass
                    elif def_child.type == 'component':
                            self.proc_component(def_child)
                    elif def_child.type == 'home':
                            pass
                    elif def_child.type == 'type':
                            self.proc_type(def_child)
                    elif def_child.type == 'const':
                            self.proc_constant(def_child)
		
		#self.registry.exit_namespace('IDLFile')
		
	def proc_component(self, ast):
		self.registry.create_namespace(ast.leaf, 'component')
		for exp in ast['export']:
			for child in exp.children:
				if child.type == 'attribute':
					self.proc_attribute(child)
				else:
					pass
		self.registry.exit_namespace(ast.leaf)
	
	def proc_module(self, ast):
		self.registry.create_namespace(ast.leaf, 'module')
		#print self.registry.current
		self.proc_definition(ast)
		self.registry.exit_namespace(ast.leaf)
		
	def proc_type(self, ast):
		if ast.get_attribute('specifier') == ['typedef']:
                	self.proc_typedef(ast)
                elif ast.get_attribute('specifier') == ['constr_type']:
                        self.proc_constr_type(ast.the('declarator'))
		else:
			pass

        def proc_template_type(self, ast):
                if ast.get_attribute('meta_type') == ['sequence']:
                    return self.proc_sequence(ast)
                elif ast.get_attribute('meta_type') == ['fixed']:
                    pass #no support for data-type fixed
                elif ast.get_attribute('meta_type') == ['string']:
                    pass #self.proc_enum(ast)
		elif ast.get_attribute('meta_type') == ['wstring']:
                    pass #self.proc_enum(ast)
                else:
                    pass
		 
        def proc_sequence(self, ast):
		if ast.the('type').has_attribute('meta_type'):
			base_type = self.proc_template_type(ast.the('type'))
		else:
			base_type = self.registry[ast.the('type').leaf]
		#print 'base_type = ', base_type
		assert base_type != None
		size = ast.get_attribute('length')
		if size != None:
			size = size[0]
		sequence_name = '_sequence_'+str(positive_id(base_type))+'<'+str(size)+'>'
		sequence_type = self.registry[sequence_name]
		#print 'looked up sequence_type = ', sequence_type
		if sequence_type == None:
			
			sequence_type = self.registry.make_type('sequence', sequence_name, base_type, size)
			#print 'adding sequencetype: ', sequence_type.name
			self.registry.add_type(sequence_type)
		sequence_type.namespace = self.registry.current
		#print 'sequence: ', sequence_type
		return sequence_type
		
			
			
	def proc_declarator_aliases(self, type_inst, ast):
		for name in ast.get_attribute('declarator')[0]:
		    #print name
                    if isinstance(name, list):
		    	    if len(name) == 3 and isinstance(name[2], list):
                            	#super_type = self.registry[ast.leaf]
                           	type_inst = self.registry.make_type('array', type_inst.name+str(name[2]), type_inst, name[2])
                            	type_name = name[0]
				#print type_name, type_inst
                    	    else:
                            	#child_type = self.registry[ast.leaf]
                            	type_name = name[-1]
		    else:
			type_name = name
		    size = None
		    if ast.has_attribute('size'):
		    	size = ast.get_attribute('size')[0]
		    #print name, type_name, type_inst
		    alias_inst = self.registry.make_type('alias', type_name, type_inst, size)
		   
		    self.registry.add_type(alias_inst)

        def proc_constr_type(self, ast):
                if ast.get_attribute('meta_type') == ['struct']:
                    self.proc_struct(ast)
                elif ast.get_attribute('meta_type') == ['union']:
                    self.proc_union(ast)
                elif ast.get_attribute('meta_type') == ['enum']:
                    self.proc_enum(ast)
                else:
                    pass
		   
	
	def proc_typedef(self, ast):
		if ast.get_attribute('specifier') == ['typedef']:
			
			#print typename
			if ast.the('type').has_attribute('meta_type'):
				if ast.the('type').get_attribute('meta_type')[0] == 'polymorphic':
					self.proc_polymorphic(ast.the('type'))
				else: 
					type_inst = self.proc_sequence(ast.the('type'))
					self.proc_declarator_aliases(type_inst, ast.the('type'))
			else:
				typename = ast.the('type').leaf
				type_inst = self.registry[typename]
				self.proc_declarator_aliases(type_inst, ast.the('type'))
				
				
	def proc_polymorphic(self, ast):
		print ast
		sendertype = None
		receivertype = None
		for child in ast['type']:
			if child.get_attribute('side')[0] == 'sender':
				sendertype = child.leaf
			else:
				receivertype = child.leaf
		assert sendertype is not None
		assert receivertype is not None
		senderinst = self.registry[sendertype]
		receiverinst = self.registry[receivertype]
		name = ast.get_attribute('declarator')[0]
		poly_type = self.registry.make_type('polymorphic',None, senderinst, receiverinst)
		self.proc_declarator_aliases(poly_type, ast)
		
		
		
        def proc_struct(self, ast):
            declarator_name = ast.leaf
            self.registry.make_type_add_type('struct', declarator_name)
            declarator_name = ast.leaf
            self.registry.enter_namespace(declarator_name)
            #print 'child[type]', ast
            for child in ast.children:
                if child.type in ['type','declarator']:
                    #print 'child = ', child
                    if child.type == 'declarator':
                        self.proc_constr_type(child)
                    elif child.type == 'type':
                        self.proc_type_inst(child)
            #self.proc_struct(ast['declarator'])
            self.registry.exit_namespace(declarator_name)
	    if ast.has_attribute('declarator'):
		    self.proc_type_inst(ast)
            #self._add_constr_type(child.the('declarator')) 
	    
	def proc_enum(self, ast):
		enum_type = self.registry.make_type('enum', ast.leaf, ast.get_attribute('enumeration'))
		self.registry.add_type(enum_type)
		for element in enum_type.enum_member:
			self.registry.add_type(element)
			
	def proc_union(self, ast):
	    declarator_name = ast.leaf
            #self.registry.create_namespace(declarator_name, 'struct')
            #print self.registry.current
            self.registry.make_type_add_type('union', declarator_name)
            declarator_name = ast.leaf
            self.registry.enter_namespace(declarator_name)
            #print 'child[type]', ast
            for child in ast.children:
                if child.type in ['type','declarator']:
                    #print 'child = ', child
                    if child.type == 'declarator':
                        self.proc_constr_type(child)
                    elif child.type == 'type':
                        self.proc_type_inst(child)
            #self.proc_struct(ast['declarator'])
            self.registry.exit_namespace(declarator_name)
	    if ast.has_attribute('declarator'):
		    self.proc_type_inst(ast)
            #self._add_constr_type(child.the('declarator'))

	def get_definitions_type(self, ast, node_type):
                def_list = []
                for child in [def_el.the(node_type) for def_el in ast['definition']]:
                    if child is not None:
                        def_list.append(child)
		return def_list

	def get_definitions(self, ast):
                def_list = []
                for child in [def_el.children for def_el in ast['definition']]:
                    for element in child:
                        if element.type != 'decorator':
                            def_list.append(element)
		return def_list

	def proc_interface(self, ast):
		inheritance_list = ast.get_attribute('inherits')
		if inheritance_list == None:
			inheritance_list = []
		self.registry.create_namespace(ast.leaf, ast.type, inheritance_list)
		for child in ast.children:
			if child.type == 'type':
				self.proc_type(child)
			elif child.type == 'const':
				self.proc_constant(child)
			elif child.type == 'exception':
				pass
			elif child.type == 'attribute':
				self.proc_attribute(child)
			elif child.type == 'function':
				self.proc_function(child)
			else:
				pass
		self.registry.exit_namespace(ast.leaf)
		
	def proc_attribute(self, ast):
		self.proc_type_inst(ast.the('type'))
		
	def proc_function(self, ast):
		self.registry.create_namespace(ast.leaf, ast.type, [])
		for child in ast.children:
			if child.type == 'return_type':
				return_type_name = ast.the('return_type').leaf
				if return_type_name != 'void':
					return_type = self.registry[return_type_name]
					assert return_type is not None
					self.registry.make_instance_add_instance(return_type, '_return', None)
				
			elif child.type == 'type':
				# function typedef #
				self.proc_typedef(child)
				
			elif child.type == 'parameter': 
				param_type_name = child.the('type').leaf
				param_type = self.registry[param_type_name]
				if param_type is None:
					print 'param_type of name %s is None!' %(param_type_name)
					self.registry.print_registry()
				assert param_type is not None
				inst_name = child.leaf
				self.registry.make_instance_add_instance(param_type, inst_name, None)				
			else:
				pass
		
		self.registry.exit_namespace()	
		
			
	def proc_type_inst(self, ast):
                for name in ast.get_attribute('declarator'):
		    #print 'name = ', name
                    if isinstance(name, list):
		    	    if len(name) == 3 and isinstance(name[2], list):
                            	super_type = self.registry[ast.leaf]
                           	child_type = self.registry.make_type('array', ast.leaf+str(name[2]), super_type, name[2])
                            	type_name = name[0]
                    	    else:
                            	child_type = self.registry[ast.leaf]
                            	type_name = name[-1]
		    else:
		    	child_type = self.registry[ast.leaf]
			type_name = name
		    #print 'creating instance of child_type: %s with name %s' %(child_type, type_name)
                    self.registry.make_instance_add_instance(child_type, type_name, None)
