#
# Australian Public Licence B (OZPLB)
# 
# Version 1-0
# 
# Copyright (c) 2004 National ICT Australia
# 
# All rights reserved. 
# 
# Developed by: Embedded Real-time and Operating Systems Group (ERTOS)
#               National ICT Australia
#               http://www.ertos.nicta.com.au
# 
# Permission is granted by National ICT Australia, free of charge, to
# any person obtaining a copy of this software and any associated
# documentation files (the "Software") to deal with the Software without
# restriction, including (without limitation) the rights to use, copy,
# modify, adapt, merge, publish, distribute, communicate to the public,
# sublicense, and/or sell, lend or rent out copies of the Software, and
# to permit persons to whom the Software is furnished to do so, subject
# to the following conditions:
# 
#    # Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimers.
# 
#    # Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimers in the documentation and/or other materials provided
#       with the distribution.
# 
#    # Neither the name of National ICT Australia, nor the names of its
#       contributors, may be used to endorse or promote products derived
#       from this Software without specific prior written permission.
# 
# EXCEPT AS EXPRESSLY STATED IN THIS LICENCE AND TO THE FULL EXTENT
# PERMITTED BY APPLICABLE LAW, THE SOFTWARE IS PROVIDED "AS-IS", AND
# NATIONAL ICT AUSTRALIA AND ITS CONTRIBUTORS MAKE NO REPRESENTATIONS,
# WARRANTIES OR CONDITIONS OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
# BUT NOT LIMITED TO ANY REPRESENTATIONS, WARRANTIES OR CONDITIONS
# REGARDING THE CONTENTS OR ACCURACY OF THE SOFTWARE, OR OF TITLE,
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT,
# THE ABSENCE OF LATENT OR OTHER DEFECTS, OR THE PRESENCE OR ABSENCE OF
# ERRORS, WHETHER OR NOT DISCOVERABLE.
# 
# TO THE FULL EXTENT PERMITTED BY APPLICABLE LAW, IN NO EVENT SHALL
# NATIONAL ICT AUSTRALIA OR ITS CONTRIBUTORS BE LIABLE ON ANY LEGAL
# THEORY (INCLUDING, WITHOUT LIMITATION, IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHERWISE) FOR ANY CLAIM, LOSS, DAMAGES OR OTHER
# LIABILITY, INCLUDING (WITHOUT LIMITATION) LOSS OF PRODUCTION OR
# OPERATION TIME, LOSS, DAMAGE OR CORRUPTION OF DATA OR RECORDS; OR LOSS
# OF ANTICIPATED SAVINGS, OPPORTUNITY, REVENUE, PROFIT OR GOODWILL, OR
# OTHER ECONOMIC LOSS; OR ANY SPECIAL, INCIDENTAL, INDIRECT,
# CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES, ARISING OUT OF OR IN
# CONNECTION WITH THIS LICENCE, THE SOFTWARE OR THE USE OF OR OTHER
# DEALINGS WITH THE SOFTWARE, EVEN IF NATIONAL ICT AUSTRALIA OR ITS
# CONTRIBUTORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH CLAIM, LOSS,
# DAMAGES OR OTHER LIABILITY.
# 
# If applicable legislation implies representations, warranties, or
# conditions, or imposes obligations or liability on National ICT
# Australia or one of its contributors in respect of the Software that
# cannot be wholly or partly excluded, restricted or modified, the
# liability of National ICT Australia or the contributor is limited, to
# the full extent permitted by the applicable legislation, at its
# option, to:
# a.  in the case of goods, any one or more of the following:
# i.  the replacement of the goods or the supply of equivalent goods;
# ii.  the repair of the goods;
# iii. the payment of the cost of replacing the goods or of acquiring
#  equivalent goods;
# iv.  the payment of the cost of having the goods repaired; or
# b.  in the case of services:
# i.  the supplying of the services again; or
# ii.  the payment of the cost of having the services supplied again.
# 
# The construction, validity and performance of this licence is governed
# by the laws in force in New South Wales, Australia.
#

from parser_common import *
from arch_sizes import construct_for_arch

C_NAMES = ("void", "short", "long", "long long", "unsigned short",
	  "unsigned long", "unsigned long long", "float", "double", "long double",
	  "char", "unsigned char", "wchar_t", "bool", "octet", "int", "unsigned int",
	  "signed char", "fpage")
	  
C_ALIAS = (('__int64', 'long long'),
	   ('signed __int64', 'long long'),
	   ('unsigned __int64', 'unsigned long long'),
	   ("long int", "long"),
	   ('unsigned long int', 'unsigned long'),
	   ('long unsigned int', 'unsigned long'),
	   ('long long int', 'long long'),
	   ('unsigned long long int', 'unsigned long long'),
	   ('unsigned', 'unsigned int'),
	   ('short int', 'short'),
	   ('boolean', 'bool'),
	   ('signed short int', 'short'),
	   ('signed int', 'int'),
	   ('unsigned short int', 'unsigned short')
	   )

MIG_NAMES = (
	     "MACH_MSG_TYPE_INTEGER_64",
	     "MACH_MSG_TYPE_REAL_64",
	     "polymorphic",
	     "MACH_MSG_TYPE_BOOLEAN", 
	     "MACH_MSG_TYPE_INTEGER_32", 
	     "MACH_MSG_TYPE_REAL_32", 
	     "MACH_MSG_TYPE_PORT_NAME", 
	     "MACH_MSG_TYPE_PORT_internal",
	     "MACH_MSG_TYPE_SEND_internal",
	     "MACH_MSG_TYPE_RECEIVE_internal",
	     "MACH_MSG_TYPE_INTEGER_16", 
	     "MACH_MSG_TYPE_INTEGER_8", 
	     "MACH_MSG_TYPE_CHAR", 
	     "MACH_MSG_TYPE_BYTE", 
	     "MACH_MSG_TYPE_BIT", 
	     "MACH_MSG_TYPE_POLYMORPHIC", 
	     'MACH_MSG_TYPE_UNSTRUCTURED', 
	     "MACH_MSG_TYPE_REAL", 
	     "MACH_MSG_TYPE_STRING", 
	     "MACH_MSG_TYPE_STRING_C" 
	    )
	     
MIG_ALIAS = ()

'''
def create(type_registry):
	# Add the simple types. These are all types that the architecture info should
	# know about.
	for name in C_NAMES:
		type_registry.make_type_add_type('basic', name)
	
	# OMG string type
	type_registry.make_type_add_type('basic', 'string')

	# Add some alias types. Haha, can't do this with a real typedef but we can here!
	for alias, name in C_ALIAS:
		type_registry.make_type_add_type('alias', alias, name)
	# IDL4 server environment: a struct with two members
	# FIXME: This is sort of a hack.
	
	
	type_registry.make_type_add_type('struct', 'idl4_server_environment',
		[('int', '_action'), ('void', '_data')])
'''
	
def create_special_C(arch_info, ast):
	type_list = ast.children
	struct_t = Type(ast, None)
	struct_t.leaf = 'idl4_server_environment'
	struct_t.add_attribute('meta_type','struct')
	members = Node(struct_t, 'members')
	typeinst = TypeInstance(struct_t)
	typeinst.leaf = '_action'
	index = [element.leaf for element in type_list].index('int')
	typeinst.add_attribute('target_type',type_list[index] )
	members.add_child(typeinst)
	typeinst = TypeInstance(struct_t)
	typeinst.leaf = '_data'
	index = [element.leaf for element in type_list].index('void')
	typeinst.add_attribute('target_type',type_list[index] )
	members.add_child(typeinst)
	
	#FIXME: CORBA-C Type-Hack!!!
	aliases = ( ('Object', 'int'),
		    ('any', 'int'),			
		    ('ValueBase', 'int'),
		    ('wchar', 'char'),
		    ('Word', 'int')
		  )
	for alias, name in aliases:
		newType = Type(ast, None)
		newType.leaf = alias
		newType.add_attribute('meta_type', 'alias')
		info = Info(newType)
		newType.add_child(info)
		type_list = ast.children
		index = [element.leaf for element in type_list].index(name)
		info.add_attribute('target_type', type_list[index])
		ast.add_child(newType)
	
	

def create_special_MIG(arch_info, ast):
	poly_list =(	
	("MACH_MSG_TYPE_PORT_RECEIVE", 	'32', 'MACH_MSG_TYPE_PORT_internal',	'MACH_MSG_TYPE_POLYMORPHIC'),
	("MACH_MSG_TYPE_PORT_SEND", 	'32', 'MACH_MSG_TYPE_PORT_internal',	'MACH_MSG_TYPE_POLYMORPHIC'),
	("MACH_MSG_TYPE_PORT_SEND_ONCE", '32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_POLYMORPHIC'),
	("MACH_MSG_TYPE_COPY_SEND", 	'32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_PORT_SEND'),
	("MACH_MSG_TYPE_MAKE_SEND", 	'32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_PORT_SEND'),
	("MACH_MSG_TYPE_MOVE_SEND", 	'32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_PORT_SEND'),
	("MACH_MSG_TYPE_MAKE_SEND_ONCE", '32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_PORT_SEND_ONCE'),
	("MACH_MSG_TYPE_MOVE_SEND_ONCE", '32', 'MACH_MSG_TYPE_SEND_internal',	'MACH_MSG_TYPE_PORT_SEND_ONCE'),
	("MACH_MSG_TYPE_MOVE_RECEIVE", 	'32', 'MACH_MSG_TYPE_RECEIVE_internal', 'MACH_MSG_TYPE_PORT_RECEIVE')
	)

	type_list = ast.children
	for name, size, sender, receiver in poly_list:
		newType = Type(ast, None)
		newType.leaf = name
		newType.add_attribute('meta_type', 'polymorphic')
		info = Info(newType)
		newType.add_child(info)
		index = [element.leaf for element in type_list].index(sender)
		info.add_attribute('sender_type',type_list[index] )
		index = [element.leaf for element in type_list].index(receiver)
		info.add_attribute('receiver_type',type_list[index] )
		type_list.append(newType)
		ast.add_child(newType)

def create_basictype_ast(arch_name, typetype):
	ast = Node(None, 'MagpieAST', None)
	arch_info = construct_for_arch(arch_name, typetype)
	if typetype == 'idl4':
		names = C_NAMES
		aliases = C_ALIAS
		
	if typetype == 'mig':
		names = MIG_NAMES
		aliases = MIG_ALIAS
		
	for name in names:
		newType = Type(ast, None)
		newType.leaf = name
		newType.add_attribute('meta_type', 'basic')
		info = Info(newType)
		newType.add_child(info)
		info.add_attribute('size', arch_info.size_in_bits(name))
		ast.add_child(newType)
		
	for alias, name in aliases:
		newType = Type(ast, None)
		newType.leaf = alias
		newType.add_attribute('meta_type', 'alias')
		info = Info(newType)
		newType.add_child(info)
		type_list = ast.children
		index = [element.leaf for element in type_list].index(name)
		info.add_attribute('target_type', type_list[index])
		ast.add_child(newType)
		
	if typetype == 'idl4':
		create_special_C(arch_info, ast)
	if typetype == 'mig':
		create_special_MIG(arch_info, ast)		
	
	return ast
'''				
def create_mig(type_registry):
	# Add the simple types. These are all types that the architecture info should
	# know about.
	for name in (
			"MACH_MSG_TYPE_INTEGER_64",
			"MACH_MSG_TYPE_REAL_64",
			"polymorphic",
			"MACH_MSG_TYPE_BOOLEAN", 
			"MACH_MSG_TYPE_INTEGER_32", 
			"MACH_MSG_TYPE_REAL_32", 
			"MACH_MSG_TYPE_PORT_NAME", 
			"MACH_MSG_TYPE_PORT_internal",
			"MACH_MSG_TYPE_SEND_internal",
			"MACH_MSG_TYPE_RECEIVE_internal",
			"MACH_MSG_TYPE_INTEGER_16", 
			"MACH_MSG_TYPE_INTEGER_8", 
			"MACH_MSG_TYPE_CHAR", 
			"MACH_MSG_TYPE_BYTE", 
			"MACH_MSG_TYPE_BIT", 
			"MACH_MSG_TYPE_POLYMORPHIC", 
			'MACH_MSG_TYPE_UNSTRUCTURED', 
			"MACH_MSG_TYPE_REAL", 
			"MACH_MSG_TYPE_STRING", 
			"MACH_MSG_TYPE_STRING_C" 
		):
		
		type_registry.make_type_add_type('basic', name)
		
		
	# Add polymorphic types
	port_inst = type_registry['MACH_MSG_TYPE_PORT_internal']
	port_inst.size = 32
	poly_inst = type_registry['MACH_MSG_TYPE_POLYMORPHIC']
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_PORT_RECEIVE", poly_inst, port_inst)
	
	port_inst = type_registry['MACH_MSG_TYPE_PORT_internal']
	port_inst.size = 32
	poly_inst = type_registry['MACH_MSG_TYPE_POLYMORPHIC']
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_PORT_SEND", poly_inst, port_inst)

	port_inst = type_registry['MACH_MSG_TYPE_PORT_internal']
	port_inst.size = 32
	poly_inst = type_registry['MACH_MSG_TYPE_POLYMORPHIC']
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_PORT_SEND_ONCE", poly_inst, port_inst)


	send_inst = type_registry['MACH_MSG_TYPE_SEND_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_SEND']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_COPY_SEND", send_inst, port_inst)

	send_inst = type_registry['MACH_MSG_TYPE_SEND_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_SEND']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_MAKE_SEND", send_inst, port_inst)

	send_inst = type_registry['MACH_MSG_TYPE_SEND_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_SEND']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_MOVE_SEND", send_inst, port_inst)

	send_inst = type_registry['MACH_MSG_TYPE_SEND_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_SEND_ONCE']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_MAKE_SEND_ONCE", send_inst, port_inst)
	
	send_inst = type_registry['MACH_MSG_TYPE_SEND_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_SEND_ONCE']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_MOVE_SEND_ONCE", send_inst, port_inst)

	send_inst = type_registry['MACH_MSG_TYPE_RECEIVE_internal']
	port_inst = type_registry['MACH_MSG_TYPE_PORT_RECEIVE']
	port_inst.size = 32
	type_registry.make_type_add_type('polymorphic', "MACH_MSG_TYPE_MOVE_RECEIVE", send_inst, port_inst)
	
'''
