"""
Specialised tester for IDL; we want:

- Display parse tree
- Display AST
"""

import sys, re
from optparse import OptionParser
#from idlparser import parser as idlparser
#from idlparser import astgen
#from parser_common import ParserLexerState
from idlparser import parse_to_pt_cached,parse_to_pt_noncached, parse_to_ast
#from magpietypes.registry import new_registry
#from magpietypes.idlastwalker import IDLASTWalker
from magpidl4 import IDL4OptionParser
from targets.shared.inputparser import CASTImporter as Importer
#from cache import cache
#from targets.shared.inputparser import ASTGeneratorCImportMixIn, IDLASTImporter
from targets.shared.options import options
from magpietypes.builtin import create_basictype_ast


# "constants"
REGISTRY_MACHINE_TYPE = "Generic 32"

def gimme_a_registry():
	""" Provide a type registry with builtin types for ast and cpp """
	return new_registry(REGISTRY_MACHINE_TYPE)

def main():
	# Parse command-line arguments and dispatch to appropriate tester.
	parser_inst = IDL4OptionParser()
	parser_inst.setup()
	#parser_inst.parser.add_option('--data', dest = 'data', action = 'store_true', default = False,
	#		help = 'Import types and display the type registry')
	parser_inst.parser.add_option('--pt', dest = "pt", action = 'store_true', default = False,
			help = 'Display the MIG parse tree')
	parser_inst.parser.add_option('--ast', dest = 'ast', action = 'store_true', default = False,
			help = 'Display the MIG AST')
	parser_inst.parser.add_option('--types', dest = 'types', action = 'store_true', default = False,
			help = 'Import types and display the type registry')
	cmdlineoptions, cmdlineargs = parser_inst.parse_options()
	if cmdlineoptions.print_version:
		print VERSION_STRING
		sys.exit(0)
	if cmdlineargs == []: # No files, so exit
		parser_inst.print_help()
		print >>sys.stderr, "\nExiting because no IDL files were specified.\n"
		sys.exit(1)
		
	if cmdlineoptions.ugly_includepath_hack is not None:
		cmdlineoptions.include_dirs = [os.path.join(cmdlineoptions.ugly_includepath_hack, i)
			for i in cmdlineoptions.include_dirs]
	
	
	
	#parser = OptionParser()
	
	
	parser_inst.set_options()
	options.add_idl_files(cmdlineargs)
	options['target'] = parser_inst.get_target()
	options.set_initialised()
	#registry = new_registry(REGISTRY_MACHINE_TYPE)
	importer = Importer(options.filenames)
	data = importer.preprocess_and_grab_data(options.filenames)
	hardware_arch = options['hardware_arch']
	generator_type = options['generator']
		
	
	pt = parse_to_pt_noncached(data)
	
	if cmdlineoptions.pt:
		print "*** PT:"
		pt.print_tree()
		print "*** PT ends"
	
	if cmdlineoptions.ast:
		basicast = create_basictype_ast(hardware_arch, generator_type)
		#basicast = create_basictype_ast(arch_sizes, 'C')
		#print "*** BASIC-AST:"
		#basicast.print_tree()
		#print "*** BASIC-AST ends"
		#print registry.getBasicTypenode('char', basicast.children[-1])
		
		ast = parse_to_ast(pt, options.filenames, basicast)
		basicast.add_child(ast)
		print "*** AST:"
		basicast.print_tree()
		print "*** AST ends"
		#walker = IDLASTWalker(registry)
		#registry.print_registry()
		#walker.find_types(ast)
		
	#if cmdlineoptions.types:
	#	print "*** Types list:"
	#	registry.print_registry()
	#	print "*** Types list ends"
		
	
	
if __name__ == '__main__':
	main()
