from parser_common import *
#from magpietypes.registry import new_registry
from magpietypes.infogripper import *
# AST helper functions


class ASTGen(object):
	def __init__(self, ast):
		self.current_ast = ast
		
	def convert(self, ast,filename, pt):
		return self.translation_unit(ast, filename, pt)
		
	def translation_unit(self, basicast, filename, pt):
		#print 'basic ast = %s' %(basicast.type)
		ast = Node(basicast, "IDLFile")
		ast.leaf = filename
		#print 'ast.parent = %s' %(ast.parent.type)
		for node in pt.children:
			if node.type == 'decorated_definition':
				
				def_node = Definition(ast, None)
				ast.add_child(def_node)
				def_children = self.decorated_def(def_node, node)
				def_node.add_children(def_children)
				
			elif node.type == 'import_dcl':
				imp_node = self.import_dcl(node)
				ast.add_child(imp_node)
			else:
				#print 'node = ', node.type
				ast.add_child(UnknownNode(None, node))
		return ast
		
		
	def import_dcl(self, pt):
		ast = Node(None, None)
		ast.type = "cimport" #pt.leaf
		"""
		if pt.leaf == 'import':
			#imported_scope
			child = pt.the('imported_scope').children[0]
		elif pt.leaf == 'cimport':
			child = pt.the('anglequoted_scope').children[0]
		"""
		
		child = pt.children[0].children[0]
		assert child is not None
		
			
		
		if child.type == 'string_literal':
			ast.leaf = child.leaf
		elif child.type == 'scoped_name':
			ast.leaf = self.scoped_name(child)
		elif child.type == 'anglequoted_string_literal':
			ast.leaf = child.leaf
		else:
			ast = Node(None, child)
			ast.type = 'import'
		return ast
		
	def decorated_def(self, ast, pt):
		dec_def_children = []
		#child = pt.the('definition')
		
		
		for child in pt.children:
			if child.type == 'decorator':
				dec_children = self.decorator_elements(child)
				dec_node = Decorator(ast, dec_children)
				dec_def_children.append(dec_node)
			elif child.type == 'definition':
				self.definition(ast, child, dec_def_children)
			else:
				dec_def_children.append(UnknownNode(None, child))
		return dec_def_children

	def decorator_elements(self,pt):
		children = []
		for child in pt.children:
			if child.type == 'decorator_element':
				dec_el = self.decorator_element(child)
				children.append(dec_el)
			else:
				children.append(UnknownNode(child))
		#print '\n', children
		return children
				
	def decorator_element(self, pt):
		dec_node = Annotation(None)
		for child in pt.children:
			if child.type == 'identifier':
				dec_node.leaf = child.leaf
			elif child.type == 'expr_list':
				dec_node.add_children(self.expr_list(child, True))
			else:
				dec_node.add_child(UnknownNode(child))
		return dec_node
		
	def expr_list(self, pt, evaluate = False):
		ex_list = []
		for child in pt.children:
			if child.type == 'const_exp':
				exp_node = self.getExpression(child, evaluate)
				#print exp_node.leaf, exp_node.result
				ex_list.append(exp_node)
			else:
				ex_list.append(UnknownNode(child))
		return ex_list
		
	def getExpression(self, node, evaluate=False):
		exprnode = Expression(None) # FIXME: We really need parent here, for evaluation
		#print "getExpression for:"
		#node.print_tree()
		#print "Tree printed"
		if len(node.children) == 0:
			if node.type == 'scoped_name':
				exprnode.leaf = self.scoped_name(node)
			elif node.type == 'identifier':
				exprnode.leaf = node.leaf
		elif len(node.children) == 1:
			if node.type == 'scoped_name':
				exprnode.leaf = self.scoped_name(node)
			elif node.type == 'literal':
				exprnode.leaf = node.leaf
				if evaluate:
					exprnode.result = self.getValue(node)
			elif node.type == 'const_exp':
				exprnode = self.getExpression(node.children[0], evaluate)
			elif node.type == 'primary_expr':
				exprnode = self.getExpression(node.children[0], evaluate)
			else:
				exprnode = self.getExpression(node.children[0], evaluate)
				#print node
				
		elif len(node.children) == 2:
			if node.type == 'unary_expr':
				rhs = self.getExpression(node.children[1], evaluate)
				exprnode.leaf= '('+ node.children[0].leaf + rhs.leaf +')'
				if evaluate and rhs.result is not None:
					if node.children[0].leaf == '-':
						exprnode.result = -rhs.result
					elif node.children[0].leaf == '~':
						exprnode.result = ~rhs.result
					else:
						exprnode.result = rhs.result # FIXME?
			else:
				lhs = self.getExpression(node.children[0], evaluate)
				rhs = self.getExpression(node.children[1], evaluate)
				exprnode.leaf = '('+lhs.leaf+'' + node.leaf + '' + rhs.leaf+')'
				if evaluate and lhs.result is not None and rhs.result is not None:
					if node.type == 'or_expr':
						exprnode.result = lhs.result | rhs.result
					elif node.type == 'xor_expr':
						exprnode.result = lhs.result ^ rhs.result
					elif node.type == 'and_expr':
						exprnode.result = lhs.result & rhs.result
					
		elif len(node.children) == 3:
			lhs = self.getExpression(node.children[0], evaluate)
			rhs = self.getExpression(node.children[2], evaluate)
			
			# FIXME: leaf[0]?
			if isinstance(node.children[1].leaf, list):
				exprnode.leaf = '('+lhs.leaf + node.children[1].leaf[0] + rhs.leaf+')'
			else:
				exprnode.leaf = '(' + lhs.leaf + node.children[1].leaf[0] + rhs.leaf + ')'
			if evaluate and lhs.result is not None and rhs.result is not None:
				if node.type == 'shift_expr':
					if node.children[1].leaf == '<<':
						exprnode.result = lhs.result << rhs.result
					else:
						exprnode.result = lhs.result >> rhs.result
				elif node.type == 'add_expr':
					if node.children[1].leaf == '+':
						exprnode.result = lhs.result + rhs.result
					else:
						exprnode.result = lhs.result - rhs.result
				elif node.type == 'mult_expr':
					if node.children[1].leaf == '*':
						exprnode.result = lhs.result * rhs.result
					elif node.children[1].leaf == '/':
						exprnode.result = lhs.result / rhs.result
					else:
						# FIXME
						exprnode.result = lhs.result % rhs.result

		else:
			exprnode.leaf += ' + ERROR'
			print node, '  ' , str_exp
		return exprnode
		
	def getValue(self, node):
		if node.children[0].type == 'integer_literal':
			return int(eval(node.children[0].leaf))
		elif node.children[0].type == 'floating_pt_literal':
			return float(eval(node.children[0].leaf))
		elif node.children[0].type == 'boolean_literal':
			return bool(eval(node.children[0].leaf))
		else:
			return None #node.leaf
	
		
	def definition(self, ast, pt, parent = None):
		child = UnknownNode(None, pt.children[0])
		if pt.children[0].type == 'type_dcl':
			children = self.type_dcl(ast, pt.children[0])
			parent.extend(children)
			return
		elif pt.children[0].type == 'const_dcl':
			child = self.const_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'except_dcl':
			child = self.except_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'interf':
			child = self.interf(ast, pt.children[0])
		elif pt.children[0].type == 'module':
			child = self.module(ast, pt.children[0])
		elif pt.children[0].type == 'value':
			child = self.value_def(ast, pt.children[0])
		elif pt.children[0].type == 'type_id_dcl':
			child = self.type_id_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'type_prefix_dcl':
			child = self.type_prefix_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'event':
			child = self.event_def(ast, pt.children[0])
		elif pt.children[0].type == 'component':
			child = self.component(ast, pt.children[0])
		elif pt.children[0].type == 'home_dcl':
			child = self.home_dcl(ast, pt.children[0])
		else:
			child = UnknownNode(None, pt.children[0])
		parent.append(child)
		return 
	
	def type_dcl(self, ast, pt):
		if pt.children[0].type == 'type_declarator':
			#typedef:
			typeref, new_type = self.type_spec(ast, pt.the('type_declarator').the('type_spec'))
			decls = pt.the('type_declarator').the('declarators')
			if new_type:
				decl_list = [typeref]
			else:
				decl_list = []
			decl_list.extend(self.create_type_list(ast, typeref, decls.children))
			return decl_list
			
		elif pt.children[0].type == 'struct_type':
			struct_node = self.struct_type(ast, pt.children[0])
			return [struct_node]
		elif pt.children[0].type == 'enum_type':
			enum_node = self.enum_type(ast, pt.children[0])
			return [enum_node]
		elif pt.children[0].type == 'union_type':
			union_node = self.union_type(ast, pt.children[0])
			return [union_node]
		elif pt.children[0].type == 'simple_declarator':
			typenode = Type(ast)
			typenode.leaf = pt.children[0].leaf
			typenode.add_attribute('meta_type', 'native')
			return [typenode]
			
		elif pt.children[0].type == 'constr_forward_decl':
			typenode = Type(ast)
			typenode.leaf = pt.the('constr_forward_decl').the('identifier').leaf
			typenode.add_attribute('meta_type', 'forward')
			info = Info(typenode)
			typenode.add_child(info)
			#typetype = 'forward ' + pt.the('constr_forward_dcl').leaf
			info.add_attribute('meta_type' , pt.the('constr_forward_decl').leaf)
			return [typenode]
		else:
			type_node = UnknownNode(None, pt.children[0])
			return [type_node]

	def const_dcl(self, ast, pt):
		const_node = Const(ast)
		const_node.leaf = pt.the('identifier').leaf
		const_node.add_attribute('target_type', self.const_type(const_node, pt.the('const_type')))
		expr = self.getExpression(pt.the('const_exp'), True)
		if expr.result is not None:
			const_node.add_attribute('value', expr.result)
		else:
			const_node.add_attribute('value', expr.leaf)
		
		#type_inst = self.registry[const_node.the('type').leaf]
		#self.registry.make_instance_add_instance(type_inst, const_node.leaf, const_node.get_attribute('value'))
		return const_node
	
	def const_type(self, ast, pt):
		child = pt.children[0]
		#typenode = Type(ast, None)
		if child.type == 'integer_type':
			name = self.integer_type(ast, child)
			typeref = getBasicTypenode(name, type_node)
		elif child.type == 'char_type':
			typeref = getBasicTypenode('char', type_node)
		elif child.type == 'wide_char_type':
			typeref = getBasicTypenode('wchar', type_node)
		elif child.type == 'boolean_type':
			typeref = getBasicTypenode('boolean', type_node)
		elif child.type == 'floating_pt_type':
			name = self.floating_pt_type(typenode, child)
			typeref = getBasicTypenode(name, type_node)
		elif child.type == 'string_type':
			typeref = self.string_type(typenode, child)
		elif child.type == 'wide_string_type':
			typeref = self.string_type(typenode, child, True)
		elif child.type == '_type':
			pass #typenode.leaf = 'fixed'
		elif child.type == 'scoped_name':
			typeref = self.scoped_name_type(ast, child)
		elif child.type == 'octet_type':
			pass #typenode.leaf = 'octet'
		else:
			typenode.leaf = 'UNKOWN'
		return typeref

	def except_dcl(self,ast,  pt):
		excep_node = ExceptionNode(ast, None)
		excep_node.leaf = pt.the('identifier').leaf
		if pt.the('opt_member_list') != None:
			excep_node.add_children(self.member_list(ast, pt.the('opt_member_list')))
		return excep_node

	def type_id_dcl(self,ast,  pt):
		type_id = Node(ast, name='typeid')
		type_id.leaf = self.scoped_name(ast, pt.the('scoped_name'))
		type_id.add_attribute('value', pt.the('string_literal').leaf)
		return type_id

	def type_prefix_dcl(self, ast, pt):
		type_id = Node(ast, name='typeprefix')
		type_id.leaf = self.scoped_name(ast, pt.the('scoped_name'))
		type_id.add_attribute('value', pt.the('string_literal').leaf)
		return type_id
	
	def interf(self,ast,  pt):
		interface = Interface(ast, None)
		if pt.leaf == 'abstract' or pt.leaf == 'local':
			interface.add_attribute('modifier', pt.leaf)
		for child in pt.children:
			if child.type == 'identifier':
				interface.leaf = child.leaf
			elif child.type == 'interface_dcl':
				#print child
				if child.the('interface_header') != None:
					scope_list = child.the('interface_header').the('interface_inheritance_spec').the('scoped_name_list')
					for scope_name in scope_list['scoped_name']:
						inher_node = Inheritance(interface, name = self.scoped_name(scope_name))
						interface.add_child(inher_node)
						inher_node.add_attribute('target_scope', find_scope(interface, inher_node.leaf))
						
				if child.the('interface_body') != None:
					for export_child in child.the('interface_body').children:
						exp_node = self.export(interface, export_child)
						interface.add_children(exp_node)

		return interface
	
	def module(self, ast, pt):
		mod = Module(ast, None)
		for child in pt.children:
			if child.type == 'identifier':
				mod.leaf = child.leaf
			elif child.type == 'definition_list':
				for def_child in child.children:
					def_children = self.decorated_def(mod, def_child)
					def_node = Definition(mod, def_children)
					mod.add_child(def_node)
				#def_child = self.definition(def_child)
				#mod.add_child(def_child)
			else:
				mod.add_child(UnknownNode(None,child))
		return mod
	
	def value_def(self, ast, pt):
		if pt.children[0].type == 'value_dcl':
			return self.value_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'value_abs_dcl':
			return self.value_abs_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'value_box_dcl':
			val_node = Valuetype(ast, None)
			val_node.leaf = pt.children[0].the('identifier').leaf
			val_node.add_child(self.type_spec(val_node, pt.children[0].the('type_spec')))
			return val_node
		elif pt.children[0].type == 'value_custom_dcl':
			val_node = self.value_dcl(ast, pt.children[0].the('value_dcl'))
			val_node.add_attribute('modifier', 'custom')
			return val_node
		elif pt.children[0].type == 'value_forward_dcl':
			val_node = Valuetype(ast, None)
			val_node.leaf = val_node.leaf = pt.children[0].the('identifier').leaf
			val_node.add_attribute('modifier', 'forward')
			return val_node
		else:
			return UnknownNode(None, pt.children[0].type)
			
	def event_def(self, ast, pt):
		event_node = Event(ast)
		child = pt.children[0]
		if child.type == 'event_abs':
			event_node.add_attribute('modifier', 'abstract')
			event_node.leaf = child.the('event_abs_dcl').the('event_header').the('identifier').leaf
			if child.the('event_abs_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_abs_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_abs_dcl')[export]:
					exp_list.extend(self.export(exp_child))
				if exp_list != []:
					event_node.add_child(Export(None, exp_list))
		elif child.type == 'event_custom':
			event_node.add_attribute('modifier', 'custom')
			event_node.leaf = child.the('event_custom').the('event_header').the('identifier').leaf
			if child.the('event_elem_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_elem_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_elem_dcl')[export]:
					exp_list.extend(self.export(exp_child))
				if exp_list != []:
					event_node.add_child(Export(exp_list))
		elif child.type == 'event_dcl':
			event_node.leaf = child.the('event_dcl').the('event_header').the('identifier').leaf
			if child.the('event_elem_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_elem_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_elem_dcl')[export]:
					exp_list.extend(self.export(event_node, exp_child))
				if exp_list != []:
					event_node.add_child(Export(None, exp_list))
		
		else:
			return UnknownNode(None, child)
	
	def component(self,ast, pt):
		component = Component(ast, None)
		component.leaf = pt.the('identifier').leaf
		dcl = pt.the('component_dcl')
		if  dcl != None:
			inh = dcl.the('component_inheritance_spec')
			if inh != None:
				inher_node = Inheritance(component, name = self.scoped_name(interface, scope_name))
				inher_node.add_attribute('target_scope',find_scope(interface, inher))
				component.add_child(inher_node)
			
			sup = dcl.the('supported_interface_spec')
			if sup != None:
				supnode = Support(component)
				name_list = []
				for name in sup['scoped_name']:
					newname = self.scoped_name(name)
					name_list.append(newname)
					target_list.append(getTypenode(newname, component))
				supnode.leaf = name_list
				supnode.add_attribute('target_scope_list', target_list)
				component.add_child(supnode)
			
			bod = dcl.the('component_body')
			if bod != None:
				exp_list = self.component_body(component, bod)
				if exp_list != []:
					component.add_children(exp_list)
		return component
	
	def home_dcl(self, ast, pt):
		homenode = Home(ast)
		#
		#	HEADER
		#
		homeheader = pt.the('home_header')
		homenode.leaf = homeheader.the('identifier').leaf
		if homeheader.the('home_inheritance_spec') != None:
			inhnode = Inheritance(homenode)
			inhnode.leaf = self.scoped_name(homeheader.the('home_inheritance_spec').the('scoped_name'))
			inhnode.add_attribute
			homenode.add_child(inhnode)
		if homeheader.the('supported_interface_spec') != None:
			supnode = Support(homenode)
			namelist = []
			for name in homeheader.the('supported_interface_spec')['scoped_name']:
				namelist.append(self.scoped_name(name))
			supnode.leaf = namelist
			homenode.add_child(supnode)
		mannode = Node(homenode, None, name='manages')
		mannode.leaf = self.scoped_name(homheader.the('scoped_name'))
		mannode.add_attribute('target_scope', self.find_scope(mannode.leaf))
		if homeheader.the('primary_key_spec') != None:
			mannode.add_attribute('primarykey', self.find_scope(self.scoped_name(homenode, homeheader.the('primary_key_spec').the('scoped_name'))))
		homenode.add_child(mannode)
		#
		#	BODY
		#
		homebody = pt.the('home_body')
		for child in homebody.children:
			if child.children[0].type == 'export':
				homenode.add_children(self.export(homenode, child.children[0]))
			elif child.children[0].type == 'factory_dcl':
				homenbode.add_child(self.factory_dcl(homenode, child.children[0]))
			elif child.children[0].type == 'finder_dcl':
				homenode.add_child(self.finder_dcl(homenode, child.children[0]))
			else:
				homenode.add_child(UnknownNode(None, child.children[0]))
		
		return homenode
	
	def factory_dcl(self,ast, pt):
		fac_node = Node(ast, None, name = 'factory')
		fac_node.leaf = pt.the('identifier').leaf
		fac_node.add_children(self.init_param_decls(fac_node, pt.the('init_param_decls')))
		if pt.the('raises_expr') != None:
			raises = Node(fac_node, name='raises')
			leaflist = []
			target_list = []
			for node in child.the('scoped_name_list').children:
				if node.type == 'scoped_name':
					newname = self.scoped_name(node)
					target_list = getTypenode(newname, ast)
					leaflist.append()
			raises.leaf = leaflist
			raises.add_attribute('target_scope_list', target_list)
			fac_node.add_child(raises)
		return fac_node
	
	def finder_dcl(self, ast, pt):
		fac_node = Node(ast, None, name = 'finder')
		fac_node.leaf = pt.the('identifier').leaf
		fac_node.add_children(self.init_param_decls(fac_node, pt.the('init_param_decls')))
		if pt.the('raises_expr') != None:
			raises = Node(fac_node, name='raises')
			leaflist = []
			target_list = []
			for node in child.the('scoped_name_list').children:
				if node.type == 'scoped_name':
					newname = self.scoped_name(node)
					target_list = getTypenode(newname, ast)
					leaflist.append(newname)
			raises.leaf = leaflist
			raises.add_attribute('target_scope_list', target_list)
			fac_node.add_child(raises)
		return fac_node
		
	
	def component_body(self, ast, pt):
		exp_list = []
		for exp in pt.children:
			exp_node = Export(ast)
			if exp.children[0].type == 'provides_dcl':
				exp_node.add_attribute('type', 'provides')
				exp_node.leaf = exp.children[0].the('identifier').leaf
				if exp.children[0].the('interface_type').the('scoped_name') != None:
					scopedname = self.scoped_name(exp.children[0].the('interface_type').the('scoped_name'))
					exp_node.add_attribute('name', scopedname)
				else:
					exp_node.add_attribute('name', 'Object')
			elif exp.children[0].type == 'uses_dcl':
				typestr = ''
				for child in exp.children[0]['uses_dcl']:
					typestr += child.leaf
				exp_node.add_attribute('type', typestr)
				exp_node.leaf = exp.children[0].the('identifier').leaf
				if exp.children[0].the('interface_type').the('scoped_name') != None:
					scopedname = self.scoped_name(exp.children[0].the('interface_type').the('scoped_name'))
					exp_node.add_attribute('name', scopedname)
				else:
					exp_node.add_attribute('name', 'Object')
			elif exp.children[0].type == 'emits_dcl':
				exp_node.add_attribute('type', 'emits')
				exp_node.leaf = exp.children[0].the('identifier').leaf
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'publishes_dcl':
				exp_node.add_attribute('type', 'publishes')
				exp_node.leaf = exp.children[0].the('identifier').leaf
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'consumes_dcl':
				exp_node.add_attribute('type', 'consumes')
				exp_node.leaf = exp.children[0].the('identifier').leaf
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'attr_dcl':
				exp_node.add_child(self.attr_dcl(exp.children[0]))
			else:
				exp_list.append(UnknownChild(None, exp))
			exp_list.append(exp_node)
		return exp_list
		
	
	def value_dcl(self, ast, pt):
		node = Valuetype(ast, None)
		for child in pt.children:
			if child.type == 'identifier':
				node.leaf = child.leaf
			elif child.type == 'value_inheritance_spec':
				val_inh_node = self.value_inheritance_spec(node, self, child)
				node.add_child(val_inh_node)
			else:
				node.add_child(UnknownNode(child))
		return node
	
	def value_abs_dcl(self, at, pt):
		node = Valuetype(ast, None)
		node.add_attribute('modifier', 'abstract')
		for child in pt.children:
			if child.type == 'identifier':
				node.leaf = child.leaf
			elif child.type == 'value_abs_full_dcl':
				val_inh_node = self.value_inheritance_spec(node, self, child.the('value_inheritance_spec'))
				exp_list = []
				for exp_child in child[export]:
					exp_list.extend(self.export(exp_child))
				if exp_list != []:
					val_inh_node.add_child(Export(val_inh_node, exp_list))
			else:
				node.add_child(UnknownNode(None, child))
		return node
		
	def value_inheritance_spec(self, ast, pt):
		if pt.children[0].type == 'value_value_inheritance_spec':
			inh_node = Inheritance(ast, None)
			inh_node.add_attribute('relation', 'value')
			if pt.children[0].the('value_value_inheritance_spec') != None:
				inh_node.add_attribute('modifier', pt.children[0].the('value_value_inheritance_spec').leaf)
			name_list = []
			target_list = []
			for name in pt.the('value_value_inheritance_spec')['value_name']:
				newname = self.scoped_name(name.the('scoped_name'))
				name_list.append(newname)
				target_list.append(getTypenode(newname, ast))
			inh_node.leaf = name_list
			inh_node.add_attribute('target_scope_list',target_list)
			return inh_node
		elif pt.children[0].type == 'value_interface_inheritance_spec':
			inh_node = Inheritance(ast, None)
			inh_node.add_attribute('relation', 'interface')
			name_list = []
			target_list = []
			for name in pt.the('value_interface_inheritance_spec')['interface_name']:
				newname = self.scoped_name(name.the('scoped_name'))
				name_list.append(newname)
				target_list.append(getTypenode(newname, ast))
			inh_node.add_attribute('target_scope_list',target_list)
			inh_node.leaf = name_list
			return inh_node
		else:
			return UnknownNode(None, pt)
	
	def value_element(self, ast, pt):
		if pt.children[0].type == 'export':
			return self.export(ast, pt.children[0])
		elif pt.children[0].type == 'state_member':
			return self.state_member(ast, pt.children[0])
		elif pt.children[0].type == 'init_dcl':
			return self.init_dcl(ast, pt.children[0])
		else:
			return UnknownNode(None, pt)
	
	def state_member(self, ast, pt):
		type_node = Type(ast, None)
		
		if pt.the('state_member') != None:
			type_node.leaf = child.leaf
		type_node.add_child(self.type_spec(ast, pt.the('type_spec')))
		decls = pt.the('declarators')
		decl_list = []
		for child in decls.children:
			decl_list.append(self.getDeclarator(child))
		dec_node = Declarator(type_node, None)
		dec_node.leaf = decl_list
		type_node.add_child(dec_node)
		return type_node
	
	def init_dcl(self, ast, pt):
		type_node = Node(ast, None, name = 'factory')
		type_node.leaf = pt.the('identifier').leaf
		if pt.the('init_param_decls') != None:
			type_node.add_children(self.init_param_decls(type_node, pt.the('init_param_decls')))
		if pt.the('raises_expr') != None:
			raises = Node(type_node, name='raises')
			leaflist = []
			target_list = []
			for node in child.the('scoped_name_list').children:
				if node.type == 'scoped_name':
					newname = self.scoped_name(node)
					leaflist.append(newname)
					target_list.append(getTypenode(newname, type_node))
			raises.leaf = leaflist
			type_node.add_child(raises)
		return type_node
		
	def init_param_decls(self, ast, pt):
		decl_list = []
		for child in pt['init_param_decl']:
			param_node = Parameter(ast, None)
			param_node.add_child(self.param_type_spec(param_node, child.the('param_type_spec')))
			param_node.leaf = child.the('simple_declarator').leaf
			if child.the('init_param_attribute') != None:
				param_node.add_attribute('attribute', child.the('init_param_attribute').leaf)
			decl_list.append(param_node)
		return decl_list

	def export(self, ast, pt):
		if pt.children[0].type == 'type_dcl':
			return self.type_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'const_dcl':
			return [self.const_dcl(pt.children[0])]
		elif pt.children[0].type == 'except_dcl':
			return [self.except_dcl(ast, pt.children[0])]
		elif pt.children[0].type == 'attr_dcl':
			return [self.attr_dcl(ast, pt.children[0])]
		elif pt.children[0].type == 'op_dcl':
			return [self.op_dcl(ast, pt.children[0])]
		elif pt.children[0].type == 'type_id_dcl':
			return [self.type_id_dcl(ast, pt.children[0])]
		elif pt.children[0].type == 'type_prefix_dcl':
			return [self.type_prefix_dcl(ast, pt.children[0])]
		else:
			return [UnknownNode(None, pt.children[0])]
		
	def attr_dcl(self,ast, pt):
		attr_node = Attribute(ast, None)
		type_node = self.param_type_spec(attr_node, pt.children[0].the('param_type_spec'))
		if pt.children[0].type == 'readonly_attr_spec':
			attr_node.add_attribute('mode', 'readonly')
			attr_node.add_child(self.attr_declarator(attr_node, pt.children[0].the('readonly_attr_declarator')))
			#self.attr_declarator(pt.children[0].the('readonly_attr_declarator'), type_node)
		elif pt.children[0].type == 'attr_spec':
			attr_node.add_attribute('mode', 'readwrite')
			attr_node.add_child(self.attr_declarator(attr_node, pt.children[0].the('attr_declarator')))
			#attr_node.add_child(self.attr_declarator(pt.children[0].the('attr_declarator')), type_node)
		else:
			attr_node = UnknownNode(None, pt.children[0])
		type_node.add_attribute('declarator', attr_node.the('declarator').leaf)
		attr_node.add_child(type_node)
		
		return attr_node
		
	def op_dcl(self,ast, pt):
		fcn = Function(ast, None)
		for child in pt.children:
			if child.type == 'decorator':
				#print child
				dec_children = self.decorator_elements(child)
				dec_node = Decorator(fcn, dec_children)
				fcn.add_child(dec_node)
			elif child.type == 'op_attribute':
				fcn.add_attribute('attribute', child.leaf)
			elif child.type == 'op_type_spec':
				
				if child.leaf == 'void':
					target = getTypenode('void', fcn)
				#print 'trying to get typenode for: %s' %(child.the('param_type_spec'))
				else:
					target = self.param_type_spec(fcn, child.the('param_type_spec'))
				typenode = Type(fcn, None)
				typenode.type = 'return_type'
				typenode.add_attribute('target_type', target)
				fcn.add_child(typenode)
			elif child.type == 'op_dcl':
				fcn.leaf = child.leaf
			elif child.type == 'parameter_dcls':
				fcn.add_children(self.parameter_dcls(fcn, child))
			elif child.type == 'raises_expr':
				raises = Node(fcn, name='raises')
				leaflist = []
				target_list = []
				for node in child.the('scoped_name_list').children:
					if node.type == 'scoped_name':
						newname = self.scoped_name(node)
						leaflist.append(newname)
						target_list.append(getTypenode(newname, fcn))
				raises.leaf = leaflist
				raises.add_attribute('target_scope_list', target_list)
				fcn.add_child(raises)
			elif child.type == 'context_expr':
				context = Node(fcn, name='context')
				leaflist = []
				for node in child.the('string_literal_list').children:
					if node.type == 'string_literal':
						leaflist.append(node.leaf)
				context.leaf = leaflist
				fcn.add_child(context)
			else:
				fcn = UnknownNode(None, child)
		return fcn
		
	def parameter_dcls(self, ast, pt):
		param_list = []
		if pt.the('param_dcl_list') != None:
			dec_node = None
			param_node = None
			for child in pt.the('param_dcl_list').children:
				if child.type == 'decorator':
					#print child
					dec_els = self.decorator_elements(child)
					dec_node = Decorator(ast, dec_els)
					
					#print dec_node
				if child.type == 'param_dcl':
					param_node = self.param_dcl(ast, child)
					if dec_node != None:
						param_node.add_child(dec_node)
						dec_node = None
					param_list.append(param_node)
		return param_list
	
	def param_dcl(self, ast, pt):
		param_node = Parameter(ast, None)
		param_node.add_attribute('direction', pt.leaf)
		for child in pt.children:
			if child.type == 'param_type_spec':
				param_node.add_attribute('target_type',self.param_type_spec(ast, child))
			elif child.type == 'allow_indirection':
				param_node.add_attribute('indirection', child.leaf)
			elif child.type == 'simple_declarator':
				param_node.leaf = child.leaf
			else:
				param_node.add_child(UnkownNode(None, child))
		return param_node
			
			
					
	def attr_declarator(self, ast, pt):
		decl = Declarator(ast, None)
		
		for child in pt.children:
			if child.type == 'simple_declarator':
				#childnode = Node(None)
				#childnode.name = 'identifier'
				decl.leaf = child.leaf
				#decl.add_child(childnode)
			elif child.type == 'attr_raises_expr':
				decl.add_child(self.attr_raises_expr(decl, child))
			else:
				decl.add_child(UnkownNode(None, child))
		return decl
		
		
	def param_type_spec(self, ast, pt):
		if pt.children[0].type == 'base_type_spec':
			param_type = self.base_type_spec(ast, pt.children[0])
		elif pt.children[0].type == 'string_type':
			param_type = self.string_type(ast, pt.children[0])
		elif pt.children[0].type == 'wide_string_type':
			param_type = self.wide_string_type(ast, pt.children[0])
		elif pt.children[0].type == 'scoped_name':
			#print 'scoped_name: %s  %s' %(self.scoped_name(pt.children[0]), ast)
			param_type = self.scoped_name_type(ast, pt.children[0])
		else:
			param_type = UnknownNode(None, pt.children[0])
		assert param_type is not None
		return param_type
	
	def attr_raises_expr(self, pt):
		raisesnode = Node(None, None)
		for child in pt.children:
			if child.type == 'get_excep_expr':
				raisesnode.leaf = 'getraises'
				exception_list = self.exception_list(child.the('exception_list'))
				raisesnode.add_attribute('exception_list', exception_list)
			elif child.type == 'set_excep_expr':
				raisesnode.leaf = 'setraises'
				exception_list = self.exception_list(child.the('exception_list'))
				raisesnode.add_attribute('exception_list', exception_list)
			else:
				raisesnode = UnknownNode(None, child)
		return raisesnode
		
	def exception_list(self, pt):
		ex_list = []
		for child in pt.children:
			if child.type == 'scoped_name':
				ex_list.append(self.scoped_name(child))
		return ex_list
	
		
	def struct_type(self, ast, pt):
		type_node = Type(ast)
		type_node.leaf = pt.the('identifier').leaf
		type_node.add_attribute('meta_type', 'struct')
		membernode = self.member_list(type_node, pt.the('member_list'))
		type_node.add_children(membernode)
		return type_node

	def enum_type(self, ast, pt):
		type_node = Type(ast)
		type_node.add_attribute('meta_type', 'enum')
		for child in pt.children:
			if child.type == 'identifier':
				type_node.leaf = child.leaf
			elif child.type == 'enumerator_list':
				info = Info(type_node)
			enum_list = []
			for enum in child['enumerator']:
				enum_list.append(enum.leaf)
			info.add_attribute('enumeration', enum_list)
			type_node.add_child(info)
		return type_node

	def union_type(self,ast, pt):
		type_node = Type(ast)
		type_node.add_attribute('meta_type', 'union')
		info = Info(type_node)
		type_node.add_child(info)
		for child in pt.children:
			if child.type == 'identifier':
				type_node.leaf = child.leaf
			elif child.type == 'switch_type_spec':
				typeref = None
				if child.children[0].type == 'integer_type':
					name = self.integer_type(ast, child.children[0])
					typeref = getBasicTypenode(name, type_node)
				elif child.children[0].type == 'char_type':
					name = 'char'
					typeref = getBasicTypenode(name, type_node)
				elif child.children[0].type == 'boolean_type':
					name = 'boolean'
					typeref = getBasicTypenode(name, type_node)
				elif child.children[0].type == 'enum_type':
					typeref = self.enum_type(child.children[0])
					info.add_child(typeref)
				elif child.children[0].type == 'scoped_name':
					typeref = self.scoped_name_type(ast, child.children[0])
				#typeref.print_tree()
				#info.add_child(typeref)
				assert typeref is not None
				info.add_attribute('switch_type',typeref)
			elif child.type == 'switch_body':
				members = self.case_stmt_list(type_node, child.the('case_stmt_list'))
				type_node.add_child(members)
		return type_node

	def case_stmt_list(self, ast, pt):
		members = Node(ast, None)
		members.type = 'members'
		for case in pt.children:
			case_node = CaseNode(members, None)
			#case_node.leaf = case.leaf
			if case.the('const_exp') != None:
				expr = self.getExpression(case.the('const_exp'), False)
				case_node.leaf = expr.leaf
			typeref, new_type = self.type_spec(case_node, case.the('element_spec').the('type_spec'))
		if new_type:
			case_node.add_child(typeref)
			
			
		decl = case.the('element_spec').the('declarator')
		inst_list = self.create_instance_list(case_node, typeref, [decl])
		case_node.add_children(inst_list)
		members.add_child(case_node)
		return members
 
	def member_list(self, ast, pt):
		members = Node(ast, None)
		members.type = 'members'
		for child in pt.children:
			if child.type == 'member':
				typeref, new_type = self.type_spec(members, child.the('type_spec'))
				if new_type:
					if isinstance(typeref, str):
						pass
					else:
						members.add_child(typeref)
				members.add_children(self.create_instance_list(members, typeref, child.the('declarators').children))
			else:
				print 'memberlist_unknown' + child.type
		return [members]

	def scoped_name(self, pt):
		name = pt.leaf
		if name == '::':
			name = ''
		for child in pt.children:
			name += '::' + child.leaf
		return name

	def scoped_name_type(self, ast, pt):
		'''
		typenode = Type(ast, None)
		scoped_name = self.scoped_name(pt)
		typenode.add_attribute('meta_type', 'scoped_name')
		info = Info(typenode)
		info.add_attribute('scoped_name',scoped_name)
		typenode.add_child(info)
		'''
		scoped_name = self.scoped_name(pt)
		#print 'searching for: ', scoped_name
		target = getTypenode(scoped_name, ast)
		#print '... found node: '
		#target.print_tree()
		#info.add_attribute('target_type', target)
		#return typenode
		return target
	
	def type_spec(self, ast, pt):
		typeref = None
		new_type = True
		if pt.children[0].type == 'simple_type_spec':
			typeref, new_type = self.simple_type_spec(ast, pt.children[0])
		else: #constr_type_spec
			typeref = self.constr_type_spec(ast, pt.children[0])
		return (typeref, new_type)
		
	def simple_type_spec(self, ast, pt):
		typeref = None
		new_type = False
		if pt.children[0].type == 'base_type_spec':
			typeref = self.base_type_spec(ast, pt.children[0])
		elif pt.children[0].type == 'template_type_spec':
			typeref = self.template_type_spec(ast, pt.children[0])
			new_type = True
		else: #scoped_name
			typeref = self.scoped_name_type(ast, pt.children[0])
			
			assert typeref is not None
			typeref.print_tree()
		return (typeref, new_type)
		
	def base_type_spec(self, ast, pt):
		typename = None
		if pt.children[0].type == 'floating_pt_type':
			typename = self.floating_pt_type(ast, pt.children[0])
		elif pt.children[0].type == 'integer_type':
			typename = self.integer_type(ast, pt.children[0])
		else:
			typename = pt.children[0].leaf
		targetnode = getBasicTypenode(typename, ast)
		if targetnode == None:
			print 'name = %s not found!' %(typename)
		return targetnode

	def integer_type(self, ast, pt):
		namelist = []
		child = pt.children[0]
		while not (child.children == []):
			namelist.append(child.children[0].leaf)
			if len(child.children) == 2:
				namelist.appen(child.children[1].leaf)
			child = child.children[0]
		return ' '.join(namelist)

	def floating_pt_type(self,ast, pt):
		name = pt.leaf
		if pt.children != []:
			name += ' ' + pt.children[0].leaf
		return name

	def template_type_spec(self, ast, pt):
		typenode = Type(ast, None)
		if pt.children[0].type == 'sequence_type':
			typenode = self.sequence_type(ast, pt.children[0])
		elif pt.children[0].type == 'string_type':
			typenode = self.string_type(ast, pt.children[0])
		elif pt.children[0].type == 'wide_string_type':
			typenode = self.wide_string_type(ast, pt.children[0])
		elif pt.children[0].type == 'fixed_pt_type':
			typenode.add_attribute('meta_type', 'fixed_pt')
			pos_const_node = pt.the('fixed_pt_type')['positive_int_const'][0]
			expr = self.getExpression(pos_const_node.the('const_exp'))
			pre_size = expr.leaf
	
			pos_const_node = pt.the('fixed_pt_type')['positive_int_const'][1]
			const_expr = self.getExpression(pos_const_node.the('const_exp'))
			post_size = const_expr.leaf
		
			info = Info(typenode)
			info.add_attribute('shape', (pre_size, post_size))
			typenode.add_child(info)
		else:
			typenode = UnknownNode(None, pt.children[0])
		return typenode
		
	def sequence_type(self, ast, pt):
		typenode = Type(ast, None)
		typenode.add_attribute('meta_type', 'sequence')
		
		simple_type_node, new_type = self.simple_type_spec(ast, pt.the('simple_type_spec'))
		info = Info(typenode)
		typenode.add_child(info)
		if new_type:
			info.add_child(simple_type_node)
		info.add_attribute('target_type',simple_type_node)
		
		pos_const_node = pt.the('opt_pos_int')
		if pos_const_node != None:
			expr = self.getExpression(pos_const_node.the('positive_int_const').the('const_exp'))
			info.add_attribute('max_length', expr.leaf)
		return typenode
		
	def string_type(self, ast, pt, wstring = False):
		typenode = Type(ast, None)
		if wstring:
			typenode.add_attribute('meta_type', 'wstring')
		else:
			typenode.add_attribute('meta_type', 'string')
		pos_const_node = pt.the('positive_int_const')
		info = Info(typenode)
		typenode.add_child(info)
		if pos_const_node != None:
			expr = self.getExpression(pos_const_node.the('const_exp'))
			info.add_attribute('max_length', expr.leaf)
		return typenode
		
		
	def wide_string_type(self, ast, pt):
		stringtype = self.string_type(ast, pt, True)
		stringtype.leaf = 'wstring'
		return stringtype
		
	def wide_string_type(self, pt):
		typenode = Type(None)
		typenode.leaf = 'wstring'
		pos_const_node = pt.the('positive_int_const')
		if pos_const_node != None:
			expr = self.getExpression(pos_const_node.the('const_exp'))
			typenode.add_attribute('type', 'wstring')
			if result != None:
				name = ['wchar_t', result, '['+expr.leaf+ ']']
				typenode.add_attribute('length', result)
			else:
				name = ['wchar_t', expr.leaf, '['+expr.leaf+ ']']
				typenode.add_attribute('length', expr.leaf)
			typenode.leaf = name
		return typenode
	
	def constr_type_spec(self, ast, pt):
		constr_type_node = UnknownNode(None, pt.children[0])
		if pt.children[0].type == 'struct_type':
			constr_type_node = self.struct_type(ast, pt.children[0])
		elif pt.children[0].type == 'union_type':
			constr_type_node = self.union_type(ast, pt.children[0])
		elif pt.children[0].type == 'enum_type':
			constr_type_node = self.enum_type(ast, pt.children[0])
		return constr_type_node
	
	def getDeclarator(self, pt):
		decl_str = ''
		if pt.children[0].type == 'simple_declarator':
			decl_str = pt.children[0].leaf
		else: #complex_declarator
			array_dcl = pt.the('complex_declarator').the('array_declarator')
			leaf_str = array_dcl.leaf
			for child in array_dcl.children:
				exp_node = child.the('positive_int_const').the('const_exp')
				expr = self.getExpression(exp_node, True)
				array_dcl = []
				length_str = ''
				if expr.result is not None:
					array_dcl.append(res)
					length_str += '+(' + str(expr.result) + ')'
				else:
					array_dcl.append(expr.leaf)
					length_str += '+(' + expr.leaf+ ')'
			decl_str = [[leaf_str, length_str, array_dcl]]
		return decl_str
		
	def create_instance_list(self, ast, typeref, declarators):
		instance_list = []
		for child in declarators:
			instance = TypeInstance(ast, None)
			
			if child.children[0].type == 'simple_declarator':
				instance.leaf = child.children[0].leaf
				instance.add_attribute('target_type', typeref)
			else: #complex_declarator
				newtype = Type(ast)
				newtype.add_attribute('meta_type','array')
				info = Info(newtype)
				newtype.add_child(info)
				
				array_dcl = child.the('complex_declarator').the('array_declarator')
				array_dim = []
				for dimension in array_dcl.children:
					exp_node = dimension.the('positive_int_const').the('const_exp')
					expr = self.getExpression(exp_node, True)
					array_dim.append(expr.leaf)
					'''
					if res != None:
						array_dcl.append(str(res))
					else:
						array_dcl.append(exp_str)
					'''
				info.add_attribute('shape',array_dim)
				info.add_attribute('target_type', typeref)
				
				newinfo = Info(ast)
				newinfo.add_child(newtype)
								
				instance.add_attribute('target_type', newtype)
				instance.leaf = array_dcl.leaf
				instance.add_child(newinfo)
			instance_list.append(instance)
		return instance_list

	def create_type_list(self, ast, typeref, declarators):
		type_list = []
		for child in declarators:
			typenode = Type(ast, None)
			typenode.add_attribute('meta_type','alias')
			typeinfo = Info(typenode)
			typenode.add_child(typeinfo)
			if child.children[0].type == 'simple_declarator':
				typenode.leaf = child.children[0].leaf
				typeinfo.add_attribute('target_type', typeref)
			else: #complex_declarator
				newtype = Type(ast)
				newtype.add_attribute('meta_type','array')
				info = Info(newtype)
				newtype.add_child(info)
				
				array_dcl = child.the('complex_declarator').the('array_declarator')
				array_dim = []
				for dimension in array_dcl.children:
					exp_node = dimension.the('positive_int_const').the('const_exp')
					expr = self.getExpression(exp_node, True)
					array_dim.append(expr.leaf)

				info.add_attribute('shape',array_dim)
				info.add_attribute('target_type', typeref)
				
				typeinfo.add_attribute('target_type', newtype)
				typenode.leaf = array_dcl.leaf
				typeinfo.add_child(newtype)
				
			assert typenode.leaf != None
			type_list.append(typenode)
		return type_list
			
def gen(pt, filename, ast):
	astgen = ASTGen(ast)
	output = astgen.convert(ast,filename, pt)
	return output
