#from idlparser.helper import get_idl_type_name
from magpietypes.infogripper import word_size, size

class SimpleParam(object):
	"""
	A SimpleParam is a list of parameter attributes. A list of them is passed to
	the template so it doesn't have to know about the structure of the AST.
	"""
	def __init__(self):
		pass
	
	def init_fromdict(self, attributes_dict):
		self.attributes_dict = attributes_dict
	
	def init_fromdecl(self, decl_ast):
		self.attributes_dict = self.create(decl_ast)

	def init_asreturn(self, function_decl_ast):
		# Special case: function return type counts as special parameter with
		# direction 'return'. 
		#<print op_return_type
		self.init_fromdict({'indirection': '',
				'c_impl_indirection': '',
				'name': '__return',
				'type': function_decl_ast.the('return_type').get_attribute('target_type')[0],
				'typename': function_decl_ast.the('return_type').get_attribute('target_type')[0].leaf,
				'direction': 'return',
				'flags':''
		})
	
	def __repr__(self):
		return '<SimpleParam: %s%s(%s), %sc>' % (self['indirection'], self['name'], self['typename'], self['c_impl_indirection'])
	
	def __getitem__(self, key):
		return self.attributes_dict[key]
	
	def __setitem__(self, key, value):
		self.attributes_dict[key] = value
	
	def get(self, key, default):
		return self.attributes_dict.get(key, default)

	def create(self, parameter_decl):
		wordsize = word_size(parameter_decl)
		newparam = {}
		param_size = size(parameter_decl.get_attribute('target_type')[0])
		newparam['indirection'] = parameter_decl.get_single_attribute('indirection', '')
		assert newparam['indirection'] is not None
		if parameter_decl.has_attribute('direction'):
			newparam['direction'] = parameter_decl.get_attribute('direction')[0]
		else:
			assert False #direction is required!!

		assert newparam['direction'] in ('in', 'out', 'inout')
		newparam['name'] = parameter_decl.leaf
		newparam['type'] = parameter_decl.get_attribute('target_type')[0]
		newparam['typename'] = parameter_decl.get_attribute('target_type')[0].leaf
		if (newparam['direction'] in ('out', 'inout')) or param_size > wordsize: # or (newparam['idltype'].is_value_type is False):
			newparam['c_impl_indirection'] = '*'
		else:
			newparam['c_impl_indirection'] = ''
		return newparam

