"""
Transform the parse tree produced by parser.py to a higher-level tree using
recursive descent.
"""

from parser_common import *
from magpietypes.evaluator import evaluate
from magpietypes.infogripper import *
import operator


# AST parts.
'''
class ASTPart(Node):
	pass

class Declarator(ASTPart):
	def __init__(self, children = None):
		ASTPart.__init__(self, "declarator", children)

class Type(ASTPart):
	def __init__(self, children, name = None):
		ASTPart.__init__(self, 'type', children, name)
	
	def add_instances(self, *instances):
		self.add_attribute('instances', instances)
	
class Error(ASTPart):
	def __init__(self):
		ASTPart.__init__(self, "ERROR")

class UnknownNode(ASTPart):
	def __init__(self, pt):
		ASTPart.__init__(self, "Unknown")
		self.children = [pt]
	
	# Dummy methods so we can use this class everywhere
	def add_instances(self, *args):
		pass 

class UnknownLeaf(object):
	def __init__(self, pt = None):
		self.pt = pt
	
	def __repr__(self):
		return '<Unknown leaf; PT is %s>' % (self.pt)

'''

# AST helper functions

def all_children(node, names):
	for child_name in node.get_child_names():
		if child_name not in names:
			return False
	return True

# AST generator

CLASS_SPECIFIERS = ('union', 'struct', 'class', 'enum')

class ASTGen(object):
	def convert(self, ast, pt, filename):
		return self.translation_unit(ast, pt, filename)

	def translation_unit(self, baseast, pt, filename):
		#print 'PT'
		#pt.print_tree()
		#print 'PT done'
		#ast = Node(baseast, "translation_unit")
		#ast.leaf = filename
		ast = baseast # Hmm - nfd
		ref_node = ast
		for node in pt.children:
			if node.type == 'declaration':
				#print '*******************************\n\
				#	processing tree: '
				#node.print_tree()
				
				decl_types, decl_inst = self.declaration(ref_node, node)
				ast.add_children(decl_types)
				
				ref_node = decl_types[-1]
				if decl_inst != []:
					ast.add_children(decl_inst)
					ref_node = decl_inst[-1]
				#print '*******************************\n\
				#	new starting-tree: '
				#ref_node.print_tree()
				
				
				#print '*******************************\n\
				#	processing final-tree: '
				#ast.print_tree()
					
			elif node.type == 'function_definition':
				ast.add_child(Node(ast, 'unfinished_function_definition'))
			else:
				ast.add_child(UnknownNode(ast, node))
		return ast
	
	def declaration(self, parentast, pt):
		"""
		"""
		newNodes = []
		other_stuff = []
		# There should be two parts to this declaration.
		if pt.my_children_are('declaration_specifiers', 'init_declarator_list'):
			decl_specifiers = pt.the('declaration_specifiers')
			init_decl_list = pt.the('init_declarator_list')

			decl_type = decl_specifiers.leaf
			decl_type_node, isNewType, decl_type_inst = self._declaration_specifiers(parentast, decl_specifiers)
			
			if isNewType:
				other_stuff.append(decl_type_node)
			if decl_type_inst:
				other_stuff.extend(decl_type_inst)
			
			
			info_dict = {}
			# Add a bunch of attributes based on the specifiers.
			for decl_spec in decl_type:
				if decl_spec in ('extern', 'static'):
					info_dict['linkage'] = decl_spec
				elif decl_spec in ('const', 'restrict', 'volatile'):
					info_dict['type-qualifier'] = decl_spec
				elif decl_spec in ('const', 'typedef'):
					pass
				elif decl_spec in ('extern', 'static', 'auto', 'register'):
					info_dict['storage-class'] = decl_spec
				elif decl_spec in ('inline',):
					info_dict['function-specifier'] = decl_spec 
				else:
					print "DUNNO", decl_spec
					pt.print_tree()
					raise Exception()
					info_dict['specifiers_unknown'] = decl_spec
			
			
			declarators = self._init_declarator_list(parentast, init_decl_list)
			
			if 'typedef' in decl_type:
				for decl in declarators:
					# typedefs have no initialisers!??
					assert decl['expression'] is None
					name = decl['name']
					newNode = Type(None)
					newNode.leaf = name
					newNode.add_attribute('meta_type', 'alias')
					info = Info(newNode)
					newNode.add_child(info)
					assert decl_type_node is not None
					info.add_attribute('target_type', decl_type_node)
					for key in info_dict.keys():
						info.add_attribute(key, info_dict[key])
					newNodes.append(newNode)
					
			elif 'const' in  decl_type:
				for decl in declarators:
					name = decl['name']
					expr = decl['expression']
					newNode = Const(None)	
					newNode.leaf = name
					newNode.add_attribute('target_type', decl_type_node)
					info = Info(None)
					newNode.add_child(info)
					for key in info_dict.keys():
						info.add_attribute(key, info_dict[key])
					if expr:
						newNode.add_attribute('value', decl['result'])
					else:
						print 'confused: CONST without initialiser?!!'
						assert False
					newNodes.append(newNode)
			else:
				#assume type-instances!!
				for decl in declarators:
					name = decl['name']
					expr = decl['expression']
					
					typeinst = TypeInstance(None)				
					typeinst.leaf = name
					typeinst.add_attribute('target_type', decl_type_node)
					info = Info(None)
					typeinst.add_child(info)
					if expr:
						info.add_attribute('initialiser', decl['result'])
					for key in info_dict.keys():
						info.add_attribute(key, info_dict[key])
					newNodes.append(typeinst)

		else:
			newNodes.append(UnknownNode(None, pt))
		return newNodes, other_stuff
	
	def _declaration_specifiers(self, parentast, pt):
		"""
		Returns (decl_type, isNewType, decl_instances)
		"""
		if pt.my_children_are('simple_type_specifier'):
			#type_name = ' '.join(pt.the('simple_type_specifier').leaf)
			#return Type(parentast, None, type_name)
			type_name = ' '.join(pt.the('simple_type_specifier').leaf)
			
			typenode = getTypenode(type_name, parentast)
			if typenode == None:
				#print type_name, ' in parent: ', parentast, ' not found'
				#parentast.print_tree()
				last_ast_child = parentast
				while last_ast_child.last_child != None:
					last_ast_child = last_ast_child.last_child
				typenode = getTypenode(type_name, last_ast_child)
				if typenode == None:
					print 'second search: ', type_name, ' in parent: ', last_ast_child, ' not found'
				
					parentast.print_tree()
			assert typenode is not None
			return typenode, False, None

			return decl_type, Type(None, type_name)
		
		elif len(pt.children) == 1 and pt.children[0].type in CLASS_SPECIFIERS:
			# Create a new type right here right now!
			#new_type = self.get_type(parentast, pt.children[0])
			new_type, type_inst_list = self.create_type(parentast, pt.children[0])
			return new_type,  True, type_inst_list
		elif pt.my_children_are('enum_specifier'):
			# FIXME: We still have bad handling of enums.
			typenode = getTypenode('int', parentast)
			assert typenode is not None
			return typenode, False, None
		else:
			pt.print_tree()
			parentast.print_tree()
			raise Exception()
			return UnknownNode(pt), True, None

	def create_type(self, parentast, pt):
		"""
		Create a new type from a list of member_declarations
		"""
		
		# Member declarations are now contained in a "members" node.
		# If this assert fails, we are declarating a forward reference instead...
		assert pt.my_children_are('members')
		members_pt = pt.the('members')

		if all_children(members_pt, ('member_declaration', 'declaration')):
			# For each member decl we have a
			# declaration_specifier and a member_declarator_list.
			assert pt.type in CLASS_SPECIFIERS
			ast = Type(parentast, None)
			others_list = []
			ast.add_attribute('meta_type', pt.type)
			if pt.type == 'struct':
				members_node = Node(None, None)
				ast.add_child(members_node)
				members_node.type = 'members'
				working_node = members_node
			elif pt.type == 'union':
				info = Info(None)
				info.add_attribute('switch_type', None)
				ast.add_child(info)
				members_node = Node(None, None)
				ast.add_child(members_node)
				members_node.type = 'members'
				working_node = members_node
			elif pt.type == 'enum':
				info = Info(None)
				ast.add_child(info)
				working_node = info
				
			if pt.leaf is not None: # We are creating a named type!!
				ast.leaf = pt.leaf
			for child in members_pt.children:
				decl_specifiers = None
				add_list = []
				if child.type == 'member_declaration' \
						and child.my_children_are('declaration_specifiers', 'member_declarator_list'):
					decl_specifiers = child.the('declaration_specifiers')
					
					decl_node, isNewType, others_list = self._declaration_specifiers(ast, decl_specifiers)
										
					members_dict_decls = self._member_declarator_list(decl_node,
							child.the('member_declarator_list'))
					
					#decl_node.add_children(member_decls)
					for member_dict in members_dict_decls:
						typeinst = TypeInstance(None)
						typeinst.leaf = member_dict['name']
						typeinst.add_attribute('target_type', decl_node)
						if member_dict.has_key('expression'):
							if member_dict.has_key('value'):
								typeinst.add_attribute('initialiser',member_dict['value'])
						add_list.append(typeinst)
					
					if isNewType:
						add_list.append(decl_node)
					if others_list:
						add_list.extend(others_list)
				elif child.type == 'declaration':
					decl_nodes, decl_inst = self.declaration(ast, child)
					add_list.extend(decl_nodes)
					if decl_inst:
						add_list.extend(decl_inst)
				else:
					add_list.append(UnknownNode(ast, child))
					
				if pt.type == 'union':
					member_node = Node(None, None)
					member_node.type = 'case'
					working_node.add_child(member_node)
					member_node.add_children(add_list)
				elif pt.type == 'struct':
					working_node.add_children(add_list)
				elif pt.type == 'enum':
					print "There is only one Power in this world that knows all about the Rings and their effects.\n  \
						-> Use this Power to solve the BUG!"
					working_node.add_children(add_list)
				else:
					working_node.add_children(add_list)
					
				
			return ast, others_list
		else:
			return UnknownNode(ast, pt), None

	def _member_declarator_list(self, parentast, pt):
		"""
		Return a list of instance names.
		"""
		return self._some_declarator_list(parentast, pt)

	def _init_declarator_list(self, parentast, pt):
		return self._some_declarator_list(parentast, pt)
	
	def _some_declarator_list(self, parentast, pt):
		"""
		Init declarators are separated in source using commas.
		"""
		assert pt.type in ("init_declarator_list", "member_declarator_list")

		init_declarators = []
		for child in pt.children:
			init_declarators.append(self.init_declarator(parentast, child))
		return init_declarators
	
	def init_declarator(self, parentast, pt):
		"""
		Return a text string describing this declarator.
		"""
		decl = {}
		if pt.type == 'member_declarator_bitfield':
			decl['name'] = pt.leaf
			decl['expression'] = pt.the('expression')
			result = None
			try:
				result = evaluate(pt.the('expression'), parentast)
			except Exception:
				result = pt.the('expression').result
			decl['result'] = result
		else:
			assert pt.type in ("init_declarator", "member_declarator")

			indirection = ''
			while pt.my_children_are('declarator'):
				pt = pt.children[0]
				if pt.leaf == '*' and len(pt.children) == 1:
					indirection += '*'
				else:
					raise Exception()
			if pt.my_children_are('direct_declarator', 'expression', minkids = 1):
				decl['name'] = pt.the('direct_declarator').leaf + indirection
				expr = pt.the('expression')
				decl['expression'] = expr
				if expr:
					# Initialiser.
					result = None
					try:
						result = evaluate(expr, parentast)
					except Exception:
						result = expr.result
					decl['result'] = result
			else:
				pt.print_tree()
				raise Exception("Unknown ID type")
			
		return decl
	
	def _init_declarator_get_value(self, pt):
		pass
	
def gen(baseast, pt, filename):
	astgen = ASTGen()
	return astgen.convert(baseast, pt, filename)
