/*
 * I am converting this grammar to Python. - nfd 11/Jul/2005
*/

/*
 * PUBLIC DOMAIN PCCTS-BASED C++ GRAMMAR (cplusplus.g, stat.g, expr.g)
 *
 * Authors: Sumana Srinivasan, NeXT Inc.;            sumana_srinivasan@next.com
 *          Terence Parr, Parr Research Corporation; parrt@parr-research.com
 *          Russell Quong, Purdue University;        quong@ecn.purdue.edu
 *
 * VERSION 1.2
 *
 * SOFTWARE RIGHTS
 *
 * This file is a part of the ANTLR-based C++ grammar and is free
 * software.  We do not reserve any LEGAL rights to its use or
 * distribution, but you may NOT claim ownership or authorship of this
 * grammar or support code.  An individual or company may otherwise do
 * whatever they wish with the grammar distributed herewith including the
 * incorporation of the grammar or the output generated by ANTLR into
 * commerical software.  You may redistribute in source or binary form
 * without payment of royalties to us as long as this header remains
 * in all source distributions.
 *
 * We encourage users to develop parsers/tools using this grammar.
 * In return, we ask that credit is given to us for developing this
 * grammar.  By "credit", we mean that if you incorporate our grammar or
 * the generated code into one of your programs (commercial product,
 * research project, or otherwise) that you acknowledge this fact in the
 * documentation, research report, etc....  In addition, you should say nice
 * things about us at every opportunity.
 *
 * As long as these guidelines are kept, we expect to continue enhancing
 * this grammar.  Feel free to send us enhancements, fixes, bug reports,
 * suggestions, or general words of encouragement at parrt@parr-research.com.
 * 
 * NeXT Computer Inc.
 * 900 Chesapeake Dr.
 * Redwood City, CA 94555
 * 12/02/1994
 * 
 * Restructured for public consumption by Terence Parr late February, 1995.
 *
 * DISCLAIMER: we make no guarantees that this grammar works, makes sense,
 *             or can be used to do anything useful.
 */
/* 2001-2002
 * Version 1.0
 * This C++ grammar file has been converted from PCCTS to run under 
 *  ANTLR to generate lexer and parser in C++ code by
 *  Jianguo Zuo and David Wigg at
 *  The Centre for Systems and Software Engineering
 *  London South Bank University
 *  London, UK.
 *
 */
/* 2003
 * Version 2.0 was published by David Wigg in September 2003
 */
/* 2004
 * Version 3.0 July 2004
 * This is version 3.0 of the C++ grammar definition for ANTLR to 
 *  generate lexer and parser in C++ code updated by
 *  David Wigg at
 *  The Centre for Systems and Software Engineering
 *  London South Bank University
 *  London, UK.
 *
 * wiggjd@bcs.ac.uk
 * blackse@lsbu.ac.uk
 *
 * See MyReadMe.txt for further information
 *
 * This file is best viewed in courier font with tabs set to 4 spaces
 */

header 
    {
    // The statements in this block appear in both CPPLexer.py and CPPParser.py
    from CPPDictionary import CPPDictionary
    from LineObject import LineObject
	import CPPSymbol
    from var_types import * # "Do not use. Should be deleted in the next version"
	from enum_types import *
    }

header "CPPLexer.__init__"
{self.line_directive_handler = kwargs.get("line_directive_handler")}

header "CPPParser.__init__"
{//antlrTrace(False);    // This is a dynamic trace facility for use with -traceParser etc.
/* It requires modification in LLkParser.cpp and LLkParser.hpp
otherwise it should be commented out (see MyReadMe.txt)
true shows antlr trace (can be set and reset during parsing)
false stops showing antlr trace 
Provided the parser is always generated with -traceParser this
facility allows trace output to be turned on or off by changing
the setting here from false to true or vice versa and then
recompiling and linking CPPParser only thus avoiding the need
to use antlr.Tool to re-generate the lexer and parser again. 
*/
				
// Creates a dictionary to hold symbols with 4001 buckets, 200 scopes and 800,000 characters
// These can be changed to suit the size of program(s) being parsed
// nfd: The Python version uses Python's native dict, which has "infinite" capacity, so
// the above params aren't passed in.
self.symbols = CPPDictionary()

// Set template parameter and external scopes
// Set template parameter scope to 0
self.templateParameterScope = self.symbols.getCurrentScopeIndex()
self.symbols.saveScope()    // Advance currentScope from 0 to 1
self.externalScope = self.symbols.getCurrentScopeIndex()    // Set external scope to 1

// Declare predefined scope "std" in external scope
a = CPPSymbol.CPPSymbol("std", CPPSymbol.otTypedef)
self.symbols.define("std", a)

// Global flags to allow for nested declarations
self._td = False        // For typedef
self._fd = False        // For friend
self._ts = None 		// For TypeSpecifier
self._ds = dsInvalid    // For DeclSpecifier

// 0 = Function definition not being parsed
// 1 = Parsing function name
// 2 = Parsing function parameter list
// 3 = Parsing function block
self.functionDefinition = 0
self.qualifierPrefix = "" // [0] = '\0';
self.enclosingClass = "";
self.assign_stmt_RHS_found = 0;
self.in_parameter_list = False;
self.K_and_R = False;    // used to distinguish old K & R parameter definitions
self.in_return = False;
self.is_address = False;
self.is_pointer = False;

// "protected:"
}

options
	{
	language = "Python";
	}

{

//	The statements in this block appear only in CPPParser.py and not in CPPLexer.py

// Used to control selected (level) tracing (see support.cpp)
// 1 Shows which external and member statements selected
// 2 Shows above plus all declarations/definitions
// 3 reserved for future use
// 4 and above available for user
statementTrace = 0

def trace1(s):
    if statementTrace >= 1:
        print s

def checknode(node):
    assert node is not None
    return node

CPPParser_MaxQualifiedItemSize = 500


// Limit lookahead for qualifiedItemIs()
MaxTemplateTokenScan = 200 

}	// End of CPPParser.cpp block


class CPPParser extends Parser;

options
	{
	k = 2;
	exportVocab = STDC;
	buildAST = false;
	codeGenMakeSwitchThreshold = 2;
	codeGenBitsetTestThreshold = 3;
	}

{ 
    // "protected:"
	// Semantic interface removed - nfd jul 05
}


translation_unit returns [node]
   :  {self.enterExternalScope()} {accum = []}
      (ed = external_declaration {accum.append(ed)})+  EOF {node = self.autonode(accum)}
      {self.exitExternalScope()}
   ;

external_declaration returns [node]
	{self.K_and_R = False}
	:  
	(
	// Template explicit specialisation (DW 14/04/03)
	// Ref: http://msdn2.microsoft.com/library/c401y1kb(en-us,vs.80).aspx (nfd)
		("template" LESSTHAN GREATERTHAN)=>
		{trace1("%d external_declaration_0 template explicit-specialisation\n" %(self.LT(1).getLine()))}
		"template" LESSTHAN GREATERTHAN d = declaration
		{node = self.node("template_specialisation", [d])}
	|
	// Class definition (templates too)
	// This is separated out otherwise the next alternative
	// would look for "class A { ... } f() {...}" which is
	// an unacceptable level of backtracking.

	// JEL Note:  Rule body does not need typedef, because
	// that is internal to "declaration", and it is invalid
	// to say "typedef template..."
	 	// Class definition
		(("typedef")? class_head)=>
		{trace1("%d external_declaration_1a Class definition\n" % (self.LT(1).getLine()))}
		d = declaration
		{node = d}
	|	
		// Class template definition
		(template_head class_head)=>
		{trace1("%d external_declaration_1b Class template definition\n" % (self.LT(1).getLine()))}
		th = template_head d = declaration
		{node = self.node("template", [th, d])}
   |  
		// Enum definition (don't want to backtrack over this in other alts)
		("enum" (ID)? LCURLY)=>
		{trace1("%d external_declaration_2 Enum definition\n" % (self.LT(1).getLine()))}
		es = enum_specifier (idl = init_declarator_list)? SEMICOLON! {self.end_of_stmt()}
		{node = self.unfinishednode("enum")}
   |  
		// Destructor DEFINITION (templated or non-templated)
		((template_head)? dtor_head[1] LCURLY)=>
		{trace1("%d external_declaration_3 Destructor definition\n" % (self.LT(1).getLine()))}
		(th = template_head)? dh = dtor_head[1] db = dtor_body
		{node = self.unfinishednode("destructor")}
	|  
		// Constructor DEFINITION (non-templated)
		// JEL 4/3/96 Added predicate that works, once the
		// restriction is added that ctor cannot be virtual
		// and ctor_declarator uses a more restrictive id
		(	(options {warnWhenFollowAmbig = false;}:
			 cds = ctor_decl_spec)?
			{self.qualifiedItemIsOneOf(qiCtor)}?
		)=>
		{trace1("%d external_declaration_4 Constructor definition\n" % (self.LT(1).getLine()))}
		cd = ctor_definition
		{node = self.unfinishednode("non-templated constructor")}
   |  
		// User-defined type cast
		(("inline")? scope_override  conversion_function_decl_or_def)=>
		{trace1("%d external_declaration_5 Operator function\n" % (self.LT(1).getLine()))}
		("inline")? s = scope_override cfdd = conversion_function_decl_or_def 
		{node = self.unfinishednode("typecast")}
   |   
		// Function declaration
		(declaration_specifiers function_declarator[0] SEMICOLON!)=> 
		{trace1("%d external_declaration_6 Function declaration\n" % (self.LT(1).getLine()))}
		d = declaration
		{node = checknode(d)}
	|
		// Function definition
		(declaration_specifiers	function_declarator[1] LCURLY)=> 
		{trace1("%d external_declaration_7 Function definition\n" % (self.LT(1).getLine()))}
		fd = function_definition {node = fd}
	|
		// K & R Function definition
		(declaration_specifiers	function_declarator[1] declaration)=>
{
self.K_and_R = True
trace1("%d external_declaration_8 K & R function definition\n" % (self.LT(1).getLine()))
}
		fd = function_definition {node = fd}
	|  
		// templated forward class decl, init/decl of static member in template
		(template_head declaration_specifiers (init_declarator_list)? SEMICOLON! {self.end_of_stmt()})=>
{
self.beginTemplateDeclaration()
trace1("%d external_declaration_9 Class template declaration\n" % (self.LT(1).getLine()))
}
		th = template_head ds = declaration_specifiers (idl = init_declarator_list)? SEMICOLON! {self.end_of_stmt()}
		{self.endTemplateDeclaration()}
		{node = self.unfinishednode("templated_forward_class_decl")}
	|  
		// Templated FUNCTIONS and CONSTRUCTORS matched here.
		{self.beginTemplateDefinition()}
		th = template_head
		{node = self.node("templated_function")}
		(  
			// Templated CONSTRUCTOR definition
            // JEL 4/3/96 Added predicate that works once the
            // restriction is added that ctor cannot be virtual
			(	ctor_decl_spec 
				{self.qualifiedItemIsOneOf(qiCtor)}?
			)=>
			{trace1("%d external_declaration_10a Template constructor definition\n" % (self.LT(1).getLine()))}
			cd = ctor_definition {node.add_child(cd)}
		|
			// Templated function declaration
			(declaration_specifiers function_declarator[0] SEMICOLON!)=> 
			{trace1("%d external_declaration_10b Function template declaration\n" % (self.LT(1).getLine()))}
			d = declaration
			{node.add_child(d)}
		|  
			// Templated function definition
			(declaration_specifiers function_declarator[1] LCURLY)=> 
			{trace1("%d external_declaration_10c Function template definition\n" % (self.LT(1).getLine()))}
			fd = function_definition {node.add_child(fd)}
		)
		{self.endTemplateDefinition()}
	|  
		{trace1("%d external_declaration_11 Namespace declaration\n" % (self.LT(1).getLine()))}
		dn = decl_namespace
		{node = self.unfinishednode("namespace_decl")}
	|	
		// everything else (except templates)
		{trace1("%d external_declaration_12 Declaration\n" % (self.LT(1).getLine()))}
		d = declaration
		{node = d}
	|	
		{trace1("%d external_declaration_13 Semicolon\n" % (self.LT(1).getLine()))}
		SEMICOLON! {self.end_of_stmt()}
	)
	;	// end of external_declaration

decl_namespace returns [node]
	:	
		"namespace" 
		(
			{node = self.node("namespace")}
			(ns:ID {node.set_leaf(ns.getText())}
{
self._td = True
self.declaratorID(ns.getText(), qiType)
})?
			// The following statement can be invoked to trigger selective antlr trace
			// Also see below
			//{if (strcmp((ns->getText()).data(),"xyz")==0) antlrTrace(True);}	// Used for diagnostic trigger
			LCURLY 
			{self.enterNewLocalScope()}
			(ed = external_declaration {node.add_child(ed)} )*
			{self.exitLocalScope()}
			RCURLY
			// The following should be implemented to match the optional statement above
			//{antlrTrace(False);}
		|
			{node = self.node("namespace_assignment")}
			ns2:ID 
{
self._td = True
self.declaratorID(ns2.getText(), qiType)
}
			ASSIGNEQUAL qid = qualified_id SEMICOLON! {self.end_of_stmt()} 
			{node.set_leaf([ns2.getText(), qid])}
		)
	;

member_declaration returns [node]
	:
	(
		// Class definition
		// This is separated out otherwise the next alternative
		// would look for "class A { ... } f() {...}" which is
		// an unacceptable level of backtracking.
		( ("typedef")? class_head) => 
		{trace1("%d member_declaration_1 Class definition\n" % (self.LT(1).getLine()))}
		d = declaration
		{node = d}
	|  
		// Enum definition (don't want to backtrack over this in other alts)
		("enum" (ID)? LCURLY)=>
		{trace1("%d member_declaration_2 Enum definition\n" % (self.LT(1).getLine()))}
		{mdl = None}
		es = enum_specifier (mdl = member_declarator_list)? SEMICOLON!	{self.end_of_stmt()}
		{node = self.autonode([es, mdl])}
	|
		// Constructor declarator
		(	ctor_decl_spec
			{self.qualifiedItemIsOneOf(qiCtor)}?
			ctor_declarator[0] SEMICOLON!
		)=>
		{trace1("%d member_declaration_3 Constructor declarator\n" % (self.LT(1).getLine()))}
		cds = ctor_decl_spec 
		cd = ctor_declarator[0] 	SEMICOLON! {self.end_of_stmt()} // Constructor declarator
		{node = self.autonode([cds, cd])}
	|  
		// JEL Predicate to distinguish ctor from function
		// This works now that ctor cannot have VIRTUAL
		// It unfortunately matches A::A where A is not enclosing
		// class -- this will have to be checked semantically
		(	ctor_decl_spec
			{self.qualifiedItemIsOneOf(qiCtor)}?
			ctor_declarator[1]
			(COLON        // DEFINITION :ctor_initializer
			|LCURLY       // DEFINITION (compound Statement) ?
			)
		)=>
		{trace1("%d member_declaration_4 Constructor definition\n" % (self.LT(1).getLine()))}
		cd = ctor_definition 
		{node = self.autonode([cd])}
   |  
		// No template_head allowed for dtor member
		// Backtrack if not a dtor (no TILDE)
		(dtor_head[0] SEMICOLON!)=>
		{trace1("%d member_declaration_5a Destructor declaration\n" % (self.LT(1).getLine()))}
		dh = dtor_head[0] SEMICOLON! {self.end_of_stmt()}	// Declaration
		{node = self.autonode([dh])}
	|
		// No template_head allowed for dtor member
		// Backtrack if not a dtor (no TILDE)
		(dtor_head[1] LCURLY)=>
		{trace1("%d member_declaration_5b Destructor definition\n" % (self.LT(1).getLine()))}
		dh = dtor_head[1] db = dtor_body	// Definition
		{node = self.autonode([dh, db])}
	|
		// Function declaration
		(declaration_specifiers	function_declarator[0] SEMICOLON!)=>
		{trace1("%d member_declaration_6 Function declaration\n" % (self.LT(1).getLine()))}
		d = declaration
		{node = d}
	|  
		// Function definition
		(declaration_specifiers function_declarator[1] LCURLY)=>
{
self.beginFieldDeclaration()
trace1("%d member_declaration_7 Function definition\n" % (self.LT(1).getLine()))
}
		fd = function_definition
		{node = fd}
	|  
		// User-defined type cast
		(("inline")? conversion_function_decl_or_def)=>
		{trace1("%d member_declaration_8 Operator function\n" % (self.LT(1).getLine()))}
		("inline")? cfdd = conversion_function_decl_or_def
		{node = self.unfinishednode("udtc-439")}
	|  
		// Hack to handle decls like "superclass::member",
		// to redefine access to private base class public members
		(qualified_id SEMICOLON!)=>
		{trace1("%d member_declaration_9 Qualified ID\n" % (self.LT(1).getLine()))}
		q = qualified_id SEMICOLON! {self.end_of_stmt()}
		{node = self.unfinishednode("declhack-446")}
	|  
		// Member with a type or just a type def
		// A::T a(), ::T a, ::B a, void a, E a (where E is the enclosing class)
		(declaration_specifiers)=>
{
self.beginFieldDeclaration()
trace1("%d member_declaration_10 Declaration(s)\n" % (self.LT(1).getLine()))
}
		{mdl = []}
		ds = declaration_specifiers (md = member_declarator_list {mdl = [md]})? SEMICOLON! {self.end_of_stmt()}
		{node = self.autonode([ds] + mdl)}
	|  
		// Member without a type (I guess it can only be a function declaration or definition)
		(function_declarator[0] SEMICOLON!)=>
{
self.beginFieldDeclaration()
trace_err("%d warning Function declaration found without typename\n" % (self.LT(1).getLine()))
trace1("%d member_declaration_11a Function declaration\n" % (self.LT(1).getLine()))
}
		fd = function_declarator[0] SEMICOLON! {self.end_of_stmt()}
		{node = checknode(fd)}
	|
		// Member without a type (I guess it can only be a function definition)
{
trace_err("%d warning Function definition found without typename\n" % (self.LT(1).getLine()))
trace1("%d member_declaration_11b Function definition\n" % (self.LT(1).getLine()))
}
		fd = function_declarator[1] cs = compound_statement {self.endFunctionDefinition()}
		{node = self.autonode([fd, cs])}
	|  
		// templated forward class decl, init/decl of static member in template
		// DW 27/06/03 Copied here from external_declaration since templates can now be nested
		(template_head ds = declaration_specifiers (init_declarator_list)? SEMICOLON!)=>
{
self.beginTemplateDeclaration()
trace1("%d member_declaration_12 Class template declaration\n" % (self.LT(1).getLine()))
}
		 th = template_head ds = declaration_specifiers {node = self.autonode([th, ds])} (idl = init_declarator_list {node.add_child(idl)} )? SEMICOLON! {self.end_of_stmt()}
		{self.endTemplateDeclaration()}
	|  
		// Templated FUNCTIONS and CONSTRUCTORS matched here.
		// DW 27/06/03 Copied here from external_declaration since templates can now be nested
		{self.beginTemplateDefinition()}
		th = template_head {node = self.node("templated_function", [th])}
		(
			// Templated CONSTRUCTOR definition
			// JEL 4/3/96 Added predicate that works once the
			// restriction is added that ctor cannot be virtual
			(ctor_decl_spec
			 {self.qualifiedItemIsOneOf(qiCtor)}?
			)=>
			{trace1("%d member_declaration_13a Template constructor definition\n" % (self.LT(1).getLine()))}
			cd = ctor_definition {node.add_child(cd)}
		|
			// Templated function declaration
			(declaration_specifiers function_declarator[0] SEMICOLON!)=>
			{trace1("%d member_declaration_13b Function template declaration\n" % (self.LT(1).getLine()))}
			d = declaration {node.add_child(d)}
		|  
			// Templated function definition
			// Function definition DW 2/6/97
			(declaration_specifiers function_declarator[1] LCURLY)=> 
			{trace1("%d member_declaration_13c Function template definition\n" % (self.LT(1).getLine()))}
			fd = function_definition {node.add_child(fd)}
		|
			{trace1("%d member_declaration_13d Templated operator function\n" % (self.LT(1).getLine()))}
			cfdd = conversion_function_decl_or_def {node.add_child(cfdd)}
		)
		{self.endTemplateDefinition()}
	|  
		{trace1("%d member_declaration_14 Access specifier\n" % (self.LT(1).getLine()))}
		as = access_specifier COLON
		{node = self.node(as)}
	|  
		{trace1("%d member_declaration_15 Semicolon\n" % (self.LT(1).getLine()))}
		SEMICOLON! {self.end_of_stmt()}
		{node = self.unfinishednode("member-decl-524")}
	)
	;	// end member_declaration

function_definition returns [node]
	:	// don't want next action as an init-action due to (...)=> caller
	{self.beginFunctionDefinition()}
	(	// Next line is equivalent to guarded predicate in PCCTS
		// (SCOPE | ID)? => <<self.qualifiedItemIsOneOf(qiType|qiCtor)>>?
		{( not (self.LA(1)==SCOPE or self.LA(1)==ID) or self.qualifiedItemIsOneOf(qiType|qiCtor) )}?
		ds = declaration_specifiers fd = function_declarator[1]
		{decl_node = self.node("declaration_list")}
		(	options{warnWhenFollowAmbig = false;}:
			(d = declaration {decl_node.add_child(d)})*	// Possible for K & R definition
			{self.in_parameter_list = False}
		)?
		cs = compound_statement
		{node = self.autonode([ds, fd, decl_node, cs])}
	|	// Next line is equivalent to guarded predicate in PCCTS
		// (SCOPE | ID)? => <<self.qualifiedItemIsOneOf(qiPtrMember)>>?
		//{( !(self.LA(1)==SCOPE||self.LA(1)==ID) || (self.qualifiedItemIsOneOf(qiPtrMember)) )}?
		fd = function_declarator[1]
		{decl_node = self.node("declaration_list")}
		(	options{warnWhenFollowAmbig = false;}:
			(d = declaration)*	 {decl_node.add_child(d)}// Possible for K & R definition
			{self.in_parameter_list = False}
		)?
		cs = compound_statement
		{node = self.autonode([fd, decl_node, cs])}
	)
	{self.endFunctionDefinition()}
	;

declaration returns [node]
	:	
		("extern" StringLiteral)=>
		linkage_specification
		{node = self.unfinishednode()}
	|	
		{self.beginDeclaration()}
		// LL 31/1/97: added (COMMA) ? below. This allows variables to typedef'ed more than once. DW 18/08/03 ?
		ds = declaration_specifiers {node = self.autonode([ds])} ((COMMA)? (a = attribute)? idl = init_declarator_list {node.add_child(idl)} )? SEMICOLON! {self.end_of_stmt()}
		{self.endDeclaration()}
	|	
		ud = using_declaration	// DW 19/04/04
		{node = ud}
	;

linkage_specification
	:	"extern"
		StringLiteral
		(LCURLY (ed = external_declaration)* RCURLY
		|d = declaration
		)
	;

declaration_specifiers returns [node]
	{
    self._td = False
    self._fd = False
    self._ts = None
    self._ds = dsInvalid

    td = False
    fd = False
    ts = None
    ds = dsInvalid
    tq = None
    sc = None
	}
	:
	{specnames = []}
	(	(options {warnWhenFollowAmbig = false;}
		:	sc = storage_class_specifier {specnames.append(sc)}
		|	tq = type_qualifier {specnames.append(tq)}
		|	("inline"^|"_inline"^|"__inline"^)	{ds = dsINLINE} {specnames.append("inline")}
		|	"virtual"^						{ds = dsVIRTUAL} {specnames.append("virtual")}
		|	"explicit"^						{ds = dsEXPLICIT} {specnames.append("explicit")}
		|	"typedef"^	{td=True} {specnames.append("typedef")}
		|	"friend"^	{fd=True} {specnames.append("friend")}
		|	("_stdcall"^|"__stdcall"^) {specnames.append("stdcall")}
		)*
		ts = type_specifier[ds]
		{node = self.autonode([ts], specnames); node.set_result(ts.result)}
	|	
		"typename"	{td=True;}
		dd = direct_declarator 
		{node = self.autonode([dd], ["typename"])}
	)
	{self.declarationSpecifier(td,fd,sc,tq,ts,ds)}
	;

attribute returns[a]  /* nfd */
	: "__attribute__" LPAREN LPAREN attribute_decl_list RPAREN RPAREN
		{a = None}
	;

attribute_decl_list
	: "__mode__" LPAREN ID RPAREN
	| "const"
	;

storage_class_specifier returns [sc]
	:	"auto"		{sc = "auto";}
	|	"register"	{sc = "register";}
	|	"static"	{sc = "static";}
	|	"extern"	{sc = "extern";}
	|	"mutable"	{sc = "mutable";}
	;

type_qualifier returns [tq] // aka cv_qualifier
	:  ("const"|"const_cast")	{tq = "const";} 
	|  "volatile"				{tq = "volatile";}
	;

type_specifier[ds] returns [ts]
	:	ts = simple_type_specifier
	|	ts = class_specifier[ds]
	|	ts = enum_specifier
	;

simple_type_specifier returns [node]
	{ts = []}
	:	(	{self.qualifiedItemIsOneOf(qiType|qiCtor)}? 
			 s = qualified_type {ts.append(s)}
		|	
			(	"char"^		{ts.append("char")}
			|	"wchar_t"^	{ts.append("wchar_t")}
			|	"bool"^		{ts.append("bool")}
			|	"short"^{ts.append("short")}
			|	"int"^	{ts.append("int")}
			|	("_int64"^|"__int64"^)	{ts.append("long")}
			|	"__w64"^		{ts.append("long")}
			|	"long"^		{ts.append("long")}
			|	"signed"^	{ts.append("signed")}
			|	"unsigned"^	{ts.append("unsigned")}
			|	"float"^	{ts.append("float")}
			|	"double"^	{ts.append("double")}
			|	"void"^	{ts.append("void")}
			|	("_declspec"^|"__declspec"^) LPAREN ID RPAREN 
			)+
		|
		// Fix towards allowing us to parse *.cpp files directly
		(qualified_type qualified_id)=> s = qualified_type {ts.append("typeid")}
		{print("simple_type_specifier third option entered - %s" % (s))}
		{ts.append("STS unfinished 2")}
		)
		{node = self.autonode(None, ts); node.set_result(' '.join(ts))}
	;

qualified_type returns [q]
	: 
		// JEL 3/29/96 removed this predicate and moved it upwards to
		// simple_type_specifier.  This was done to allow parsing of ~ID to 
		// be a unary_expression, which was never reached with this 
		// predicate on
		// {self.qualifiedItemIsOneOf(qiType|qiCtor)}?

		s = scope_override 
		id:ID^ 
		(options {warnWhenFollowAmbig = false;}:
		 LESSTHAN tal = template_argument_list GREATERTHAN
		)?
{
//printf("qualified_type entered\n");
q = s + id.getText()
}
	;

class_specifier[ds] returns [node]
	:	("class"^	{ts = "class"}	
		|"struct"^	{ts = "struct"}
		|"union"^	{ts = "union"}
		)
		(	id = qualified_id
			{bases = None}
			(options{generateAmbigWarnings = false;}:
{saveClass = self.enclosingClass
self.enclosingClass = id
}
				{bases = []} (bases = base_clause)?
				LCURLY	 
				{self.beginClassDefinition(ts, id)}	// This stores class name in dictionary
				{members = self.node("members")}
				(md = member_declaration {members.add_child(md)})*
				{self.endClassDefinition()}
				RCURLY
				{node = self.node(ts, bases + [members], id)}
				{self.enclosingClass = saveClass}
			|
				{node = self.node(ts, [], id)}
				{self.classForwardDeclaration(ts, ds, id)}
			)
		|
			LCURLY	 
{saveClass = self.enclosingClass
self.enclosingClass = "__anonymous"}
			{self.beginClassDefinition(ts, "anonymous")}
			{members = self.node("members")}
			(md = member_declaration {members.add_child(md)})*
			{self.endClassDefinition()}
			{node = self.node(ts, [members], None)}
			RCURLY
			{self.enclosingClass = saveClass}
		) 
	;

enum_specifier returns[node]
	:	"enum"
		(	LCURLY enumerator_list RCURLY
		|	id:ID     // DW 22/04/03 Suggest qualified_id here to satisfy elaborated_type_specifier
			{self.beginEnumDefinition(id.getText())}
			(LCURLY enumerator_list RCURLY)?
			{self.endEnumDefinition()}
		)
		{node = self.autonode()}
	;

enumerator_list
	:	enumerator (COMMA enumerator)*
	;

enumerator
	:	id:ID (ASSIGNEQUAL cx = constant_expression)?
		{self.enumElement(id.getText())}
	;

/* This matches a generic qualified identifier ::T::B::foo
 * (including OPERATOR).
 * It might be a good idea to put T::~dtor in here
 * as well, but id_expression in expr.g puts it in manually.
 * Maybe not, 'cause many people use this assuming only A::B.
 * How about a 'qualified_complex_id'?
 */
qualified_id returns [q]
	:
	so =  scope_override
	{qitem = so}
	(  
	id:ID	(options{warnWhenFollowAmbig = false;}:
			 LESSTHAN tal = template_argument_list GREATERTHAN)?
	{qitem += id.getText()}
	|  
	OPERATOR o = optor
	{qitem += "operator"; qitem += o}
	|
	"this"  // DW 21/07/03 fix to pass test8.i
	|
	("true"|"false")	// DW 21/07/03 fix to pass test8.i
	)
	{q = qitem}
	;

typeID
	:	{self.isTypeName(self.LT(1).getText())}?
		ID
	;

init_declarator_list returns [node]
	:	id = init_declarator {idl = [id]} (COMMA id = init_declarator {idl.append(id)})*
		(a = attribute)?
	{node = self.autonode(idl)}
	;

init_declarator returns [node]
	:	d = declarator {node = self.autonode([d])}
		(	
			ASSIGNEQUAL 
			i = initializer
			{node.add_child(i); d.set_result(i.result)}
		|	
			LPAREN el = expression_list RPAREN
			{node.add_child(el); d.set_result(el.result)}
		)?
	;

initializer returns[node]
   :  rx = remainder_expression {node = checknode(rx)}// DW 18/4/01 assignment_expression
   |  LCURLY i1 = initializer {node = self.autonode([i1])} (COMMA i2 = initializer {node.add_child(i2)})* RCURLY
   |  d1 = gcc_designator i3 = initializer {node = self.autonode([d1, i3])} /* nfd jul 2005 */
   |  d2 = c99_designator i4 = initializer {node = self.autonode([d2, i4])}/* nfd jul 2005 */
   ;
 
/* Designated initializers, GCC extension, http://tigcc.ticalc.org/doc/gnuexts.html#SEC82 
 * These are of the form var = {structfield : val}
 * See below for c99 designators.
*/
gcc_designator returns[node]
	: id:ID COLON {node = self.node("designator", None, id.getText())}
	;

/* C99 designated initializers, http://david.tribble.com/text/cdiffs.htm#C90-vs-CPP98
 * Of the form var = { .structfield = val}
*/
c99_designator returns[node]
	: DOT id:ID EQUALS {node = self.node("designator", None, id.getText())}
	;

class_head returns [node]
	:	// Used only by predicates	
	{node = self.autonode(); node_leaves = []}
	("struct" {node_leaves.append("struct")}
	|"union" {node_leaves.append("union")}
	|"class" {node_leaves.append("class")}
	)
    (id:ID	{node_leaves.append(id.getText())}
		(LESSTHAN tal= template_argument_list {node.add_child(tal)} GREATERTHAN)?
		(bc = base_clause {node.add_child(bc)})? 
	)? LCURLY
	{node.set_leaf(node_leaves)}
	;

base_clause returns [node]
	:	COLON bs = base_specifier {bsl = bs} (COMMA bs = base_specifier {bsl.append(bs)})*
	{node = self.autonode(None, bsl)}
	;

base_specifier returns [bsl]
	:	// DW 13/08/03 Should check qualified_type for class-name?
	{bsl = []}
	(	"virtual" {bsl.append("virtual")} (as = access_specifier {bsl.append(as)})? qt = qualified_type {bsl.append(qt)}
	|	as = access_specifier {bsl.append(as)} ("virtual" {bsl.append("virtual")})? qt = qualified_type {bsl.append(qt)}
	|	qt = qualified_type {bsl.append(qt)}
	)
	;

access_specifier returns[as]
	:	"public" {as = "public"}
	|	"protected" {as = "protected"}
	|	"private" {as = "private"}
	;

member_declarator_list returns[node]
	:	md = member_declarator {node = self.autonode([md])}
		(COMMA md = member_declarator {node.add_child(md)} )*
	;

member_declarator returns[node]
	:	
		{node = self.node("member_declarator_bitfield")}
		((ID)? COLON constant_expression)=>(id:ID {node.set_leaf(id.getText())})? COLON c = constant_expression {node.add_child(c)} (ASSIGNEQUAL OCTALINT {node.add_attribute("purevirtual")})?
	|  
		d = declarator {node = self.autonode([d])} (ASSIGNEQUAL OCTALINT {node.set_leaf(0)})?
	;

conversion_function_decl_or_def returns[node]
	:	OPERATOR ds = declaration_specifiers (STAR | AMPERSAND)?	// DW 01/08/03 Use type_specifier here? see syntax
		(LESSTHAN tpl = template_parameter_list GREATERTHAN)?
		LPAREN (pl = parameter_list)? RPAREN	
		(tq = type_qualifier)?
		(es = exception_specification)?
		(	cs = compound_statement
		|	SEMICOLON! {self.end_of_stmt()}
		)
		{node = self.unfinishednode()}
	;

// JEL note:  does not use (const|volatile)* to avoid lookahead problems
cv_qualifier_seq returns[cvs]
	:
	{cvs = ""} (tq = type_qualifier {cvs += tq})*
	;

declarator returns[node]
	:
		//{( !(LA(1)==SCOPE||LA(1)==ID) || self.qualifiedItemIsOneOf(qiPtrMember) )}?
		(ptr_operator)=> p = ptr_operator	// AMPERSAND or STAR
		d = declarator
		{node = self.autonode([d], p)}
	|	
		d = direct_declarator {node = d}
	;

direct_declarator returns[node]
	:
		(qualified_id LPAREN (RPAREN|declaration_specifiers) )=>	// Must be function declaration
		id = qualified_id {node = self.autonode(None, id)}
		{self.declaratorID(id, qiFun)}
		LPAREN {self.declaratorParameterList(0)}
		(pl = parameter_list {node.add_child(pl)} )?
		RPAREN {self.declaratorEndParameterList(0)}
		{tql = []}(tq = type_qualifier {tql.append(tq);node.add_child(tq)} )*
		(es = exception_specification {node.add_child(es)} )?
	|	(qualified_id LPAREN qualified_id)=>	// Must be class instantiation
		id = qualified_id
		{self.declaratorID(id,qiVar)}
		LPAREN
		el = expression_list
		RPAREN
		{node = self.autonode([el], id)}
	|
		(qualified_id LSQUARE)=>	// Must be array declaration
		id = qualified_id
{if self._td:
    self.declaratorID(id, qiType)
else:
    self.declaratorID(id, qiVar)
self.is_address = False
self.is_pointer = False;
}
		(options {warnWhenFollowAmbig = false;}:
		 LSQUARE (ce = constant_expression)? RSQUARE)+
		{self.declaratorArray()}
		{node = self.autonode([ce], id)}
	|
		id = qualified_id
{if self._td:
    self.declaratorID(id,qiType)
else:
    self.declaratorID(id,qiVar)
self.is_address = False
self.is_pointer = False;
}
		{node = self.autonode(None, id)}
	|	
		// DW 24/05/04 This block probably never entered as dtor selected out earlier
		//	Note In fact no dictionary entries for ctor or dtor	
		TILDE dtor:ID {declaratorID(dtor.getText(),qiDtor)}	// Note "class" not recorded in CPPSymbol
		{print "%d warning direct_declarator5 entered unexpectedly with %s" % (self.LT(1).getLine(),dtor.getText())}
		LPAREN {self.declaratorParameterList(0)}
		(pl = parameter_list)?
		RPAREN {self.declaratorEndParameterList(0)}
		{node = self.unfinishednode()}
	|	
		LPAREN d = declarator RPAREN ds = declarator_suffixes
		{node = self.autonode([d, ds])}
	;

declarator_suffixes returns[node]
	:
	(
		(options {warnWhenFollowAmbig = false;}:
		 LSQUARE (cx = constant_expression)? RSQUARE)+
		{self.declaratorArray()}
	|	{(not ((self.LA(1)==LPAREN) and (self.LA(2)==ID)) or (self.qualifiedItemIsOneOf(qiType|qiCtor,1)))}?
		LPAREN {self.declaratorParameterList(0)}
		(pl = parameter_list)?
		RPAREN {self.declaratorEndParameterList(0)}
		(tq = type_qualifier)*
		(es = exception_specification)?
//	|	// DW 28/06/04 deleted Assume either following bracketed declaration
//		// empty
	)
	{node = self.unfinishednode()}
	;

/* I think something is weird with the context-guards for predicates;
 * as a result I manually hoist the appropriate pred from ptr_to_member
 *
 * TER: warning: seems that "ID::" will always bypass and go to 2nd alt :(
 */
function_declarator [definition] returns [node]
	:	
		//{( !(LA(1)==SCOPE||LA(1)==ID) || self.qualifiedItemIsOneOf(qiPtrMember) )}?
		(ptr_operator)=> po = ptr_operator fd = function_declarator[definition]
		{node = self.autonode([fd], po)}
	|	
		fdd = function_direct_declarator[definition]
		{node = self.autonode(None, fdd)}
	;

function_direct_declarator [definition]  returns [q]
	:
		/* predicate indicate that plain ID is ok here; this counteracts any
		 * other predicate that gets hoisted (along with this one) that
		 * indicates that an ID is a type or whatever.  E.g.,
		 * another rule testing isTypeName() alone, implies that the
		 * the ID *MUST* be a type name.  Combining isTypeName() and
		 * this predicate in an OR situation like this one:
		 * ( declaration_specifiers ... | function_declarator ... )
		 * would imply that ID can be a type name OR a plain ID.
		 */
		(	// fix prompted by (isdigit)() in xlocnum
			LPAREN
			q = qualified_id
			{self.declaratorID(q,qiFun)}
			RPAREN
		|
			q = qualified_id
			{self.declaratorID(q,qiFun)}
		)

{
if definition:
    self.myCode_function_direct_declarator(q)
}

		LPAREN 
{
self.functionParameterList()
if not self.K_and_R:
    self.in_parameter_list = True
}
		(pl = parameter_list)? 
		{
if not self.K_and_R:
    self.in_parameter_list = False
else:
    self.in_parameter_list = True
		}
		RPAREN
		(options{warnWhenFollowAmbig = false;}:
		 tq = type_qualifier)*
		(ASSIGNEQUAL OCTALINT)?	// The value of the octal must be 0
		{self.functionEndParameterList(definition)}
		(es = exception_specification)?
	;

ctor_definition returns [node]
	:
	ch = ctor_head
	cb = ctor_body
	{self.endConstructorDefinition()}
	{node = self.autonode([ch, cb])}
	;

ctor_head returns[node]
	:
	cds = ctor_decl_spec
	cd = ctor_declarator[1]
	{node = self.autonode([cds, cd])}
	;

ctor_decl_spec returns[node]
	:
	{node = self.autonode(); speclist = []}
	(("inline"|"_inline"|"__inline") {speclist.append("inline")} |"explicit" {speclist.append("explicit")})*
	{node.set_leaf(speclist)}
	;

ctor_declarator[definition] returns[node]
	: 
	// JEL 4/3/96 qualified_id too broad DW 10/06/03 ?
	q = qualified_ctor_id
	{self.declaratorParameterList(definition)}
	LPAREN (pl = parameter_list)? RPAREN
	{self.declaratorEndParameterList(definition)}
	(es = exception_specification)?
	{node = self.unfinishednode()}
	;

// This matches a generic qualified identifier ::T::B::foo
// that is satisfactory for a ctor (no operator, no trailing <>)
qualified_ctor_id returns [q]
	{qitem = ""}
	: 
	so = scope_override
	{qitem = so}
	id:ID	// DW 24/05/04 Note. Neither Ctor or Dtor recorded in dictionary
	{qitem += id.getText(); q = qitem}
	;

ctor_body returns[node]
	:
	{node = self.autonode()}
	(ci = ctor_initializer {node.add_child(ci)} )?
	cs = compound_statement {node.add_child(ci)}
	;

ctor_initializer returns[node]
	:
	COLON superclass_init (COMMA superclass_init)*
	{node = self.unfinishednode()}
	;

superclass_init
	{char *q;} 
	: 
	q = qualified_id LPAREN (el = expression_list)? RPAREN
	;

dtor_head[definition] returns[node]
	:
	dds = dtor_decl_spec
	dd = dtor_declarator[definition]
	{node = self.autonode([dd], dds)}
	;

dtor_decl_spec returns[sl]
	:
	{sl = []}
	(("inline"|"_inline"|"__inline"){sl.append("inline")}|"virtual"{sl.append("virtual")})*
	;

dtor_declarator[definition] returns[node]
	:	
	s = scope_override
	TILDE ID
	{self.declaratorParameterList(definition)}
	LPAREN RPAREN
	{self.declaratorEndParameterList(definition)}
	(es = exception_specification)?
	{node = self.autonode()}
	;

dtor_body returns[node]
	:
	cs = compound_statement {node = checknode(cs)}
	{self.endDestructorDefinition()}
	;

parameter_list returns [node]
	:	pdl = parameter_declaration_list {node = self.autonode([pdl])} (ELLIPSIS {node.set_leaf("...")} )?
	;

parameter_declaration_list returns[node]
	:	
	(	parameter_declaration 
		(// Have not been able to find way of stopping warning of non-determinism between alt 1 and exit branch of block
		 COMMA parameter_declaration
		)*
	)
	{node = self.unfinishednode()}
	;

parameter_declaration
	:	{self.beginParameterDeclaration()}
		(
			{not ((self.LA(1)==SCOPE) and (self.LA(2)==STAR or self.LA(2)==OPERATOR)) and ( not (self.LA(1)==SCOPE or self.LA(1)==ID) or self.qualifiedItemIsOneOf(qiType|qiCtor) )}?
			ds = declaration_specifiers	// DW 24/3/98 Mods for K & R
			(  
				(declarator)=> d = declarator        // if arg name given
			| 
				ad = abstract_declarator     // if arg name not given  // can be empty
			)
		|
			(declarator)=> d = declarator			// DW 24/3/98 Mods for K & R
		|
			ELLIPSIS
		)
		(ASSIGNEQUAL 
		 re = remainder_expression // DW 18/4/01 assignment_expression
		)?
	;

type_name returns[node]// aka type_id
	:
	ds = declaration_specifiers ad = abstract_declarator {node = self.autonode([checknode(ds), checknode(ad)]); node.set_result(ds.result + ad.result)}
	;

/* This rule looks a bit weird because (...) can happen in two
 * places within the declaration such as "void (*)()" (ptr to
 * function returning nothing).  However, the () of a function
 * can only occur after having seen either a (abstract_declarator)
 * and not after a [..] or simple '*'.  These are the only two
 * valid () func-groups:
 *    int (*)();     // ptr to func
 *    int (*[])();   // array of ptr to func
 */
abstract_declarator returns[node]
	:	//{( !(LA(1)==SCOPE||LA(1)==ID) || self.qualifiedItemIsOneOf(qiPtrMember) )}?
		po = ptr_operator ad = abstract_declarator 
		{node = self.autonode([ad], po); node.set_result(po.result + ad.result)}
	|	
		LPAREN ad2 = abstract_declarator RPAREN
		{node = self.autonode([ad2])}
		(ads = abstract_declarator_suffix {node.add_child(ads)})+
		{node.set_result(None)}
	|	
		{node = self.autonode(None, "[]")}
		(LSQUARE (cx = constant_expression {node.add_child(dx)})? RSQUARE {self.declaratorArray()}
		)+
		{node.set_result(None)}
	|	
		{node = self.autonode()}
		{node.set_result("")}
		/* empty */
	;

abstract_declarator_suffix returns[node]
	:	
		{node = self.autonode(None, "[]")}
		LSQUARE (cx = constant_expression {node.add_child(cx)} )? RSQUARE
		{self.declaratorArray()}
	|
		LPAREN
		{node = self.autonode()}
		{self.declaratorParameterList(0);}
		(pl = parameter_list {node.add_child(pl)} )?
		RPAREN
		cvs = cv_qualifier_seq {node.set_leaf(["()", cvs])}
		{self.declaratorEndParameterList(0)}
		(es = exception_specification {node.add_child(es)} )?
	;

exception_specification returns[node]
	:	"throw" 
		LPAREN 
		(	(so = scope_override ID (COMMA so = scope_override ID)? )? 
		|	ELLIPSIS
		)
		RPAREN
		{node = self.unfinishednode()}
	;

template_head returns [node]
	:	
		"template"
		LESSTHAN tpl = template_parameter_list GREATERTHAN
		{node = self.autonode([tpl])}
	;

template_parameter_list returns [node]
	:	
		{self.beginTemplateParameterList()}
		{node = self.autonode()}
		tp = template_parameter {node.add_child(tp)} (COMMA tp = template_parameter {node.add_child(tp)} )*
		{self.endTemplateParameterList()}
	;

/* Rule requires >2 lookahead tokens. The ambiguity is resolved 
 * correctly, however. According to the manual "...A template argument
 * that can be interpreted either as a parameter-declaration or a
 * type-argument (because its identifier is the name of an
 * already existing class) is taken as type-argument."
 * Therefore, any "class ID" that is seen on the input, should
 * match the first alternative here (it should be a type-argument).
 */
template_parameter returns[node]
	:
	(options{generateAmbigWarnings = false;}:
		("class"|"typename") 
		(id:ID  (ASSIGNEQUAL assigned_type_name)? )?
		{self.templateTypeParameter(id.getText())}
	|	
		parameter_declaration	// DW 30/06/03 This doesn't seem to match the current standard
	)
	{node = self.unfinishednode()}
	;

/* This is to allow an assigned type_name in a template parameter
 *	list to be defined previously in the same parameter list,
 *	as type setting is ineffective whilst guessing
 */
assigned_type_name
	:
	(options{generateAmbigWarnings = false;}:
		s = qualified_type ad = abstract_declarator	
	|
		ts = simple_type_specifier ad = abstract_declarator
	)
	;

// This rule refers to an instance of a template class or function
template_id	// aka template_class_name
	:	ID LESSTHAN tal = template_argument_list GREATERTHAN
	;

template_argument_list returns [node]
	:	ta = template_argument {node = self.autonode(ta)} (COMMA ta = template_argument {node.add_child(ta)} )*
	;

/* Here assignment_expression was changed to shift_expression to rule out
 *  x< 1<2 > which causes ambiguities. As a result, these can be used only
 *  by enclosing parentheses x<(1<2)>. This is true for x<1+2> ==> bad,
 *  x<(1+2)> ==> ok.
 */
template_argument returns[node]
	:
		{( not (self.LA(1)==SCOPE or self.LA(1)==ID) or self.qualifiedItemIsOneOf(qiType|qiCtor) )}?
		tn = type_name
	|	sx = shift_expression // failed in iosfwd
//	|	assignment_expression	// Inserted as per grammar summary
	{node = self.unfinishednode()}
	;

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//////////////////////////////  STATEMENTS ////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

statement_list returns [node]
	{accum = []}
	:	(s = statement {accum.append(s)})+ {node = self.autonode(accum)}
	;

statement returns [node]
	:
	(	(declaration)=> d = declaration {node = self.autonode([d])}
	|	labeled_statement {node = self.unfinishednode("statement_labeled")}
	|	case_statement {node = self.unfinishednode("statement_case")}
	|	default_statement {node = self.unfinishednode("statement_default")}
	|	e = expression  {node = checknode(e)} SEMICOLON! {self.end_of_stmt()}
	|	compstat = compound_statement {node = checknode(compstat)}
	|	sstat = selection_statement {node = checknode(sstat)}
	|	iterstat = iteration_statement {node = checknode(iterstat)}
	|	jumpstat = jump_statement {node = checknode(jumpstat)}
	|	SEMICOLON! {self.end_of_stmt()} {node = self.blanknode()}
	|	try_block {node = self.unfinishednode("statement_try")}
	|	throw_statement {node = self.unfinishednode("statement_throw")}
	|	asm_block {node = self.unfinishednode("statement_asm_block")}
	)
	;

labeled_statement
	:	ID COLON s = statement
	;

case_statement
	:	"case"
		cx = constant_expression COLON s = statement
	;

default_statement
	:	"default" COLON s = statement
	;

compound_statement returns [node]
	:	LCURLY 
{
self.end_of_stmt()
self.enterNewLocalScope()
}
		{node = self.autonode()}
		(sl = statement_list {node.add_child(sl)} )?
		RCURLY {self.exitLocalScope()}
	;

/* NOTE: cannot remove ELSE ambiguity, but it parses correctly.
 * The warning is removed with the options statement
 */
selection_statement returns [node]
	:	
		"if"^ LPAREN 
		x1 = expression RPAREN
		s1 = statement
		{node = self.autonode([x1, s1], "if")}
		(options {warnWhenFollowAmbig = false;}:
		 "else"^ s2 = statement {node.add_child(s2)})?
	|	
		"switch"^ LPAREN  x3 = expression RPAREN s3 = statement
		{node = self.autonode([x3, x4], "switch")}
	;

iteration_statement returns [node]
	:	
		"while"	
		LPAREN x1 = expression RPAREN 
		s1 = statement  
		{node = self.autonode([x1, s1], "while")}
	|	
		"do" 
		s2 = statement "while"
		LPAREN x2 = expression RPAREN 
		SEMICOLON! {self.end_of_stmt()} 
		{node = self.autonode([s2, x2], "do")}
	|	
		"for" LPAREN
		(	(declaration)=> d1 = declaration {node = self.autonode([d1], "for")}
		|	x3 = expression SEMICOLON! {self.end_of_stmt()} {node = self.autonode([x3], "for")}
		|	SEMICOLON! {self.end_of_stmt()}  {node = self.autonode([self.blanknode()], "for")}
		)
		{x4 = self.blanknode()}
		{x5 = self.blanknode()}
		(x4 = expression)? SEMICOLON! {self.end_of_stmt()}
		(x5 = expression)?
		{node.add_child(x4)} {node.add_child(x5)}
		RPAREN s3 = statement	  {node.add_child(s3)}
	;

jump_statement returns[node]
	:	
	(	"goto" gotoid:ID SEMICOLON! {self.end_of_stmt()} {node = self.node("jump_goto", None, gotoid)}
	|	"continue" SEMICOLON! {self.end_of_stmt()} {node = self.autonode(None, "continue")}
	|	"break" SEMICOLON! {self.end_of_stmt()} {node = self.autonode(None, "break")}
		// DW 16/05/03 May be problem here if return is followed by a cast expression 
	|	"return" {self.in_return = True}
//		(	options{warnWhenFollowAmbig = false;}:
//			(LPAREN {(self.qualifiedItemIsOneOf(qiType) )}? ID RPAREN)=> 
//			LPAREN ID RPAREN (expression)?	// This is an unsatisfactory fix for problem in xstring re "return (allocator);"
//											//  and in xlocale re return (_E)(_Tolower((unsigned char)_C, &_Ctype));
//			//{printf("%d CPP_parser.g jump_statement Return fix used\n",self.LT(1).getLine());}
//		|	(expression  
//		/* nfd: fixme: I commented out the above weirdo thing */
//		)?	SEMICOLON!
	   x = expression SEMICOLON!
{
self.in_return = False
self.end_of_stmt() 
node = self.autonode([x], "return")
}
	)
	;

try_block
	:	"try" compstat = compound_statement (handler)*
	;


handler
	:	"catch"
		{self.exceptionBeginHandler()}
		{self.declaratorParameterList(1)}
		LPAREN exception_declaration RPAREN
		{self.declaratorEndParameterList(1)}
		compstat = compound_statement
		{self.exceptionEndHandler()}
	;

exception_declaration
	:	pdl = parameter_declaration_list
	;

/* This is an expression of type void according to the ARM, which
 * to me means "statement"; it removes some ambiguity to put it in
 * as a statement also.
 */
throw_statement
	:	"throw" (ax = assignment_expression) ? SEMICOLON! { end_of_stmt();}
	;

using_declaration returns [node]
	:	"using"
		("namespace" qid = qualified_id	// Using-directive
		|qid = qualified_id				// Using-declaration
		)
		SEMICOLON! {end_of_stmt();}
		{node = self.unfinishednode()}
	;

asm_block 	
	:   std_asm_block | gcc_asm_block
	;

std_asm_block
	:	("_asm"|"__asm") LCURLY (~RCURLY)* RCURLY 
	;

gcc_asm_block
	:   ("__asm__" | "asm") ("volatile")? LPAREN asm_code COLON (asm_reg_spec)? COLON (asm_reg_spec)? RPAREN
	;

asm_code
	: (StringLiteral)+
	;

asm_reg_spec
	: StringLiteral LPAREN ID RPAREN (COMMA StringLiteral LPAREN ID RPAREN)*
	;

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//////////////////////////////  EXPRESSIONS ///////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

expression returns [node]
	:	x = assignment_expression {node = x} (COMMA x = assignment_expression {node = self.exprnode_acc(node, x, ",")})*
	;

/* right-to-left for assignment op */
assignment_expression returns[node]
	:	cx = conditional_expression {node = checknode(cx)}
		(	(ASSIGNEQUAL {leaf="="} |TIMESEQUAL {leaf="*="}|DIVIDEEQUAL {leaf="/="}
			|MINUSEQUAL{leaf="-="}|PLUSEQUAL {leaf="+="}
			|MODEQUAL{leaf="%="}
			|SHIFTLEFTEQUAL{leaf="<<="}
			|SHIFTRIGHTEQUAL{leaf=">>="}
			|BITWISEANDEQUAL{leaf="&="}
			|BITWISEXOREQUAL{leaf="^="}
			|BITWISEOREQUAL{leaf="|="}
			)
			rx = remainder_expression {node = self.exprnode_acc(node, checknode(rx), leaf)}
		)?
	;

remainder_expression returns[node]
	:
		(	(conditional_expression (COMMA|SEMICOLON|RPAREN)
			)=>
			{self.assign_stmt_RHS_found += 1}
			x = assignment_expression {node = checknode(x)}
{
if self.assign_stmt_RHS_found > 0:
    self.assign_stmt_RHS_found -= 1
else:
    print "%d warning Error in assign_stmt_RHS_found = %d" % (self.LT(1).getLine(), self.assign_stmt_RHS_found);
}
		|	
			x = assignment_expression {node = checknode(x)}
		)
	;

conditional_expression returns[node]
	:	
		lx = logical_or_expression {node = checknode(lx)}
		(QUESTIONMARK e = expression COLON cx = conditional_expression {node = self.autonode([checknode(lx), checknode(e), checknode(cx)], "?:")})?
	;

constant_expression returns[node]
	:	
		cs = conditional_expression
		{node = checknode(cs)}
	;

logical_or_expression returns[node]
	:	
		x = logical_and_expression {node = x} (OR x = logical_and_expression {node = self.exprnode_acc(node, x, "||")})* 
	;

logical_and_expression returns[node]
	:	
		x = inclusive_or_expression {node = x} (AND x = inclusive_or_expression {node = self.exprnode_acc(node, x, "&&")})* 
	;

inclusive_or_expression returns[node]
	:	
		x = exclusive_or_expression {node = x} (BITWISEOR x = exclusive_or_expression {node = self.exprnode_acc(node, x, "|")})*
	;

exclusive_or_expression returns[node]
	:	
		x = and_expression {node = x} (BITWISEXOR x = and_expression {node = self.exprnode_acc(node, x, "^")})*
	;

and_expression returns[node]
	:	
	x = equality_expression {node = x} (AMPERSAND x = equality_expression {node = self.exprnode_acc(node, x, "&")})*
	;

equality_expression returns[node]
	:	
		x = relational_expression {node = x} ((NOTEQUAL {leaf = "!="}| EQUAL {leaf = "=="}) x = relational_expression {node = self.exprnode_acc(node, x, leaf)})*
	;

relational_expression returns[node]
	:	x = shift_expression {node = x}
		(options {warnWhenFollowAmbig = false;}:
			(	LESSTHAN {leaf = "<"}
			|	GREATERTHAN {leaf = ">"}
			|	LESSTHANOREQUALTO {leaf = "<="}
			|	GREATERTHANOREQUALTO {leaf = ">="}
			)
		 x = shift_expression {node = self.exprnode_acc(node, x, leaf)}
		)*
	;

shift_expression returns[node]
	:	x = additive_expression {node = x} ((SHIFTLEFT {leaf = "<<"}| SHIFTRIGHT {leaf = ">>"}) x = additive_expression {node = self.exprnode_acc(node, x, leaf)})*
	;

/* See comment for multiplicative_expression regarding #pragma */
additive_expression returns[node]
	:	x = multiplicative_expression {node = x}
		(options{warnWhenFollowAmbig = false;}:
			(PLUS {leaf = "+"}| MINUS {leaf = "-"}) x = multiplicative_expression
			{node = self.exprnode_acc(node, x, leaf)}
		)*
	;

/* ANTLR has trouble dealing with the analysis of the confusing unary/binary
 * operators such as STAR, AMPERSAND, PLUS, etc...  With the #pragma (now "(options{warnWhenFollowAmbig = false;}:" etc.)
 * we simply tell ANTLR to use the "quick-to-analyze" approximate lookahead
 * as full LL(k) lookahead will not resolve the ambiguity anyway.  Might
 * as well not bother.  This has the side-benefit that ANTLR doesn't go
 * off to lunch here (take infinite time to read grammar).
 */
multiplicative_expression returns[node]
	:	x = pm_expression {node = x}
		(options{warnWhenFollowAmbig = false;}:
			(STAR {leaf = "*"}| DIVIDE {leaf = "/"}| MOD {leaf = "%"}) x = pm_expression
			{node = self.exprnode_acc(node, x, leaf)}
		)*
	;

/* Pointer to member operators*/
pm_expression returns[node]
	:	x = cast_expression {node = x} ((DOTMBR {leaf = ".*"}| POINTERTOMBR {leaf = "->*"}) x = cast_expression {node = self.exprnode_acc(node, x, leaf)})*
	;

/* The string "( ID" can be either the start of a cast or
 * the start of a unary_expression.  However, the ID must
 * be a type name for it to be a cast.  Since ANTLR can only hoist
 * semantic predicates that are visible without consuming a token,
 * the semantic predicate in rule type_name is not hoisted--hence, the
 * rule is reported to be ambiguous.  I am manually putting in the
 * correctly hoisted predicate.
 *
 * Ack! Actually "( ID" might be the start of "(T(expr))" which makes
 * the first parens just an ordinary expression grouping.  The solution
 * is to look at what follows the type, T.  Note, this could be a
 * qualified type.  Yucko.  I believe that "(T(" can only imply
 * function-style type cast in an expression (...) grouping.
 *
 * We DO NOT handle the following situation correctly at the moment:
 * Suppose you have
 *    struct rusage rusage;
 *    return (rusage.fp);
 *    return (rusage*)p;
 * Now essentially there is an ambiguity here. If rusage is followed by any
 * postix operators then it is an identifier else it is a type name. This
 * problem does not occur in C because, unless the tag struct is attached,
 * rusage is not a type name. However in C++ that restriction is removed.
 * No *real* programmer would do this, but it's in the C++ standard just for
 * fun..
 *
 * Another fun one (from an LL standpoint):
 *
 *   (A::B::T *)v;      // that's a cast of v to type A::B::T
 *   (A::B::foo);    // that's a simple member access
 *
 * The qualifiedItemIs(1) function scans ahead to what follows the
 * final "::" and returns qiType if the item is a type.  The offset of
 * '1' makes it ignore the initial LPAREN; normally, the offset is 0.
 */

cast_expression returns[node]
	:
	(compound_literal) => x = compound_literal {node = x} /* nfd */
	|
		// DW 23/06/03
		(LPAREN (type_qualifier)? simple_type_specifier (ptr_operator)? RPAREN)=>
		 LPAREN (tq = type_qualifier)? ts = simple_type_specifier (po = ptr_operator)? RPAREN cx = cast_expression
		 {node = self.unfinishednode()}
	|  
		x = unary_expression {node = x}	// handles outer (...) of "(T(expr))"
	;

unary_expression returns[node]
	:
		(	//{!(LA(1)==TILDE && LA(2)==ID)||self.qualifiedItemIsOneOf(qiVar|qiFun|qiDtor|qiCtor)}?
			(postfix_expression)=> x = postfix_expression {node = x}
		|	PLUSPLUS x = unary_expression {node = self.autonode([x], "++."); node.set_result("++" + node.result)}
		|	MINUSMINUS x= unary_expression {node = self.autonode([x], "--."); node.set_result("--" + node.result)}
		|	op = unary_operator x = cast_expression {node = self.autonode([x], op); node.set_result(None)}
		|	"sizeof" {node = self.autonode(None, "sizeof")}
			(// see comment for rule cast_expression for info on predicate
			 // JEL NOTE 3/31/96 -- This won't work -- you really need to
			 // call self.qualifiedItemIsOneOf(qiType|qiCtor,1)
			 // The context should also be ( LPAREN (SCOPE|ID) )
			 //	( LPAREN ID ) => {self.isTypeName((LT(2)->getText()).data())}?
			 {(not (((self.LA(1)==LPAREN and (self.LA(2)==ID)))) or (self.isTypeName(self.LT(2).getText())))}?
				LPAREN x = type_name RPAREN {node.add_child(x)}
			|	x = unary_expression {node.add_child(x)}
			)
		|   {node = self.autonode()}
			(s:SCOPE {node.set_leaf(s)})?
			(x = new_expression {node.add_child(x)}
			|x = delete_expression {node.add_child(x)}
			)
		)
	;

postfix_expression returns[node]
	:
	(	
		options {warnWhenFollowAmbig = false;}:
		// Function-style cast must have a leading type
		{(self.LA(1) != LPAREN)}?
		(ts = simple_type_specifier LPAREN RPAREN LPAREN)=>	// DW 01/08/03 To cope with problem in xtree (see test10.i)
		 ts = simple_type_specifier LPAREN RPAREN LPAREN (el = expression_list)? RPAREN
		{node = self.unfinishednode()}
	|
		{(self.LA(1) != LPAREN)}?
		(ts = simple_type_specifier LPAREN)=>
		 ts = simple_type_specifier LPAREN (el = expression_list)? RPAREN
		{node = self.unfinishednode()}
	|  
		x = primary_expression {node = x}
		(options {warnWhenFollowAmbig = false;}:
        	LSQUARE x = expression RSQUARE {node = self.autonode([node, x], "[]")}
		|	LPAREN {node = self.autonode([node], "()")} (x = expression_list {node = self.autonode([node, x], "()")})? RPAREN 
		|	DOT idxpr = id_expression {node = self.autonode([node], [".", idxpr])}
		|	POINTERTO idxpr2 = id_expression {node = self.autonode([node], ["->", idxpr2])}
		|	PLUSPLUS {node = self.autonode([node], "++")}
		|	MINUSMINUS {node = self.autonode([node], "--")}
		)*
	|
		("dynamic_cast"|"static_cast"|"reinterpret_cast"|"const_cast")	// Note const_cast in elsewhere
		LESSTHAN ts = type_specifier[ds] (po = ptr_operator)? GREATERTHAN
		LPAREN x = expression RPAREN
		{node = self.unfinishednode()}
	)
	;

primary_expression returns[node]
	:	x = id_expression {node = self.exprnode(None, x, result = x)}
	|	x = constant {node = self.exprnode(None, x, result = x)}
	|	"this" {node = self.exprnode(None, "this", result = "this")}
	|	LPAREN x = expression RPAREN {node = x}
	;

compound_literal returns[node]
	/* nfd: ISO C99 "compound literals" feature (extension) */
	: LPAREN tn = type_name RPAREN LCURLY i = initializer RCURLY
	{node = self.autonode([tn, i])}
	;

id_expression returns[out]
	:
		out = scope_override
		(	id1:ID {out += id1.getText()}
		|	OPERATOR o = optor {out += "operator " + o}
		|	TILDE {out += "~"} (STAR {out += "*"} )? id2:ID {out += id2.getText()}	// DW 29/07/03 STAR included to allow for *_S = ~*_S; seen in vector
		)
	;

unary_operator returns[op]
	:	AMPERSAND {op = "&"}
	|	STAR {op = "*"}
	|	PLUS {op = "+"}
	|	MINUS {op = "-"}
	|	TILDE {op = "~"}
	|	NOT {op = "~"}
	;

/* JEL The first ()? is used to resolve "new (expr) (type)" because both
 * (expr) and (type) look identical until you've seen the whole thing.
 *
 * new_initializer appears to be conflicting with function arguments as
 * function arguments can follow a primary_expression.  [This is a full
 * LL(k) versus LALL(k) problem.  Enhancing context by duplication of
 * some rules might handle this.]
 */
new_expression returns[node]
	:
	(  
		"new"
		((LPAREN expression_list RPAREN)=> 
			LPAREN el = expression_list RPAREN)?
		(new_type_id | LPAREN tn = type_name RPAREN)
		(options{warnWhenFollowAmbig = false;}:	
		(new_initializer)=> new_initializer)?
	)
	{node = self.unfinishednode()}
	;

new_initializer
	:	LPAREN (el = expression_list)? RPAREN
	;

new_type_id
	:	ds = declaration_specifiers 
		(options {warnWhenFollowAmbig = false;}:
		 //{( !(LA(1)==SCOPE||LA(1)==ID) || self.qualifiedItemIsOneOf(qiPtrMember) )}?
			new_declarator 
		)?
	;

new_declarator
	:	//{( !(LA(1)==SCOPE||LA(1)==ID) || self.qualifiedItemIsOneOf(qiPtrMember) )}?  
		//ptr_to_member cv_qualifier_seq 
		po = ptr_operator
		(options {warnWhenFollowAmbig = false;}:
		new_declarator ) ?
	|	direct_new_declarator
	;

ptr_operator returns[oper]
	:	{oper="UNKNOWN"} (	AMPERSAND {oper = "&"}	{self.is_address = True}
		|	("_cdecl"|"__cdecl") {oper = "_cdecl"}
		|	("_near"|"__near") {oper = "_near"}
		|	("_far"|"__far") {oper = "_far"}
		|	"__interrupt" {oper = "__interrupt"}
		|	("pascal"|"_pascal"|"__pascal") {oper = "pascal"}
		|	("_stdcall"|"__stdcall") {oper = "_stdcall"}
		|	ptm = ptr_to_member	{oper = ptm}// e.g. STAR 
		)	
   ;

// Match A::B::*
ptr_to_member returns[ptm]
	:
	s = scope_override {ptm = s} STAR {ptm += "*"}  {self.is_pointer = True} cvs = cv_qualifier_seq {ptm += cvs}
	;

// Match the A::B::C:: or nothing
scope_override returns [s]
	{sitem = ""}
	:
		//{!(self.qualifiedItemIsOneOf(qiType))}?
		(SCOPE {sitem += "::"} )?
		(	options {warnWhenFollowAmbig = false;}:
			{self.scopedItem()}?
			id:ID (LESSTHAN tal = template_argument_list GREATERTHAN)? SCOPE
{
//printf("scope_override entered\n");
sitem += id.getText() + "::"
}
		)*
	{s = sitem;
	}
	;

/* The "[expression]" construct conflicts with the "new []" construct
 * (and possibly others).  We used approximate lookahead for the "new []"
 * construct so that it would not try to compute full LL(2) lookahead.
 * Here, we use #pragma approx again because anytime we see a [ followed
 * by token that can begin an expression, we always want to loop.
 * Approximate lookahead handles this correctly.  In fact, approximate
 * lookahead is the same as full lookahead when all but the last lookahead
 * depth are singleton sets; e.g., {"["} followed by FIRST(expression).
 */
direct_new_declarator
	:
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE x = expression RSQUARE
		)+
	;

delete_expression returns[node]
	:	"delete" {node = self.node("delete")} (LSQUARE RSQUARE {node.set_leaf("[]")} )? cx = cast_expression {node.add_child(cx)}
	;

expression_list returns[node]
	:	x = assignment_expression {node = x}(COMMA x = assignment_expression {node.add_child(x)})*
	;

constant returns[out]
	:	{out = ""}
		oi:OCTALINT {out = oi.getText()}
	|	di:DECIMALINT {out = di.getText()}
	|	hi:HEXADECIMALINT {out = hi.getText()}
	|	cl:CharLiteral {out = cl.getText()}
	|	(sl:StringLiteral {out += sl.getText()})+
	|	f1:FLOATONE {out = f1.getText()}
	|	f2:FLOATTWO {out = f2.getText()}
	|	"true" {out = "true"}
	|	"false" {out = "false"}
	;

optor  returns[out]
	:
		"new" {out = "new"}
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE RSQUARE | )		// check syntax
	|   
		"delete" {out = "delete"}
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE RSQUARE | )		// check syntax
	|	LPAREN RPAREN {out = "()"}
	|	LSQUARE RSQUARE {out = "[]"}
	|	x = optor_simple_tokclass {out = x}	//OPTOR_SIMPLE_TOKCLASS
	;

//Zuo 5/11/2001
// This is the equivalent to "#tokclass OPTOR_SIMPLE_TOKCLASS" in cplusplus.g

optor_simple_tokclass returns[out]
	:
    (PLUS|MINUS|STAR|DIVIDE|MOD|BITWISEXOR|AMPERSAND|BITWISEOR|TILDE|NOT|
	 SHIFTLEFT|SHIFTRIGHT|
	 ASSIGNEQUAL|TIMESEQUAL|DIVIDEEQUAL|MODEQUAL|PLUSEQUAL|MINUSEQUAL|
	 SHIFTLEFTEQUAL|SHIFTRIGHTEQUAL|BITWISEANDEQUAL|BITWISEXOREQUAL|BITWISEOREQUAL|
	 EQUAL|NOTEQUAL|LESSTHAN|GREATERTHAN|LESSTHANOREQUALTO|GREATERTHANOREQUALTO|OR|AND|
	 PLUSPLUS|MINUSMINUS|COMMA|POINTERTO|POINTERTOMBR
	)
	;

// Zuo 19/11/01 from next line, the Lexer is derived from stdCParser.g

class CPPLexer extends Lexer;

options
	{
	k = 3;
	exportVocab = STDC;
	testLiterals = true;
	}

// DW 4/11/02 put in to support manual hoisting
tokens
	{
	OPERATOR = "operator";
	}

{
lineObject = LineObject()
originalSource = ""
deferredLineCount = 0

_line = 0

def setOriginalSource(src):
    originalSource = src
    lineObject.setSource(src)

def setSource(src):
    lineObject.setSource(src)
  

def deferredNewline():
    deferredLineCount += 1

}

/* Operators: */

ASSIGNEQUAL     : '=' ;
COLON           : ':' ;
COMMA           : ',' ;
QUESTIONMARK    : '?' ;
SEMICOLON       : ';' ;
POINTERTO       : "->" ;

/*
// DOT & ELLIPSIS are commented out since they are generated as part of
// the Number rule below due to some bizarre lexical ambiguity shme.
// DOT  :       '.' ;
// ELLIPSIS      : "..." ;
*/

LPAREN          : '(' ;
RPAREN          : ')' ;
LSQUARE         : '[' ;
RSQUARE         : ']' ;
LCURLY          : '{' ;
RCURLY          : '}' ;

EQUAL           : "==" ;
NOTEQUAL        : "!=" ;
LESSTHANOREQUALTO     : "<=" ;
LESSTHAN              : "<" ;
GREATERTHANOREQUALTO  : ">=" ;
GREATERTHAN           : ">" ;

DIVIDE          : '/' ;
DIVIDEEQUAL     : "/=" ;
PLUS            : '+' ;
PLUSEQUAL       : "+=" ;
PLUSPLUS        : "++" ;
MINUS           : '-' ;
MINUSEQUAL      : "-=" ;
MINUSMINUS      : "--" ;
STAR            : '*' ;
TIMESEQUAL      : "*=" ;
MOD             : '%' ;
MODEQUAL        : "%=" ;
SHIFTRIGHT      : ">>" ;
SHIFTRIGHTEQUAL : ">>=" ;
SHIFTLEFT       : "<<" ;
SHIFTLEFTEQUAL  : "<<=" ;

AND            : "&&" ;
NOT            : '!' ;
OR             : "||" ;

AMPERSAND       : '&' ;
BITWISEANDEQUAL : "&=" ;
TILDE           : '~' ;
BITWISEOR       : '|' ;
BITWISEOREQUAL  : "|=" ;
BITWISEXOR      : '^' ;
BITWISEXOREQUAL : "^=" ;

//Zuo: the following tokens are come from cplusplus.g

POINTERTOMBR    : "->*" ;
DOTMBR          : ".*"  ;

SCOPE           : "::"  ;

// DW 10/10/02
// Whitespace -- ignored
Whitespace	
	:	(	(' ' |'\t' | '\f')
			// handle newlines
		|	(	"\r\n"  // MS
			|	'\r'    // Mac
			|	'\n'    // Unix 
			)	{ $nl; }
			// handle continuation lines
		|	(	"\\\r\n"  // MS
			|	"\\\r"    // Mac
			|	"\\\n"    // Unix 
			)	{deferredNewline()}
		)	
		{$skip}
	;

Comment  
	:	"/*"   
		(	{self.LA(2) != '/'}? '*'
		|	EndOfLine {deferredNewline();}
		|	~('*'| '\r' | '\n')
		)*
		"*/" {$skip}
	;

CPPComment
	:	"//" (~('\n' | '\r'))* EndOfLine
 		{$skip; $nl;}                     
	;

PREPROC_DIRECTIVE
	options{paraphrase = "a line directive";}
	:	'#' LineDirective
		{$skip; $nl;} 
	;

protected 
LineDirective
	:
		("line")?  // this would be for if the directive started "#line"
		(Space)+
		n:Decimal
		(Space)+
		(sl:StringLiteral)?
		{
self.line_directive_handler(sl.getText(), n.getText())  // see main()
		}
		EndOfLine
	;

protected  
Space
	:	(' ' | '\t' | '\f')
	;


Pragma
	:	('#' "pragma" (~('\r' | '\n'))* EndOfLine)
		{$skip; $nl;}
	;

Error
	:	('#' "error" (~('\r' | '\n'))* EndOfLine)
		{$skip; $nl;}
	;

/* Literals: */

/*
 * Note that we do NOT handle tri-graphs nor multi-byte sequences.
 */

/*
 * Note that we can't have empty character constants (even though we
 * can have empty strings :-).
 */
CharLiteral
	:	'\'' (Escape | ~( '\'' )) '\''
	;

/*
 * Can't have raw imbedded newlines in string constants.  Strict reading of
 * the standard gives odd dichotomy between newlines & carriage returns.
 * Go figure.
 */
StringLiteral
	:	'"'
		( Escape
		|	(	"\\\r\n"   // MS 
			|	"\\\r"     // MAC
			|	"\\\n"     // Unix
			)	{deferredNewline();}
		|	~('"' | '\r' | '\n' | '\\')
		)*
		'"'
	;

protected
EndOfLine
	:	(	options{generateAmbigWarnings = false;}:
			"\r\n"  // MS
		|	'\r'    // Mac
		|	'\n'    // Unix
		)
	;

/*
 * Handle the various escape sequences.
 *
 * Note carefully that these numeric escape *sequences* are *not* of the
 * same form as the C language numeric *constants*.
 *
 * There is no such thing as a binary numeric escape sequence.
 *
 * Octal escape sequences are either 1, 2, or 3 octal digits exactly.
 *
 * There is no such thing as a decimal escape sequence.
 *
 * Hexadecimal escape sequences are begun with a leading \x and continue
 * until a non-hexadecimal character is found.
 *
 * No real handling of tri-graph sequences, yet.
 */

protected
Escape  
	:	'\\'
		( options{warnWhenFollowAmbig=false;}:
		  'a'
		| 'b'
		| 'f'
		| 'n'
		| 'r'
		| 't'
		| 'v'
		| '"'
		| '\''
		| '\\'
		| '?'
		| ('0'..'3') (options{warnWhenFollowAmbig=false;}: Digit (options{warnWhenFollowAmbig=false;}: Digit)? )?
		| ('4'..'7') (options{warnWhenFollowAmbig=false;}: Digit)?
		| 'x' (options{warnWhenFollowAmbig=false;}: Digit | 'a'..'f' | 'A'..'F')+
		)
	;

/* Numeric Constants: */

protected
Digit
	:	'0'..'9'
	;

protected
Decimal
	:	('0'..'9')+
	;

protected
LongSuffix
	:	'l'
	|	'L'
	;

protected
UnsignedSuffix
	:	'u'
	|	'U'
	;

protected
FloatSuffix
	:	'f'
	|	'F'
	;

protected
Exponent
	:	('e' | 'E') ('+' | '-')? (Digit)+
	;

protected
Vocabulary
	:	'\3'..'\377'
	;

Number
	:	( (Digit)+ ('.' | 'e' | 'E') )=> (Digit)+
		( '.' (Digit)* (Exponent)? {_ttype = FLOATONE;} //Zuo 3/12/01
		| Exponent                 {_ttype = FLOATTWO;} //Zuo 3/12/01
		)                          //{_ttype = DoubleDoubleConst;}
		(FloatSuffix               //{_ttype = FloatDoubleConst;}
		|LongSuffix                //{_ttype = LongDoubleConst;}
		)?

	|	("...")=> "..."            {_ttype = ELLIPSIS;}

	|	'.'                        {_ttype = DOT;}
		(	(Digit)+ (Exponent)?   {_ttype = FLOATONE;} //Zuo 3/12/01
                                   //{_ttype = DoubleDoubleConst;}
			(FloatSuffix           //{_ttype = FloatDoubleConst;}
			|LongSuffix            //{_ttype = LongDoubleConst;}
			)?
		)?

	|	'0' ('0'..'7')*            //{_ttype = IntOctalConst;}
		(LongSuffix                //{_ttype = LongOctalConst;}
		|UnsignedSuffix            //{_ttype = UnsignedOctalConst;}
		)*                         {_ttype = OCTALINT;}

	|	'1'..'9' (Digit)*          //{_ttype = IntIntConst;}
		(LongSuffix                //{_ttype = LongIntConst;}
		|UnsignedSuffix            //{_ttype = UnsignedIntConst;}
		)*                         {_ttype = DECIMALINT;}  

	|	'0' ('x' | 'X') ('a'..'f' | 'A'..'F' | Digit)+
                                   //{_ttype = IntHexConst;}
		(LongSuffix                //{_ttype = LongHexConst;}
		|UnsignedSuffix            //{_ttype = UnsignedHexConst;}
		)*                         {_ttype = HEXADECIMALINT;}   
	;

ID
	options {testLiterals = true;}
	:	( 'a'..'z' | 'A'..'Z' | '_' )
		( 'a'..'z' | 'A'..'Z' | '_' | '0'..'9' )*
	;

