"""
Specialised tester for IDL; we want:

- Display parse tree
- Display AST
"""

import re
from optparse import OptionParser
from CAmkES.parser import parse_to_pt, parse_to_pt_noncached
from idlparser import parse as parse_idl_to_ast
from CAmkES.astgen import gen
from magpidl4 import IDL4OptionParser
from targets.shared.inputparser import CASTImporter as Importer
from targets.shared.options import options
from magpietypes.builtin import create_basictype_ast



# "constants"
REGISTRY_MACHINE_TYPE = "Generic 32"

def gimme_a_registry():
	""" Provide a type registry with builtin types for ast and cpp """
	return new_registry(REGISTRY_MACHINE_TYPE)

def main():
	# Parse command-line arguments and dispatch to appropriate tester.
	parser_inst = IDL4OptionParser()
	parser_inst.setup()
	parser_inst.parser.add_option('--idl', dest = 'idl', action = 'store_true', default = False,
			help = 'Display imported idl-ast')
	parser_inst.parser.add_option('--pt', dest = "pt", action = 'store_true', default = False,
			help = 'Display the MIG parse tree')
	parser_inst.parser.add_option('--ast', dest = 'ast', action = 'store_true', default = False,
			help = 'Display the MIG AST')
	parser_inst.parser.add_option('--types', dest = 'types', action = 'store_true', default = False,
			help = 'Import types and display the type registry')
	cmdlineoptions, cmdlineargs = parser_inst.parse_options()
	if cmdlineoptions.print_version:
		print VERSION_STRING
		sys.exit(0)
	if cmdlineargs == []: # No files, so exit
		parser_inst.print_help()
		print >>sys.stderr, "\nExiting because no IDL files were specified.\n"
		sys.exit(1)
		
	if cmdlineoptions.ugly_includepath_hack is not None:
		cmdlineoptions.include_dirs = [os.path.join(cmdlineoptions.ugly_includepath_hack, i)
			for i in cmdlineoptions.include_dirs]
	
	
	
	#parser = OptionParser()
	
	
	parser_inst.set_options()
	options.add_files(cmdlineargs)
	options['target'] = parser_inst.get_target()
	options.set_initialised()
	#registry = new_registry(REGISTRY_MACHINE_TYPE)
	importer = Importer(options.filenames)
	data = importer.preprocess_and_grab_data(options.filenames)
	hardware_arch = options['hardware_arch']
	generator_type = options['generator']
		
	
	#print data
	pt = parse_to_pt_noncached(data)
	
	if cmdlineoptions.pt:
		print "*** PT:"
		pt.print_tree()
		print "*** PT ends"
	
	if cmdlineoptions.ast:
		
		ast, idl_includes = gen(pt, importer, options)
		print "*** AST:"
		ast.print_tree()
		print "*** AST ends"
		
		basicast = create_basictype_ast(hardware_arch, generator_type)
		for filename in idl_includes.keys():
			data = importer.preprocess_and_grab_data([filename])
			idl_ast = parse_idl_to_ast(filename, data, basicast)
			basicast.add_child(idl_ast)
		
		if cmdlineoptions.idl:
			print "*** imported IDL-AST"
			basicast.print_tree()
			print "*** imported IDL-AST ends"
		
	if cmdlineoptions.types and ast:
		print "*** Types list:"
		walker = IDLASTWalker(registry)
		#registry.print_registry()
		walker.find_types(ast)
		walker.registry.print_registry()
		print "*** Types list ends"
		
	
	
if __name__ == '__main__':
	main()
