from targets.shared.options import options
from targets.shared.inputparser import CASTImporter as Importer
from targets.shared.target import Target
from magpietypes.builtin import create_basictype_ast
from parser import parse_to_pt, parse_to_pt_noncached
from idlparser import parse as parse_idl_to_ast
from magpietypes import infogripper
from astgen import gen
from parser_common import Definition, Node, Decorator, Annotation, Expression, Interface
from generator.generator import ASTInfo
import os


def run():
	importer = Importer(options.filenames)
	data = importer.preprocess_and_grab_data(options.filenames)
	pt = parse_to_pt_noncached(data)
	#pt.print_tree()
	adl_ast, idl_includes = gen(pt, importer, options)
	
	if idl_includes is not {}:
		hardware_arch = options['hardware_arch']
		generator_type = options['generator']
	
		basicast = create_basictype_ast(hardware_arch, generator_type)
		idlast_list = []
		for filename in idl_includes.keys():
			data = importer.preprocess_and_grab_data([filename])
			idl_ast = parse_idl_to_ast(filename, data, basicast)
			idlast_list.append(idl_ast)
	
	
	project_directory = create_directories(adl_ast)
	
	# creates idl4 asts from the idl-ast
	idl4asts, interface_name_lookup = modify_idl4_asts(basicast, idlast_list)
	
	
	# generate the "standard" magpie-output for the produced idl4-asts
	options.set_uninitialised()
	options['output_directory'] = os.path.join(project_directory,'include')
	options.set_initialised()
	generate_output(basicast, idl4asts)
	
	
	#creates .h files for component-client-side functions
	options.set_uninitialised()
	options['output_directory'] = os.path.join(project_directory,'connection')
	options.set_initialised()
	process_connections(adl_ast, interface_name_lookup)
	
	
def create_directories(adl_ast):
	projectname = '_'.join((os.path.basename(adl_ast.leaf).split('.')[:-1])) + '_project'
	if os.path.exists(projectname):
		version = 1
		while os.path.exists(projectname + '_' + str(version)):
			version += 1
		projectname += '_' + str(version)
	#print projectname
	os.mkdir(projectname)
	includename = projectname + '/include'
	#print includename
	os.mkdir(includename)
	connectionpath = os.path.join(projectname ,'connection')
	#print connectionpath
	os.mkdir(connectionpath)
	os.mkdir(os.path.join(connectionpath,'include'))
	os.mkdir(os.path.join(connectionpath,'src'))
	return projectname
	
	
	
	
def modify_idl4_asts(basicast, idlast_list):
	idlasts = []
	orig_interface_trees = {}
	for ast in idlast_list:
		#ast.print_tree()
		for defs in ast['definition']:
			if defs['interface'] is not []:

				ast.remove_child(defs)
				assert defs.the('decorator').the('annotation').leaf == 'uuid'
				uuid_str = defs.the('decorator').the('annotation').the('expression').leaf
				offset = 0
				interface_node = defs.the('interface')
				assert interface_node is not None
				interface_name = interface_node.leaf
				orig_interface_trees[interface_name] = ast
				func_list = interface_node['function']
				for func in func_list:
					def_node = Definition(None, None)
					dec_node = Decorator(def_node, None)
					def_node.add_child(dec_node)
					anno_node = Annotation(dec_node, None)
					anno_node.leaf = "uuid"
					dec_node.add_child(anno_node)
					expr_node = Expression(anno_node, None)
					anno_node.add_child(expr_node)
					expr_node.leaf = uuid_str + ' + ' + str(offset)
					try:
						result = eval(expr_node.leaf)
						expr_node.result = result
					except:
						pass
					
					new_interface = Interface(def_node,None)
					def_node.add_child(new_interface)
					new_interface.leaf = interface_name + '_' + func.leaf
					interface_node.remove_child(func)
					new_interface.add_child(func)
					
					ast.add_child(def_node)
					
					offset += 1
				#end of for
			#end of if
		#end of for defs
		
		idlasts.append(ast)
		#ast.print_tree()
		
	#return idlasts
					
					
	
	return idlasts, orig_interface_trees
	
	
def generate_output(basicast, idlasts):
	
	for ast in idlasts:
		basicast.add_child(ast)
		
		filename = ast.leaf
		
		for output_type in ['client','service', 'servicetemplate']:
			options.set_uninitialised()
			options['output_type'] = output_type
			
			if output_type == 'servicetemplate':
				output_type = output_type + '.c'
			else:
				output_type = output_type + '.h'
				
			options['output_filename'] = filename + '_' + output_type
			
			
			options.filenames = [filename]
			
			options.set_initialised()
			
			target_inst = Target()
			target_inst.asts = [ASTInfo(ast)]
			target_inst.generate_output()
				
		basicast.remove_child(ast)
	
	
def process_connections(adl_ast, interface_name_lookup):

	
	home_template_base = options['template_base']
	template_base = home_template_base + ['CAmkES','connections']
	#print home_template_base
	options.set_uninitialised()
	options.generator = 'CAmkES'
	options['target'] = ['CAmkES/generic']
	options.set_initialised()
	
	
	
	assembly_node = adl_ast.the('assembly')
	composition = assembly_node.the('composition')
	output_directory_base = str(options['output_directory'])
	for connection in composition['connection']:	
		connection_type = connection.get_attribute('target_type')[0].leaf
		if connection_type == 'IguanaRPC':
			tb = template_base + [connection_type]

			output_base = 'IguanaRPC_client'
			headername = ''
			for output in ['header','template']:
				options.set_uninitialised()
				options['output_type'] = '_'.join([output_base, output])
				options['template_base'] = tb
				options.set_initialised()
			
				connection_name = connection.leaf
				
				#client_part
				client_node = connection.the('from')
				target_list = client_node.get_attribute('target')[0]
				#output_directory_base = str(options['output_directory'])
				for name in client_node.leaf:
					client_name = '_'.join(name.split('.')[:-1])
					target = target_list[name]
					interface_name = target.get_attribute('target_type')[0]
					interface_ast = interface_name_lookup[interface_name]	
					assert interface_ast is not None
					

					if output == 'header':
						suffix = '.h'
						directory_addon = 'include'
						headername = client_name + connection_name + suffix
					else:
						suffix = '.c'
						directory_addon = 'src'
					
					options.set_uninitialised()
					options['output_filename'] = client_name + connection_name + suffix
					options['output_directory'] = os.path.join(output_directory_base, directory_addon)
					options.set_initialised()
					
					target_inst = Target()
					target_inst.asts = [ASTInfo(interface_ast)]
					#print 'template_base = ', options['template_base']
					generator_inst = target_inst.generator(target_inst.output, ASTInfo(interface_ast))
					options_inst = target_inst.dataStorage()
					options_inst.set_filename = connection.leaf
					options_inst.set_header_location = 'include/'
					options_inst.set_header_name = headername
					#generator_inst.user_data['header_name'] = headername
					
					
					#print 'processing connection: ', connection_name, client_name
					target_inst.generator_go(generator_inst)
					target_inst.write_output(target_inst.output.getvalue())
				
		else:
			print 'not supported connection-type: ', connection_type


def process_IguanaRPC(assembly_node, connection_node):	
	pass
	

	
	
