from parser_common import Node, Component, Interface, UnknownNode, Type, TypeInstance, Export, Info, Attribute, Declarator
#from magpietypes.registry import new_registry
from magpietypes import infogripper
from helper import usr_bin_which
from parser import parse_to_pt as parse_CAmkES_to_pt
#from idlparser.antlr.parser import parse_to_ast as parse_IDL_to_ast

# AST helper functions


class ASTGen(object):
	def __init__(self, importer, options):
		self.importer = importer
		self.options = options
		self.idl_includes = {}
		self.adl_list = []
		
	def convert(self, filename, pt):
		ast = self.translation_unit(filename[0], pt)
		#print self.idl_includes
		return ast, self.idl_includes
		
	def translation_unit(self, filename, pt):
		#print 'basic ast = %s' %(basicast.type)
		if filename in self.adl_list:
			return None
		else:
			self.adl_list.append(filename)
			
		ast = Node(None, "CAmkES-file")
		ast.leaf = filename
		#print 'ast.parent = %s' %(ast.parent.type)
		for node in pt.children:
			if node.type == 'definition':
				
				#def_node = Definition(ast, None)
				#ast.add_child(def_node)
				def_children = self.definition(ast, node, ast)
				#def_node.add_children(def_children)
				ast.add_children(def_children)
			elif node.type == 'import_dcl':
				imp_node = self.import_dcl(node)
				if imp_node is not None:
					ast.add_child(imp_node)
				
			elif node.type == 'include_dcl':
				inc_node = self.include_dcl(node)
				ast.add_child(inc_node)
			else:
				#print 'node = ', node.type
				ast.add_child(UnknownNode(None, node))
		return ast
		
		
	def import_dcl(self, pt):
		ast = Node(None, None)
		ast.type = "import" #pt.leaf
		"""
		if pt.leaf == 'import':
			#imported_scope
			child = pt.the('imported_scope').children[0]
		elif pt.leaf == 'cimport':
			child = pt.the('anglequoted_scope').children[0]
		"""
		
		child = pt.children[0].children[0]
		assert child is not None
		
			
		
		if child.type == 'string_literal':
			ast.leaf = child.leaf
		elif child.type == 'scoped_name':
			ast.leaf = self.scoped_name(child)
		elif child.type == 'anglequoted_string_literal':
			ast.leaf = child.leaf
		else:
			ast = Node(None, child)
			ast.type = 'import'
		data = self.importer.preprocess_and_grab_data([ast.leaf])
		pt = parse_CAmkES_to_pt(ast.leaf, data)
		importAST = self.translation_unit(ast.leaf, pt)
		return importAST
		#return ast
		
	def include_dcl(self, pt):
		ast = Node(None, None)
		ast.type = "include" #pt.leaf

		child = pt.children[0].children[0]
		assert child is not None
		
		if child.type == 'string_literal':
			ast.leaf = child.leaf
		elif child.type == 'scoped_name':
			ast.leaf = self.scoped_name(child)
		elif child.type == 'anglequoted_string_literal':
			ast.leaf = child.leaf
		else:
			ast = Node(None, child)
			ast.type = 'include'
			
		if self.idl_includes.has_key(ast.leaf):
			self.idl_includes[ast.leaf].append(ast)
		else:
			self.idl_includes[ast.leaf] = [ast]
			
		return ast
		
		
	def expr_list(self, pt, evaluate = False):
		ex_list = []
		for child in pt.children:
			if child.type == 'const_exp':
				exp_node = Expression(None)
				expr_str, result = self.getExpression(child, evaluate)
				if result is not None:
					exp_node.leaf = result 
				else:
					exp_node.leaf = expr_str
				#print exp_node.leaf, exp_node.result
				ex_list.append(exp_node)
			else:
				ex_list.append(UnknownNode(child))
		return ex_list
		
	def getExpression(self, node, evaluate=False):
		str_exp = ''
		result = None
		if len(node.children) == 0:
			if node.type == 'scoped_name':
				str_exp = self.scoped_name(node)
				result = None
			elif node.type == 'identifier':
                                str_exp = node.leaf
                                result = None
		elif len(node.children) == 1:
                        if node.type == 'scoped_name':
				str_exp = self.scoped_name(node)
				result = None
			elif node.type == 'literal':
				str_exp = node.leaf
				if evaluate:
					result = self.getValue(node)
			elif node.type == 'const_exp':
				str_exp, result = self.getExpression(node.children[0], evaluate)
			elif node.type == 'primary_expr':
				str_exp, result = self.getExpression(node.children[0], evaluate)
			else:
				str_exp, result = self.getExpression(node.children[0], evaluate)
				#print node
				
		elif len(node.children) == 2:
			if node.type == 'unary_expr':
				substr2, res2 = self.getExpression(node.children[1], evaluate)
				str_exp = '('+ node.children[0].leaf + substr2 +')'
				if evaluate and res2 != None:
					if node.children[0].leaf == '-':
						result = -res2
					elif node.children[0].leaf == '~':
						result = ~res2
					else:
						result = res2
			else:
				substr1, res1 = self.getExpression(node.children[0], evaluate)
				substr2, res2 = self.getExpression(node.children[1], evaluate)
				str_exp = '('+substr1+'' + node.leaf + '' + substr2+')'
				if evaluate and res1 != None and res2 != None:
					if node.type == 'or_expr':
						#str_exp = '('+substr1+'|'+substr2+')'
						result = res1 | res2
					elif node.type == 'xor_expr':
						#str_exp = '('+substr1+'^'+substr2+')'
						result = res1 ^ res2
					elif node.type == 'and_expr':
						#str_exp = '('+substr1+'&'+substr2+')'
						result = res1 & res2
					
		elif len(node.children) == 3:
			substr1, res1 = self.getExpression(node.children[0], evaluate)
			substr2, res2 = self.getExpression(node.children[2], evaluate)
			
			if isinstance(node.children[1].leaf, list):
				str_exp = '('+substr1+node.children[1].leaf[0]+substr2+')'
			else:
				str_exp = '('+substr1+node.children[1].leaf[0]+substr2+')'
			if evaluate and res1 != None and res2 != None:	
				if node.type == 'shift_expr':
					if node.children[1].leaf == '<<':
						#str_exp = '('+substr1+'<<'+substr2+')'
						result = res1 << res2			
					else:
						#str_exp = '('+substr1+'>>'+substr2+')'
						result = res1 >> res2			
				elif node.type == 'add_expr':
					if node.children[1].leaf == '+':
						#str_exp = '('+substr1+'+'+substr2+')'
						result = res1 + res2			
					else:
						#str_exp = '('+substr1+'-'+substr2+')'
						result = res1 - res2
				elif node.type == 'mult_expr':
					if node.children[1].leaf == '*':
						#str_exp = '('+substr1+'*'+substr2+')'
						#print res1,'   ', res2 
						result = res1 * res2			
					elif node.children[1].leaf == '/':
						#str_exp = '('+substr1+'/'+substr2+')'
						result = res1 / res2			
					else:
						#str_exp = '('+substr1+'%'+substr2+')'
						result = res1 % res2

		else:
			str_exp += ' + ERROR'
			print node, '  ' , str_exp
		return str_exp, result
		
	def getValue(self, node):
		if node.children[0].type == 'integer_literal':
			return int(eval(node.children[0].leaf))
		elif node.children[0].type == 'floating_pt_literal':
			return float(eval(node.children[0].leaf))
		elif node.children[0].type == 'boolean_literal':
			return bool(eval(node.children[0].leaf))
		else:
			return None #node.leaf
	
		
	def definition(self, ast, pt, parent):
		child_list = []
                child = UnknownNode(None, pt.children[0])
		"""
		if pt.children[0].type == 'type_dcl':
			children = self.type_dcl(ast, pt.children[0])
			child_list.extend(children)
			return child_list
		elif pt.children[0].type == 'const_dcl':
			child = self.const_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'interface':
			child = self.interface(ast, pt.children[0])
		el
		"""
		if pt.children[0].type == 'event':
			child = self.event_def(ast, pt.children[0])
		elif pt.children[0].type == 'component':
			child = self.component(ast, pt.children[0])
		elif pt.children[0].type == 'assembly':
			child = self.assembly(ast, pt.children[0])		
		elif pt.children[0].type == 'dataport_dcl':
			child = self.dataport_dcl(ast, pt.children[0])
		elif pt.children[0].type == 'connector':
			child = self.connector(ast, pt.children[0])								
		else:
			child = UnknownNode(None, pt.children[0])
		child_list.append(child)
		return child_list
	
	def type_dcl(self, ast, pt):
		if pt.children[0].type == 'type_declarator':
			#typedef:
			return self.type_declarator(ast, pt.children[0])
			
		elif pt.children[0].type == 'struct_type':
			struct_node = self.struct_type(ast, pt.children[0])
			return [struct_node]
		elif pt.children[0].type == 'enum_type':
			enum_node = self.enum_type(ast, pt.children[0])
			return [enum_node]
		elif pt.children[0].type == 'union_type':
			union_node = self.union_type(ast, pt.children[0])
			return [union_node]		
		elif pt.children[0].type == 'simple_declarator':
			typenode = Type(ast)
			typenode.leaf = pt.children[0].leaf
			typenode.add_attribute('meta_type', 'native')
			return [typenode]
			
		elif pt.children[0].type == 'constr_forward_decl':
			typenode = Type(ast)
			typenode.leaf = pt.the('constr_forward_decl').the('identifier').leaf
			typenode.add_attribute('meta_type', 'forward')
			info = Info(typenode)
			typenode.add_child(info)
			#typetype = 'forward ' + pt.the('constr_forward_dcl').leaf
			info.add_attribute('meta_type' , pt.the('constr_forward_decl').leaf)
			return [typenode]
		else:
			type_node = UnknownNode(None, pt.children[0])
			return [type_node]
			
	def type_declarator(self, ast, pt):
		typeref, new_type = self.type_spec(ast, pt.the('type_spec'))
		decls = pt.the('declarators')
		if new_type:
			decl_list = [typeref]
		else:
			decl_list = []
		decl_list.extend(self.create_type_list(ast, typeref, decls.children))
		return decl_list

	def const_dcl(self, ast, pt):
            const_node = Const(ast)
            const_node.leaf = pt.the('identifier').leaf
	    const_node.add_attribute('target_type', self.const_type(const_node, pt.the('const_type')))
            str, res = self.getExpression(pt.the('const_exp'), True)
            if res != None:
                const_node.add_attribute('value', res)
            else:
                const_node.add_attribute('value', str)
	    
	    #type_inst = self.registry[const_node.the('type').leaf]
	    #self.registry.make_instance_add_instance(type_inst, const_node.leaf, const_node.get_attribute('value'))
            return const_node
	
	def const_type(self, ast, pt):	
		child = pt.children[0]
		#typenode = Type(ast, None)
		if child.type == 'integer_type':
			name = self.integer_type(ast, child)
			typeref = infogripper.getBasicTypenode(name, type_node)
		elif child.type == 'char_type':
			typeref = infogripper.getBasicTypenode('char', type_node)
		elif child.type == 'wide_char_type':
			typeref = infogripper.getBasicTypenode('wchar', type_node)
		elif child.type == 'boolean_type':
			typeref = infogripper.getBasicTypenode('boolean', type_node)
		elif child.type == 'floating_pt_type':
			name = self.floating_pt_type(typenode, child)
			typeref = infogripper.getBasicTypenode(name, type_node)			
		elif child.type == 'string_type':
			typeref = self.string_type(typenode, child)
		elif child.type == 'wide_string_type':
			typeref = self.string_type(typenode, child, True)
		elif child.type == '_type':
			pass #typenode.leaf = 'fixed'
		elif child.type == 'scoped_name':
			typeref = self.scoped_name_type(ast, child)
		elif child.type == 'octet_type':
			pass #typenode.leaf = 'octet'
		else:
			typenode.leaf = 'UNKOWN'
		return typeref

        
        def interface(self,ast,  pt):
            interface = Interface(ast, None)
            for child in pt.children:
                if child.type == 'identifier':
                    interface.leaf = child.leaf
                elif child.type == 'interface_dcl':
                    #print child
                    if child.the('interface_header') != None:
                        scope_list = child.the('interface_header').the('interface_inheritance_spec').the('scoped_name_list')
                        for scope_name in scope_list['scoped_name']:
			    inher_node = Inheritance(interface, name = self.scoped_name(scope_name))
			    interface.add_child(inher_node)
			    inher_node.add_attribute('target_scope', find_scope(interface, inher_node.leaf))
                            
                    if child.the('interface_body') != None:
                        for export_child in child.the('interface_body').children:
				exp_node = self.export(interface, export_child)
				interface.add_children(exp_node)
				
            return interface

			
	def event_def(self, ast, pt):
		event_node = Event(ast)
		child = pt.children[0]
		if child.type == 'event_abs':
			event_node.add_attribute('modifier', 'abstract')
			event_node.leaf = child.the('event_abs_dcl').the('event_header').the('identifier').leaf
			if child.the('event_abs_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_abs_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_abs_dcl')[export]:
					exp_list.extend(self.export(exp_child))
				if exp_list != []:
					event_node.add_child(Export(None, exp_list))
		elif child.type == 'event_custom':
			event_node.add_attribute('modifier', 'custom')
			event_node.leaf = child.the('event_custom').the('event_header').the('identifier').leaf
			if child.the('event_elem_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_elem_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_elem_dcl')[export]:
					exp_list.extend(self.export(exp_child))
				if exp_list != []:
					event_node.add_child(Export(exp_list))
		elif child.type == 'event_dcl':
			event_node.leaf = child.the('event_dcl').the('event_header').the('identifier').leaf
			if child.the('event_elem_dcl') != None:
				event_node.add_child(self.value_inheritance_spec(child.the('event_elem_dcl').the('value_inheritance_spec')))
				exp_list = []
				for exp_child in child.the('event_elem_dcl')[export]:
					exp_list.extend(self.export(event_node, exp_child))
				if exp_list != []:
					event_node.add_child(Export(None, exp_list))
		
		else:
			return UnknownNode(None, child)
	
	def component(self,ast, pt):
		component = Component(ast, None)
		component.leaf = pt.the('identifier').leaf
		dcl = pt.the('component_dcl')
		if  dcl != None:
			inh = dcl.the('component_inheritance_spec')
			if inh != None:
				inher_node = Inheritance(component, name = self.scoped_name(interface, scope_name))
	 	                inher_node.add_attribute('target_scope',find_scope(interface, inher))
				component.add_child(inher_node)
			
			bod = dcl.the('component_body')
			if bod != None:
				exp_list = self.component_body(component, bod)
				if exp_list != []:
					component.add_children(exp_list)
		return component
	

	def component_body(self, ast, pt):
		exp_list = self.component_export(ast, pt['component_export'])
		comp_node = self.component_composition(ast, pt.the('component_composition'))
		if comp_node is not None:
			exp_list.append(comp_node)
		return exp_list
	
	def component_export(self, ast, expnode_list):
		exp_list = []
		for exp in expnode_list:
			exp_node = Export(ast)
			if exp.children[0].type == 'component_modifiers':
				exp_node = Node(None, 'modifier')
				mod_node = exp.children[0]
				mod_list = []
				while mod_node != None:
					mod_list.append(mod_node.leaf)
					mod_node = mod_node.the('component_modifiers')
				exp_node.leaf = mod_list
			elif exp.children[0].type == 'provides_dcl':
				exp_node.type = 'provides'
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				if exp.children[0].the('interface_type').the('scoped_name') != None:
					scopedname = self.scoped_name(exp.children[0].the('interface_type').the('scoped_name'))
					exp_node.add_attribute('target_type', scopedname)
				else:
					assert false
					
			elif exp.children[0].type == 'uses_dcl':
				typestr = 'uses'
				for child in exp.children[0]['uses_dcl']:
					typestr += child.leaf
				exp_node.type = typestr
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				if exp.children[0].the('interface_type').the('scoped_name') != None:
					scopedname = self.scoped_name(exp.children[0].the('interface_type').the('scoped_name'))
					exp_node.add_attribute('target_type', scopedname)
				else:
					assert false
			elif exp.children[0].type == 'emits_dcl':
				exp_node.add_attribute('type', 'emits')
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'publishes_dcl':
				exp_node.add_attribute('type', 'publishes')
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'consumes_dcl':
				exp_node.add_attribute('type', 'consumes')
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
				exp_node.add_attribute('name', scopedname)
			elif exp.children[0].type == 'attr_dcl':
				exp_node.add_child(self.attr_dcl(exp_node, exp.children[0]))
			elif exp.children[0].type == 'dataport_spec':
				exp_node.add_attribute('type', 'dataport')
				exp_node.leaf = self.getDeclarator( exp.children[0].the('declarator'))
				if exp.children[0].the('scoped_name') != None:
					scopedname = self.scoped_name(exp.children[0].the('scoped_name'))
					exp_node.add_attribute('name', scopedname)
				else:
					exp_node.add_attribute('name', 'Object')
				#exp_node = (UnknownNode(None, exp))
			else:
				exp_node = (UnknownNode(None, exp))
			exp_list.append(exp_node)
		return exp_list
	
	def component_composition(self, ast, pt):
		if pt == None:
			return None
		comp_node = Node(ast, 'composition')
		for exp in pt['composition_export']:
			if exp.children[0].type == 'component_inst':
				inst_node = self.component_inst(comp_node, exp.children[0])
				comp_node.add_child(inst_node)
			elif exp.children[0].type == 'connection_dcl':
				comp_node.add_child(self.connection_dcl(comp_node, exp.children[0]))
			else:
				comp_node.add_child(UnknownNode(ast, pt))
		return comp_node
				
	def component_inst(self, ast, pt):
		inst_node = Node(ast, 'componentInstance', None)
		inst_node.leaf = self.getDeclarator( pt.the('declarator'))
		scopedname = self.scoped_name(pt.the('scoped_name'))
		inst_node.add_attribute('target_type', infogripper.getNode(scopedname, ast, 'component'))
		return inst_node
	
	def connection_dcl(self, ast, pt):	
		#connection_head
		conn = Node(ast, 'connection')
		scoped_name = self.scoped_name(pt.the('connection_head').the('scoped_name'))
		conn.leaf = pt.the('connection_head').the('identifier').leaf
		conn.add_attribute('target_type', infogripper.getNode(scoped_name, ast,'connector'))
		
		worknode = Node(ast, 'from')
		#connection_body
		direction = 'provides'
		for child in pt.the('connection_body').children:
			if child.type == 'connection_body':
				if child.leaf == 'from':
					worknode = Node(ast, 'from')
					direction = 'provides'
				elif child.leaf == 'to':
					if worknode.leaf != 'to':
						worknode = Node(ast, 'to')
						direction = 'uses'
				elif child.leaf == ',':
					assert worknode.type == 'from'
					worknode = Node(ast, 'to')
					direction = 'uses'
				else:
					cihld.print_tree()
					assert false
			elif child.type == 'scoped_name_list':
				name_list = []
				target_list = {}
				for name in child.children:
					newname = self.scoped_name(name)
					componentname = newname.split('.')[:-1]
					interfacename = newname.split('.')[-1]
					assert len(componentname) == 1
					comp_inst_node = infogripper.getNode(componentname, conn, 'componentInstance')
					assert comp_inst_node is not None
					component_def = comp_inst_node.get_attribute('target_type')[0]
					interface_node = component_def.find_node(direction, interfacename, ['component','composition','assembly'])
					assert interface_node is not None
					name_list.append(newname)
					target_list[newname] = (interface_node)
				worknode.leaf = name_list
				worknode.add_attribute('target', target_list)
				conn.add_child(worknode)
			else:
				conn.add_child(UnknownNode(child))
				 
				
		return conn
	
		
        def export(self, ast, pt):
            
            if pt.children[0].type == 'type_dcl':
                return self.type_dcl(ast, pt.children[0])
            elif pt.children[0].type == 'const_dcl':
                return [self.const_dcl(pt.children[0])]
            elif pt.children[0].type == 'except_dcl':
                return [self.except_dcl(ast, pt.children[0])]
            elif pt.children[0].type == 'attr_dcl':
                return [self.attr_dcl(ast, pt.children[0])]
            elif pt.children[0].type == 'op_dcl':
                return [self.op_dcl(ast, pt.children[0])]
            elif pt.children[0].type == 'type_id_dcl':
                return [self.type_id_dcl(ast, pt.children[0])]
            elif pt.children[0].type == 'type_prefix_dcl':
                return [self.type_prefix_dcl(ast, pt.children[0])]
            else:
                return [UnknownNode(None, pt.children[0])]
		
	def attr_dcl(self,ast, pt):
		attr_node = Attribute(ast, None)
		type_node = self.param_type_spec(attr_node, pt.children[0].the('param_type_spec'))
		if pt.children[0].type == 'readonly_attr_spec':
			attr_node.add_attribute('mode', 'readonly')
			attr_node.add_child(self.attr_declarator(attr_node, pt.children[0].the('readonly_attr_declarator')))
			#self.attr_declarator(pt.children[0].the('readonly_attr_declarator'), type_node)
		elif pt.children[0].type == 'attr_spec':
			attr_node.add_attribute('mode', 'readwrite')
			attr_node.add_child(self.attr_declarator(attr_node, pt.children[0].the('attr_declarator')))
			#attr_node.add_child(self.attr_declarator(pt.children[0].the('attr_declarator')), type_node)
		else:
			attr_node = UnknownNode(None, pt.children[0])
		type_node.add_attribute('declarator', attr_node.the('declarator').leaf)
		attr_node.add_child(type_node)
		
		return attr_node
		
	def op_dcl(self,ast, pt):
		fcn = Function(ast, None)
		for child in pt.children:
			if child.type == 'decorator':
				#print child
				dec_children = self.decorator_elements(child)
				dec_node = Decorator(fcn, dec_children)
				fcn.add_child(dec_node)
			elif child.type == 'op_attribute':
				fcn.add_attribute('attribute', child.leaf)
			elif child.type == 'op_type_spec':
				
				if child.leaf == 'void':
					target = infogripper.getTypenode('void', fcn)
				#print 'trying to get typenode for: %s' %(child.the('param_type_spec'))
				else:
					target = self.param_type_spec(fcn, child.the('param_type_spec'))
				typenode = Type(fcn, None)
				typenode.type = 'return_type'
				typenode.add_attribute('target_type', target)
				fcn.add_child(typenode)
			elif child.type == 'op_dcl':
				fcn.leaf = child.leaf
			elif child.type == 'parameter_dcls':
				fcn.add_children(self.parameter_dcls(fcn, child))
			elif child.type == 'raises_expr':
				raises = Node(fcn, name='raises')
				leaflist = []
				target_list = []
				for node in child.the('scoped_name_list').children:
					if node.type == 'scoped_name':
						newname = self.scoped_name(node)
						leaflist.append(newname)
						target_list.append(infogripper.getTypenode(newname, fcn))
				raises.leaf = leaflist
				raises.add_attribute('target_scope_list', target_list)
				fcn.add_child(raises)
			elif child.type == 'context_expr':
				context = Node(fcn, name='context')
				leaflist = []
				for node in child.the('string_literal_list').children:
					if node.type == 'string_literal':
						leaflist.append(node.leaf)
				context.leaf = leaflist
				fcn.add_child(context)
			else:
				fcn = UnknownNode(None, child)
		return fcn
		
	def parameter_dcls(self, ast, pt):
		param_list = []
		if pt.the('param_dcl_list') != None:
			dec_node = None
			param_node = None
			for child in pt.the('param_dcl_list').children:
				if child.type == 'decorator':
					#print child
					dec_els = self.decorator_elements(child)
					dec_node = Decorator(ast, dec_els)
					
					#print dec_node
				if child.type == 'param_dcl':
					param_node = self.param_dcl(ast, child)
					if dec_node != None:
						param_node.add_child(dec_node)
						dec_node = None
					param_list.append(param_node)
		return param_list
	
	def param_dcl(self, ast, pt):
		param_node = Parameter(ast, None)
		param_node.add_attribute('direction', pt.leaf)
		for child in pt.children:
			if child.type == 'param_type_spec':
				param_node.add_attribute('target_type',self.param_type_spec(ast, child))
			elif child.type == 'allow_indirection':
				param_node.add_attribute('indirection', child.leaf)
			elif child.type == 'simple_declarator':
				param_node.leaf = child.leaf
			else:
				param_node.add_child(UnkownNode(None, child))
		return param_node
			
			
					
	def attr_declarator(self, ast, pt):
		decl = Declarator(ast, None)
		
		for child in pt.children:
			if child.type == 'simple_declarator':
				#childnode = Node(None)
				#childnode.name = 'identifier'
				decl.leaf = child.leaf
				#decl.add_child(childnode)
			elif child.type == 'attr_raises_expr':
				decl.add_child(self.attr_raises_expr(decl, child))
			else:
				decl.add_child(UnkownNode(None, child))
		return decl
		
		
	def param_type_spec(self, ast, pt):
		if pt.children[0].type == 'base_type_spec':
			param_type = self.base_type_spec(ast, pt.children[0])
		elif pt.children[0].type == 'string_type':
			param_type = self.string_type(ast, pt.children[0])
		elif pt.children[0].type == 'wide_string_type':
			param_type = self.wide_string_type(ast, pt.children[0])
		elif pt.children[0].type == 'scoped_name':
			#print 'scoped_name: %s  %s' %(self.scoped_name(pt.children[0]), ast)
			
			param_type = self.scoped_name_type(ast, pt.children[0])
		else:
			param_type = UnknownNode(None, pt.children[0])
		if param_type is None:
			pt.print_tree()
		assert param_type is not None
		return param_type
	
	def attr_raises_expr(self, pt):
		raisesnode = Node(None, None)
		for child in pt.children:
			if child.type == 'get_excep_expr':
				raisesnode.leaf = 'getraises'
				exception_list = self.exception_list(child.the('exception_list'))
				raisesnode.add_attribute('exception_list', exception_list)
			elif child.type == 'set_excep_expr':
				raisesnode.leaf = 'setraises'
				exception_list = self.exception_list(child.the('exception_list'))
				raisesnode.add_attribute('exception_list', exception_list)
			else:
				raisesnode = UnknownNode(None, child)
		return raisesnode
		
	def exception_list(self, pt):
		ex_list = []	
		for child in pt.children:
			if child.type == 'scoped_name':
				ex_list.append(self.scoped_name(child))
		return ex_list
	
		
	# OK
	def struct_type(self, ast, pt):
		type_node = Type(ast)
		type_node.leaf = pt.the('identifier').leaf
		type_node.add_attribute('meta_type', 'struct')
		membernode = self.member_list(type_node, pt.the('member_list'))
		type_node.add_children(membernode)
		return type_node
	    
	# OK
	def enum_type(self, ast, pt):
		type_node = Type(ast)
		type_node.add_attribute('meta_type', 'enum')
		for child in pt.children:
                    if child.type == 'identifier':
                        type_node.leaf = child.leaf
                    elif child.type == 'enumerator_list':
		    	info = Info(type_node)
			enum_list = []
                        for enum in child['enumerator']:
                            enum_list.append(enum.leaf)
			info.add_attribute('enumeration', enum_list)
			type_node.add_child(info)
		return type_node

	# OK
	def union_type(self,ast, pt):
                type_node = Type(ast)
		type_node.add_attribute('meta_type', 'union')
		info = Info(type_node)
		type_node.add_child(info)
		for child in pt.children:
			if child.type == 'identifier':
                            type_node.leaf = child.leaf
			elif child.type == 'switch_type_spec':
			    typeref = None
                            if child.children[0].type == 'integer_type':
                                name = self.integer_type(ast, child.children[0])
				typeref = infogripper.getBasicTypenode(name, type_node)
                            elif child.children[0].type == 'char_type':
                                name = 'char'
				typeref = infogripper.getBasicTypenode(name, type_node)
                            elif child.children[0].type == 'boolean_type':
                                name = 'boolean'
				typeref = infogripper.getBasicTypenode(name, type_node)
                            elif child.children[0].type == 'enum_type':
                                typeref = self.enum_type(child.children[0])
				info.add_child(typeref)
                            elif child.children[0].type == 'scoped_name':
                                typeref = self.scoped_name_type(ast, child.children[0])
				#typeref.print_tree()
				#info.add_child(typeref)
			    assert typeref is not None
                            info.add_attribute('switch_type',typeref)
			       
                        elif child.type == 'switch_body':
			    members = self.case_stmt_list(type_node, child.the('case_stmt_list'))
                            type_node.add_child(members)
			   			   
		return type_node

	# OK
	def case_stmt_list(self, ast, pt):
	    members = Node(ast, None)
	    members.type = 'members'
            for case in pt.children:
                case_node = CaseNode(members, None)
                #case_node.leaf = case.leaf
                if case.the('const_exp') != None:
                    str, res = self.getExpression(case.the('const_exp'), False)
                    if res != None:
                        #case_node.add_attribute('value', res)
			case_node.leaf = res
                    else:
                        #case_node.add_attribute('value', str)
			case_node.leaf = str
                typeref, new_type = self.type_spec(case_node, case.the('element_spec').the('type_spec'))
		if new_type:
			case_node.add_child(typeref)
			
			
		decl = case.the('element_spec').the('declarator')
		inst_list = self.create_instance_list(case_node, typeref, [decl])
		case_node.add_children(inst_list)
		members.add_child(case_node)
            return members
        
	# OK
	def member_list(self, ast, pt):
		members = Node(ast, None)
		members.type = 'members'
		for child in pt.children:
			if child.type == 'member':
				typeref, new_type = self.type_spec(members, child.the('type_spec'))
				if new_type:
					if isinstance(typeref, str):
						pass
					else:
						members.add_child(typeref)
				members.add_children(self.create_instance_list(members, typeref, child.the('declarators').children))	
			else:
				print 'memberlist_unknown' + child.type
		return [members]

	def scoped_name(self, pt):
            name = pt.leaf	 
            if name == '::':
                name = '::'
	    else:
	        name = ''
            for child in pt.children:
                name += child.leaf
            return name
	    
	def scoped_name_type(self, ast, pt):
		'''
		typenode = Type(ast, None)
		scoped_name = self.scoped_name(pt)
		typenode.add_attribute('meta_type', 'scoped_name')
		info = Info(typenode)
		info.add_attribute('scoped_name',scoped_name)
		typenode.add_child(info)
		'''
		scoped_name = self.scoped_name(pt)
		#print 'searching for: ', scoped_name
		target = infogripper.getTypenode(scoped_name, ast)
		#print '... found node: '
		#target.print_tree()
		#info.add_attribute('target_type', target)
		#return typenode
		return target
	
	# OK
	def type_spec(self, ast, pt):
		typeref = None
		new_type = True
		if pt.children[0].type == 'simple_type_spec':
			typeref, new_type = self.simple_type_spec(ast, pt.children[0])
		else: #constr_type_spec
			typeref = self.constr_type_spec(ast, pt.children[0])
		return (typeref, new_type)
		
	# OK
	def simple_type_spec(self, ast, pt):
		typeref = None
		new_type = False
		if pt.children[0].type == 'base_type_spec':
			typeref = self.base_type_spec(ast, pt.children[0])
		elif pt.children[0].type == 'template_type_spec':
			typeref = self.template_type_spec(ast, pt.children[0])
			new_type = True
		else: #scoped_name
			typeref = self.scoped_name_type(ast, pt.children[0])
			
			assert typeref is not None
			typeref.print_tree()
		return (typeref, new_type)
		
	# OK
	def base_type_spec(self, ast, pt):
		typename = None
		if pt.children[0].type == 'floating_pt_type':
			typename = self.floating_pt_type(ast, pt.children[0])
		elif pt.children[0].type == 'integer_type':
			typename = self.integer_type(ast, pt.children[0])
		else:
			typename = pt.children[0].leaf
		targetnode = infogripper.getBasicTypenode(typename, ast)
		if targetnode == None:
			print 'name = %s not found!' %(typename)
		return targetnode
	    
	# OK
	def integer_type(self, ast, pt):
            namelist = []
            child = pt.children[0]
            while not (child.children == []):
                    namelist.append(child.children[0].leaf)
                    if len(child.children) == 2:
                            namelist.appen(child.children[1].leaf)
                    child = child.children[0]
            return ' '.join(namelist)

	# OK
        def floating_pt_type(self,ast, pt):
            name = pt.leaf
	    if pt.children != []:
	    	name += ' ' + pt.children[0].leaf
            return name
        
        # OK
	def template_type_spec(self, ast, pt):
                typenode = Type(ast, None)
                if pt.children[0].type == 'sequence_type':
                    typenode = self.sequence_type(ast, pt.children[0])
                elif pt.children[0].type == 'string_type':
		    typenode = self.string_type(ast, pt.children[0])
                elif pt.children[0].type == 'wide_string_type':
                    typenode = self.wide_string_type(ast, pt.children[0])                   
                elif pt.children[0].type == 'fixed_pt_type':
		    typenode.add_attribute('meta_type', 'fixed_pt')
                    pos_const_node = pt.the('fixed_pt_type')['positive_int_const'][0]
                    constant_str, result = self.getExpression(pos_const_node.the('const_exp'))
                    if result != None:
                        pre_size = str(result)
                    else:
                        pre_size = constant_str
			
                    pos_const_node = pt.the('fixed_pt_type')['positive_int_const'][1]
                    constant_str, result = self.getExpression(pos_const_node.the('const_exp'))
                    if result != None:
                        post_size = str(result)
                    else:
                        post_size = constant_str
		    
		    info = Info(typenode)
		    info.add_attribute('shape', (pre_size, post_size))
		    typenode.add_child(info)
		    
                else:
                    typenode = UnknownNode(None, pt.children[0])
		return typenode
		
	def sequence_type(self, ast, pt):
		typenode = Type(ast, None)
		typenode.add_attribute('meta_type', 'sequence')
		
                simple_type_node, new_type = self.simple_type_spec(ast, pt.the('simple_type_spec'))
		info = Info(typenode)
		typenode.add_child(info)
		if new_type:
                	info.add_child(simple_type_node)
		info.add_attribute('target_type',simple_type_node)
		
                pos_const_node = pt.the('opt_pos_int')
		if pos_const_node != None:
                	constant_str, result = self.getExpression(pos_const_node.the('positive_int_const').the('const_exp'))
                	info.add_attribute('max_length', constant_str)
		return typenode
		
	def string_type(self, ast, pt, wstring = False):
		typenode = Type(ast, None)
		if wstring:
			typenode.add_attribute('meta_type', 'wstring')
		else:
			typenode.add_attribute('meta_type', 'string')
                pos_const_node = pt.the('positive_int_const')
		info = Info(typenode)
		typenode.add_child(info)
                if pos_const_node != None:
                    constant_str, result = self.getExpression(pos_const_node.the('const_exp'))
                    info.add_attribute('max_length', constant_str)
		return typenode	    
		
		
	def wide_string_type(self, ast, pt):
		stringtype = self.string_type(ast, pt, True)
		stringtype.leaf = 'wstring'
		return stringtype
		
	
	# OK
	def constr_type_spec(self, ast, pt):
            constr_type_node = UnknownNode(None, pt.children[0])
            if pt.children[0].type == 'struct_type':
                constr_type_node = self.struct_type(ast, pt.children[0])
            elif pt.children[0].type == 'union_type':
                constr_type_node = self.union_type(ast, pt.children[0])
            elif pt.children[0].type == 'enum_type':
                constr_type_node = self.enum_type(ast, pt.children[0])
	    return constr_type_node
	    
	def dataport_dcl(self, ast, pt):
		declarator = self.getDeclarator(pt.the('declarator'))
		new_port = Node(ast, 'dataport')
		new_port.leaf = declarator
		members_node = Node(new_port, 'members')
		new_port.add_child(members_node)
		for type_dec in pt['type_declarator']:
			members_node.add_children(self.type_declarator(members_node, type_dec))
		return new_port
			
		
	
	def getDeclarator(self, pt):
		decl_str = ''
		if pt.children[0].type == 'simple_declarator':
			decl_str = pt.children[0].leaf
		else: #complex_declarator
			array_dcl = pt.the('complex_declarator').the('array_declarator')
			leaf_str = array_dcl.leaf
			array_dcl_list = []
			length_str = ''
			for child in array_dcl.children:
				exp_node = child.the('positive_int_const').the('const_exp')
				exp_str, res = self.getExpression(exp_node, True)
				
				if res != None:
					array_dcl_list.append(res)
					length_str += '+(' + str(res) + ')'
				else:
					array_dcl_list.append(exp_str)
					length_str += '+(' + exp_str + ')'
			decl_str = [[leaf_str, length_str, array_dcl_list]]
		return decl_str
		
	def create_instance_list(self, ast, typeref, declarators):
		instance_list = []
		for child in declarators:
			instance = TypeInstance(ast, None)
			
			if child.children[0].type == 'simple_declarator':
				instance.leaf = child.children[0].leaf
				instance.add_attribute('target_type', typeref)
			else: #complex_declarator
				newtype = Type(ast)
				newtype.add_attribute('meta_type','array')
				info = Info(newtype)
				newtype.add_child(info)
				
				array_dcl = child.the('complex_declarator').the('array_declarator')
				array_dim = []
				for dimension in array_dcl.children:
					exp_node = dimension.the('positive_int_const').the('const_exp')
					exp_str, res = self.getExpression(exp_node, True)
					array_dim.append(exp_str)
					'''
					if res != None:
						array_dcl.append(str(res))
					else:
						array_dcl.append(exp_str)
					'''
				info.add_attribute('shape',array_dim)
				info.add_attribute('target_type', typeref)				
				
				newinfo = Info(ast)
				newinfo.add_child(newtype)
								
				instance.add_attribute('target_type', newtype)
				instance.leaf = array_dcl.leaf
				instance.add_child(newinfo)
			instance_list.append(instance)
		return instance_list
			 
	def create_type_list(self, ast, typeref, declarators):
		type_list = []
		for child in declarators:
			typenode = Type(ast, None)
			typenode.add_attribute('meta_type','alias')
			typeinfo = Info(typenode)
			typenode.add_child(typeinfo)
			if child.children[0].type == 'simple_declarator':
				typenode.leaf = child.children[0].leaf
				typeinfo.add_attribute('target_type', typeref)
			else: #complex_declarator
				newtype = Type(ast)
				newtype.add_attribute('meta_type','array')
				info = Info(newtype)
				newtype.add_child(info)
				
				array_dcl = child.the('complex_declarator').the('array_declarator')
				array_dim = []
				for dimension in array_dcl.children:
					exp_node = dimension.the('positive_int_const').the('const_exp')
					exp_str, res = self.getExpression(exp_node, True)
					array_dim.append(exp_str)

				info.add_attribute('shape',array_dim)
				info.add_attribute('target_type', typeref)				
				
				typeinfo.add_attribute('target_type', newtype)
				typenode.leaf = array_dcl.leaf
				typeinfo.add_child(newtype)
				
			assert typenode.leaf != None
			type_list.append(typenode)
		return type_list
	
	def assembly(self, ast, pt):
		assembly = Node(ast, 'assembly')
		for child in pt.children:
			if child.children[0].type == 'component_inst':
				assembly.add_child(self.component_inst(assembly, child.children[0]))
			elif child.children[0].type == 'component_composition':
				assembly.add_child(self.component_composition(assembly, child.children[0]))
			elif child.children[0].type == 'configuration':
				assembly.add_child(self.configuration(assembly, child.children[0]))
			else:
				assembly.add_child(UnknownNode(None, child.children[0]))
				
		return assembly
	
	def connector(self, ast, pt):
		conn = Node(ast, 'connector')
		conn.leaf = pt.the('identifier').leaf

		conn_body = pt.the('connector_body')
		assert conn_body.leaf == 'from'
		conn_spec_list = conn_body['connector_spec']
		assert len(conn_spec_list) == 2
		
		
		#from
		conn_spec = conn_spec_list[0]
		from_node = Node(conn, 'from')
		conn.add_child(from_node)
		from_node.add_attribute('type',conn_spec.the('connector_type').leaf)
		from_node.leaf = conn_spec.the('identifier').leaf
		
		#to
		conn_spec = conn_spec_list[0]
		to_node = Node(conn, 'to')
		conn.add_child(to_node)
		to_node.add_attribute('type',conn_spec.the('connector_type').leaf)
		to_node.leaf = conn_spec.the('identifier').leaf
			
		return conn
		
	def configuration(self, ast, pt):
		config = Node(ast, 'configuration')
		for child in pt.children:
			if child.children[0].type == 'assignment':
				config.add_child(self.assignment(config, child.children[0]))
			elif child.children[0].type == 'cap_list':
				config.add_child(self.cap_list(config, child.children[0]))
			elif child.children[0].type == 'op_dcl':
				config.add_child(self.op_dcl(config, child.children[0]))
		return config
	
	def assignment(self, ast, pt):
		scoped_name = self.scoped_name(pt.the('scoped_name'))
		stringexp, result = self.getExpression(pt.the('const_exp'))
		assignment_node = Node(ast, 'assignment')
		assignment_node.add_attribute('target',scoped_name)
		assignment_node.add_attribute('value', stringexp)
		return assignment_node
		
	def cap_list(self, ast, pt):
		capNode = Node(None, 'capabilityList')
		for cap_element in pt['cap_element']:
			assignment_node = Node(None, 'assignment')
			scoped_name = self.scoped_name(cap_element.the('scoped_name'))
			if cap_element.the('cap_element') != None:
				scoped_name += cap_element.the('cap_element').leaf
			assignment_node.add_attribute('target',scoped_name)
			assignment_node.add_attribute('modifier', cap_element.the('cap_modifier').leaf)
			capNode.add_child(assignment_node)
		return capNode
	
			
def gen(pt, importer, options):
	astgen = ASTGen(importer, options)
	output = astgen.convert(options.filenames, pt)
	return output
			
			
			
			
			
			
			
