header {
from extendAST import extendAST
}

header "CAmkESParser.__init__" {
self.astFactory.setASTNodeClass(extendAST)
}

options {
    language=Python;
}


class CAmkESParser extends Parser;
options {
	exportVocab=IDL;
	buildAST=true;
	k=4;
}

specification
	:   (import_dcl)* (definition)+
	;

definition
	:   (   interface 
	    |   component 
	    |   assembly 
	    |   dataport_dcl 
	    |	connector 
	    )
	;
	
connector
	:   (	"connector" identifier LCURLY (connector_body) RCURLY
	    )
	;
connector_body
	:   (   ("from" ("Interface" | "DataPort") identifier SEMI!)
		("to" ("Interface" | "DataPort") identifier SEMI!)
	    )
	;
	
assembly
	:   (	"assemly" LCURLY (assembly_element)* RCURLY 
	    )
	;

assembly_element
	:   (	component_inst SEMI!
	    |	component_composition SEMI!
	    |   configuration SEMI!	     
	    )
	;
	
configuration
	:   (	"configuration" LCURLY (config_body)* RCURLY

	    )
	;

config_body
	:   ( 	((assignment) => assignment 
		| cap_list 
		| op_dcl) SEMI! )
	;
	
assignment
	:   (	scoped_name ASSIGN ("\"" STRING_LITERAL "\""| const_exp) )
	;
cap_list
	:   (  	"capabilityList" LCURLY (cap_element)* RCURLY )
	;
cap_element
	:   (  scoped_name ASSIGN (MINUS | "r" | "w" | "x")  )
	;
	
interface
	:   ( "abstract" | "local" )?
	    "interface"
	    identifier
	    (   interface_dcl
	    |   
	    )
	;
	
interface_dcl
	:   interface_header
	    LCURLY! interface_body RCURLY!
	;

interface_header
	:   ( interface_inheritance_spec )?
	;

interface_body
	:   ( export )*
	;

export
	:   (   type_dcl SEMI!
	    |   const_dcl SEMI!
	    |   except_dcl SEMI!
	    |   attr_dcl SEMI!
	    |   op_dcl SEMI!
	    )
	;


interface_inheritance_spec
	:   COLON scoped_name_list
	;

interface_name
	:   scoped_name
	;

scoped_name_list
	:    scoped_name (COMMA! scoped_name)*
	;


scoped_name
	:   ( SCOPEOP)? identifier ((SCOPEOP | DOT) identifier)*
	;


expr_list
	:		((const_exp) (COMMA! (const_exp))* )
	;


definition_list
	:   (definition)+
	;






const_dcl
	:   "const" const_type identifier ASSIGN! const_exp
	;

const_type
	:   (integer_type) => integer_type
	|   (char_type) => char_type
	|   wide_char_type
	|   boolean_type
	|   floating_pt_type
	|   string_type
	|   wide_string_type
	|   fixed_pt_const_type
	|   scoped_name
	;


/*   EXPRESSIONS   */

const_exp
	:   or_expr
	;

or_expr
	:   xor_expr
	    ( OR // or_op
	      xor_expr
	    )*
	;

// or_op
// 	:    OR
// 	;


xor_expr
	:   and_expr
	    ( XOR // xor_op
	      and_expr
	    )*
	;

and_expr
	:   shift_expr
	    ( AND // and_op
	      shift_expr
	    )*
	;

shift_expr
	:   add_expr
	    ( ( LSHIFT
	      | RSHIFT
	      ) // shift_op
	    add_expr
	    )*
	;

add_expr
	:   mult_expr
	    ( ( PLUS
	      | MINUS
	      ) // add_op
	      mult_expr
	    )*
	;

mult_expr
	:   unary_expr
	    ( ( STAR
	      | DIV
	      | MOD
	      ) // mult_op
	      unary_expr
	    )*
	;

unary_expr
	:   
			( MINUS
	    | PLUS
	    | TILDE
	    ) // unary_operator
	    primary_expr
	|   primary_expr
	;

// Node of type TPrimaryExp serves to avoid inf. recursion on tree parse
primary_expr
	:   scoped_name
	|   literal
	|   LPAREN const_exp RPAREN
	;

literal
	:   integer_literal
	|   string_literal
	|   wide_string_literal
	|   character_literal
	|   wide_character_literal
	|   fixed_pt_literal
	|   floating_pt_literal
	|   boolean_literal
	;

boolean_literal
	:   "TRUE"
	|   "FALSE"
	;

positive_int_const
	:    const_exp
	;


type_dcl
	:   "typedef" type_declarator
	|   (struct_type) => struct_type
	|   (union_type) => union_type
	|   enum_type
	|   "native" simple_declarator
	|   constr_forward_decl
	;

type_declarator
	:   type_spec declarators
	;

type_spec
	:   (simple_type_spec
	|   constr_type_spec)
	    (allow_indirection)?
	;

simple_type_spec
	:   base_type_spec
	|   template_type_spec
	|   scoped_name
	;

base_type_spec
	:   (floating_pt_type) => floating_pt_type	
	|   (char_type) => char_type
	|   (integer_type) => integer_type 
	|   wide_char_type		
	|   boolean_type	
	|   object_type
	;

template_type_spec
	:   sequence_type
	|   string_type
	|   wide_string_type
	|   fixed_pt_type
	;

constr_type_spec
	:   struct_type
	|   union_type
	|   enum_type
	;

declarators
	:   declarator (COMMA! declarator)*
	;

declarator
	:   simple_declarator
	|   complex_declarator
	;

simple_declarator
	:   identifier
	;

complex_declarator
	:   array_declarator
	;

floating_pt_type
	:   "float"
	|   "double"
	|   "long" "double"
	;

integer_type
	:  signed_int
	|  unsigned_int
	;

signed_int
	:  signed_short_int
	|  signed_long_int
	|  signed_longlong_int
	;

signed_short_int
	:  "short"
	;

signed_long_int
	:  "long"
	;

signed_longlong_int
	:  "long" "long"
	;

unsigned_int
	:  unsigned_short_int
	|  unsigned_long_int
	|  unsigned_longlong_int
	;

unsigned_short_int
	:  "unsigned" "short"
	;

unsigned_long_int
	:  "unsigned" "long"
	;

unsigned_longlong_int
	:  "unsigned" "long" "long"
	;

char_type
	:   signed_char
	|   unsigned_char
	;
	
signed_char
	:   "char"
	;

unsigned_char
	:   "unsigned" "char"
	;

wide_char_type
	:   "wchar"
	;

boolean_type
	:   "boolean"
	;

object_type
	:   "Object"
	;

struct_type
	:   "struct"
	    identifier
	    LCURLY! member_list RCURLY!
	;

member_list
	:   (member)+
	;

member
	:   type_spec declarators SEMI!
	;

union_type
	:   "union"
	    identifier
	    "switch"! LPAREN! switch_type_spec RPAREN!
	    LCURLY! switch_body RCURLY!
	;

switch_type_spec
	:   (integer_type) => integer_type
	|   (char_type) => char_type
	|   boolean_type
	|   enum_type
	|   scoped_name
	;

switch_body
	:   case_stmt_list
	;

case_stmt_list
	:  (case_stmt)+
	;

case_stmt
	:   
	    ( "case" const_exp COLON!
	    | "default" COLON!
	    )+
	    element_spec SEMI!
	;

element_spec
	:   type_spec declarator
	;

enum_type
	:   "enum" identifier LCURLY! enumerator_list RCURLY!
	;

enumerator_list
	:    enumerator (COMMA! enumerator)*
	;

enumerator
	:   identifier
	;

sequence_type
	:   "sequence"
	     LT! simple_type_spec opt_pos_int GT!
	;

opt_pos_int
	:    (COMMA! positive_int_const)?
	;

string_type
	:   "string" (LT! positive_int_const GT!)?
	;

wide_string_type
	:   "wstring" (LT! positive_int_const GT!)?
	;

array_declarator
	:   IDENT					// identifier
	    (fixed_array_size)
	;

fixed_array_size
	:   LBRACK! (positive_int_const)? RBRACK!
	;

attr_dcl
	:   readonly_attr_spec
	|   attr_spec
	;

except_dcl
	:   "exception"
	    identifier
	    LCURLY! opt_member_list RCURLY!
	;


opt_member_list
	:    (member)*
	;

op_dcl
	:  
	    op_type_spec
	    IDENT				// identifier
	    parameter_dcls
	    //(raises_expr)?
	    //(context_expr)?
	;


op_type_spec
	:   param_type_spec (allow_indirection)?
	;

parameter_dcls
	:   LPAREN! (param_dcl_list)? RPAREN!
	;

param_dcl_list
	:   param_dcl (COMMA! param_dcl)*
	;
	
allow_indirection
	:	(STAR)+
	;

param_dcl
	:   ("in" | "out" | "inout")		// param_attribute
	    param_type_spec (allow_indirection)? simple_declarator
	;

//raises_expr
//	:   "raises" LPAREN! scoped_name_list RPAREN!
//	;

//context_expr
//	:   "context" LPAREN! string_literal_list RPAREN!
//	;

string_literal_list
	:    string_literal (COMMA! string_literal)*
	;

param_type_spec
	:   base_type_spec
	|   string_type
	|   wide_string_type
	|   scoped_name
	;

fixed_pt_type
	:   "fixed" LT! positive_int_const COMMA! positive_int_const GT!
	;

fixed_pt_const_type
	:   "fixed"
	;

constr_forward_decl
	:   "struct" identifier
	|   "union" identifier
	;

import_dcl
	:   "import" (anglequoted_scope | imported_scope) SEMI!
	;

imported_scope
	:   scoped_name
	|   string_literal
	;

anglequoted_scope
	:   anglequoted_string_literal
	;

readonly_attr_spec
	:   "readonly" "attribute"
	    param_type_spec
	    readonly_attr_declarator
	;

readonly_attr_declarator
	:   simple_declarator
	    //( raises_expr
	    //| (COMMA! simple_declarator)*
	    //)
	;

attr_spec
	:   "attribute" param_type_spec attr_declarator
	;

attr_declarator
	:   simple_declarator
	    //( ("getraises" | "setraises") => attr_raises_expr
	    //| (COMMA! simple_declarator)*
	    //)
	;

//attr_raises_expr
//	:   (get_excep_expr)?
//	    (set_excep_expr)?
//	;

get_excep_expr
	:   "getraises" exception_list
	;

set_excep_expr
	:   "setraises" exception_list
	;

exception_list
	:   LPAREN! scoped_name (COMMA! scoped_name)* RPAREN!
	;

// Component Stuff

component
	:   "component"
	    identifier
	    (component_dcl)?
	;

component_dcl
	:   (component_inheritance_spec)?
	    LCURLY! component_body RCURLY!
	;

component_inheritance_spec
	:   COLON scoped_name
	;

component_body
	:   (component_export)* (component_composition)?
	;

component_export
	:   ( component_modifiers SEMI!
	    | (provides_dcl) => provides_dcl SEMI!
	    | (uses_dcl) => uses_dcl SEMI!
	    | emits_dcl SEMI!
	    | publishes_dcl SEMI!
	    | consumes_dcl SEMI!
	    | attr_dcl SEMI!
	    | component_fcn SEMI!
	    | dataport_spec SEMI!
	    )
	;
component_fcn
	:   ( ("optional")? op_dcl )
	;
	
component_modifiers
	:   ( "active" ("multithread" ("control")?)? 
	    | "passive"
	    )
	;
	
dataport_dcl
	:   ( "dataport" declarator LCURLY (type_declarator SEMI!)* RCURLY
	    )
	;

dataport_spec
	:   ( "dataport" scoped_name declarator
	    )
	;
	

provides_dcl
	:   ("optional")? "provides" interface_type declarator
	;

interface_type
	:   ( scoped_name
	    | "Object"
	    )
	;

uses_dcl
	:   ("optional")? "uses" interface_type declarator
	;

emits_dcl
	:   "emits" scoped_name declarator
	;

publishes_dcl
	:   "publishes" scoped_name declarator
	;

consumes_dcl
	:   "consumes" scoped_name declarator
	;

component_inst
	:    "component" scoped_name declarator
	;

component_composition
	:   (   "composition" LCURLY
		(composition_export SEMI!)+
		RCURLY
	    )
	;
composition_export
	:   (
		component_inst 
	    |   connection_dcl
	    )
	;
	
connection_dcl
	:   (    connection_head connection_body
	    )
	;
	
connection_head
	:   "connection" scoped_name identifier
	;	
	
connection_body
	:   LPAREN ("from" scoped_name_list (",")! "to" scoped_name_list) RPAREN
	;
	

	
event
	:   ( event_abs
	    | event_custom
	    | event_dcl
	    )
	;

event_header
	:   "eventtype"
	    identifier
	;

event_abs
	:   "abstract"
	    event_header
	    (event_abs_dcl)?
	;

event_abs_dcl
	:   //value_inheritance_spec
	    LCURLY! (export)* RCURLY!
	;

event_custom
	:   "custom"
	    event_header
	    event_elem_dcl
	;

event_dcl
	:   event_header
	    ( event_elem_dcl
	    | // event_forward_dcl
	    )
	;

event_elem_dcl
	:   //value_inheritance_spec
	    LCURLY! (export)* RCURLY!
	;

// event_forward_dcl
// 	:
// 	;

/* literals */
integer_literal
	:   INT
	|   OCTAL
	|   HEX
	;

string_literal
	:  (STRING_LITERAL)+
	;
	
anglequoted_string_literal
	:  LT identifier GT
	;

wide_string_literal
	:  (WIDE_STRING_LITERAL)+
	;

character_literal
	:  CHAR_LITERAL
	;

wide_character_literal
	:  WIDE_CHAR_LITERAL
	;

fixed_pt_literal
	:  FIXED
	;

floating_pt_literal
	:   f:FLOAT
	;

identifier
	:   IDENT
	;

/* ADL LEXICAL RULES  */
class CAmkESLexer extends Lexer;
options {
	exportVocab=IDL;
	charVocabulary='\u0000'..'\uFFFE';
	k=4;
}

SEMI
options {
  paraphrase = ";";
}
	:	';'
	;

QUESTION
options {
  paraphrase = "?";
}
	:	'?'
	;

LPAREN
options {
  paraphrase = "(";
}
	:	'('
	;

RPAREN
options {
  paraphrase = ")";
}
	:	')'
	;

LBRACK
options {
  paraphrase = "[";
}
	:	'['
	;

RBRACK
options {
  paraphrase = "]";
}
	:	']'
	;

LCURLY
options {
  paraphrase = "{";
}
	:	'{'
	;

RCURLY
options {
  paraphrase = "}";
}
	:	'}'
	;

OR
options {
  paraphrase = "|";
}
	:	'|'
	;

XOR
options {
  paraphrase = "^";
}
	:	'^'
	;

AND
options {
  paraphrase = "&";
}
	:	'&'
	;

COLON
options {
  paraphrase = ":";
}
	:	':'
	;

COMMA
options {
  paraphrase = ",";
}
	:	','
	;

DOT
options {
  paraphrase = ".";
}
	:	'.'
	;

ASSIGN
options {
  paraphrase = "=";
}
	:	'='
	;

NOT
options {
  paraphrase = "!";
}
	:	'!'
	;

LT
options {
  paraphrase = "<";
}
	:	'<'
	;

LSHIFT
options {
  paraphrase = "<<";
}
	: "<<"
	;

GT
options {
  paraphrase = ">";
}
	:	'>'
	;

RSHIFT
options {
  paraphrase = ">>";
}
	: ">>"
	;

DIV
options {
  paraphrase = "/";
}
	:	'/'
	;

PLUS
options {
  paraphrase = "+";
}
	:	'+'
	;

MINUS
options {
  paraphrase = "-";
}
	:	'-'
	;

TILDE
options {
  paraphrase = "~";
}
	:	'~'
	;

STAR
options {
  paraphrase = "*";
}
	:	'*'
	;

MOD
options {
  paraphrase = "%";
}
	:	'%'
	;


SCOPEOP
options {
  paraphrase = "::";
}
	:  	"::"
	;

UNDERLINE
options {
  paraphrase = "_";
}
	:  	"_"
	;

//FROM
//options {
//  paraphrase = "from";
//}
//	:  	"from"
//	;

//TO
//options {
//  paraphrase = "to";
//}
//	:  	"to"
//	;



WS
options {
  paraphrase = "white space";
}
	:	(' '
	|	'\t'
	|	'\n'  { $newline; }
	|	'\r')
		{ $setType(Token.SKIP); }
	;


PREPROC_DIRECTIVE
options {
  paraphrase = "a preprocessor directive";
}

	:
	'#'!
	(~'\n')* '\n'!
	{ $setType(Token.SKIP); $newline; }
	;


SL_COMMENT
options {
  paraphrase = "a comment";
}

	:
	"//"!
	(~'\n')* '\n'
	{ $setType(Token.SKIP); $newline; }
	;

ML_COMMENT
options {
  paraphrase = "a comment";
}
	:
	"/*"   
                (       {self.LA(2) != '/'}? '*'
                |       '\n' {$newline;}
                |       ~('*'| '\r' | '\n')
                )*
                "*/" {$skip}
        ;

CHAR_LITERAL
options {
  paraphrase = "a character literal";
}
	:
	'\''!
	( ESC | ~'\'' )
	'\''!
	;

WIDE_CHAR_LITERAL
options {
  paraphrase = "a wide character literal";
}
	: 'L'! CHAR_LITERAL
	;

STRING_LITERAL
options {
  paraphrase = "a string literal";
}
	:
	'"'!
	(ESC|~'"')*
	'"'!
	;

WIDE_STRING_LITERAL
options {
  paraphrase = "a wide string literal";
}
	:
	'L'! STRING_LITERAL
	;

protected
ESC
options {
  paraphrase = "an escape sequence";
}
	:	'\\'!
		(	'n'		{$setText("\n");}
		|	't'		{$setText("\t");}
		|	'v'		{$setText("\013");}
		|	'b'		{$setText("\b");}
		|	'r'		{$setText("\r");}
		|	'f'		{$setText("\r");}
		|	'a'  		{$setText("\007");}
		|	'\\'		{$setText("\\");}
		|	'?'     	{$setText("?");}
		|	'\''		{$setText("'");}
		|	'"'		{$setText("\"");}
		|	OCTDIGIT
			(options {greedy=true;}:OCTDIGIT
			  (options {greedy=true;}:OCTDIGIT)?
			)?
			{realc = str(int($getText,8)); $setText(realc);}
		|       'x'! HEXDIGIT
			(options {greedy=true;}:HEXDIGIT)?
			{realc = str(int($getText,16)); $setText(realc);}
		|	'u'!
			HEXDIGIT
			(options {greedy=true;}:HEXDIGIT
			  (options {greedy=true;}:HEXDIGIT
			    (options {greedy=true;}:HEXDIGIT)?
			  )?
			)?
			{realc = str(int($getText,16)); $setText(realc);}
		)
	;

protected
VOCAB
options {
  paraphrase = "an escaped character value";
}
	:	'\3'..'\377'
	;

protected
DIGIT
options {
  paraphrase = "a digit";
}
	:	'0'..'9'
	;

protected
NONZERODIGIT
options {
  paraphrase = "a non-zero digit";
}
	:	'1'..'9'
	;

protected
OCTDIGIT
options {
  paraphrase = "an octal digit";
}
	:	'0'..'7'
	;

protected
HEXDIGIT
options {
  paraphrase = "a hexadecimal digit";
}
	:	('0'..'9' | 'a'..'f' | 'A'..'F')
	;

HEX
options {
  paraphrase = "a hexadecimal value value";
}

	:    ("0x" | "0X") (HEXDIGIT)+
	;

INT
options {
  paraphrase = "an integer value";
}
	:    NONZERODIGIT (DIGIT)*                  // base-10
	     (  '.' (DIGIT)*
		 ( (('e' | 'E') ('+' | '-')? (DIGIT)+)	{$setType(FLOAT);}
		 | ('d' | 'D')!				{$setType(FIXED);}
		 |					{$setType(FLOAT);}
		 )
	     |   ('e' | 'E') ('+' | '-')? (DIGIT)+   	{$setType(FLOAT);}
	     |   ('d' | 'D')!				{$setType(FIXED);}
	     )?
	;

OCTAL
options {
  paraphrase = "an octal value";
}
	:    '0'
	     ( (DIGIT)+
	     | FLOAT					{$setType(FLOAT);}
	     | ('d' | 'D')!				{$setType(FIXED);}
	     |						{$setType(INT);}
	     )
	;


FLOAT
options {
  paraphrase = "a floating point value";
}

	:    '.' (DIGIT)+
	     ( ('e' | 'E') ('+' | '-')? (DIGIT)+
	     | ('d' | 'D')!				{$setType(FIXED);}
	     )?
	;

IDENT
options {
  paraphrase = "an identifer";
  testLiterals = true;
}

	:   ('a'..'z'|'A'..'Z') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	;
	

ESCAPED_IDENT
options {
  paraphrase = "an escaped identifer";
  testLiterals = false;			// redundant, but explicit is good.
}
    // NOTE: Adding a ! to the '_' doesn't seem to work,
    //       so we adjust _begin manually.

	:   '_' ('a'..'z'|'A'..'Z') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
							{_begin+=1;$setType(IDENT);}
	;

