/****************************************************************************
 *
 * Copyright (C) 2002, Karlsruhe University
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	platform/hellas/startup.S
 * Description:	Kernel entry point, ie. the first instruction executed upon
 *		kernel boot.  Clears .bss, sets up the initial stack,
 *		and jumps into C code.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Joshua LeVasseur, Karlsruhe University
 *          Martin Christian, Leipzig University
 ***************************************************************************/

#include <macros.h>
#include INC_ARCH(msr.h)
#include INC_PLAT(init.h)		/* psim constants */
#include INC_GLUE(offsets.h)	/* kernel offset */
#include INC_GLUE(asm.h)
#include INC_GLUE(asm-bat.h)

#define INIT_STACK_SIZE (4096*3)

/********************************************************************
 *  Main entry point.
 ********************************************************************/
	.section ".init"
	.align	2
	.globl	_start
	.type	_start,@function
_start:
	/*  We could be running in real or virtual mode.  Lets switch
	 *  to real mode, map the kernel with the BAT registers, and 
	 *  enter virtual mode.
	 */
	lis      %r13, KERNEL_OFFSET@ha  /* Get the kernel offset. */
	grab_sym %r11, _real_mode        /* Get the address of the bat init code. */
	sub      %r11, %r11, %r13        /* Create a real address. */
	grab_sym %r12, _virt_mode        /* Get the address of the return code. */

	/* Jump to real mode. */
	grab_sym %r14, MSR_REAL          /* Grab the MSR_REAL constant. */
	mtsrr0   %r11                    /* Set the real address. */
	mtsrr1   %r14                    /* Use an msr that disables virtual addressing. */
	rfi                              /* Enable real mode, and jump below. */

_real_mode:

	/* Include the BAT initialization code.  
	 * It expects r13 to hold the KERNEL_OFFSET.
	 */
	hard_init_bats

	/* Map the cpu data area with a data BAT.  First build the lower BAT.
	 */
	grab_sym %r3, _cpu_phys          /* Get the physical address of the cpu area. */
	andis.   %r3, %r3, BAT_BLOCK_MASK@ha /* Convert to a BAT. */
	ori      %r3, %r3, BAT_WIMG | (BAT_PP_READ_WRITE << BAT_PP) /* Finish BAT construction. */
	mtspr    DBAT_LOWER_CPU, %r3     /* Install the lower cpu data bat. */

	/* Build the upper cpu data BAT.
	 */
	grab_sym %r4, KERNEL_CPU_OFFSET		/* Get the virtual address of the cpu area. */
	andis.   %r4, %r4, BAT_BLOCK_MASK@ha	/* Convert to a BAT. */
	ori      %r4, %r4, (BAT_BL_128K << BAT_BL) | (1 << BAT_VS)
	mtspr    DBAT_UPPER_CPU, %r4		/* Install the upper cpu data bat. */

	/**
	 * There is no OPIC here, so we use OPIC BAT to map the
	 * Marvell Registers.
	 * TODO: A proper implementation should NOT provide this
	 * mapping to user mode. However, there is no way to
	 * disable cache for a page because the MemoryControl
	 * syscall is not implemented.
	 */
#define MARVEL_REG_BASE 0x14000000
	lis      %r3, MARVEL_REG_BASE@ha
	ori      %r3, %r3, (BAT_PP_READ_WRITE << BAT_PP) | (1 << BAT_I)
	mtspr    DBAT_LOWER_OPIC, %r3

	lis      %r4, MARVEL_REG_BASE@ha
	ori      %r4, %r4, (1 << BAT_VS) | (1 << BAT_VP)
	mtspr    DBAT_UPPER_OPIC, %r4

	/* Jump to virtual mode. */
	mtsrr0   %r12                   /* Jump to a valid virtual address. */
	grab_sym %r10, MSR_KERNEL_INIT  /* Grab the MSR_KERNEL_INIT constant. */
	mtsrr1   %r10                   /* Install an initial MSR. */
	rfi

_virt_mode: /*  We have virtual addressing. */

	/*  Use our local init/boot stack.  */
	grab_sym %r1, init_stack              /* Get a pointer to init_stack. */
	addi     %r1, %r1, INIT_STACK_SIZE-32  /* Position ourselves at the top of the stack. */

	/*  Initialize .bss (which also zeros the stack).  */
	lis      %r11, _start_bss@ha
	la       %r11, _start_bss@l(%r11)
	subi     %r11, %r11, 4

	lis      %r12, _end_bss@ha
	la       %r12, _end_bss@l(%r12)

	li       %r0, 0
1:	cmp      0, %r11, %r12
	beq      2f
	stwu     %r0, 4(%r11)
	b        1b
2:
	/* Initialize the system reserved register */
	xor      %r2, %r2, %r2
	/* Point to 0 for the small data area */
	xor      %r13, %r13, %r13

	/*  Jump into C code.  */
	bl       l4_powerpc_init

3:	b        3b /* we should never execute this line.  */
._start_end:
	.size	_start,._start_end-_start

/********************************************************************
 *  Define a stack.
 ********************************************************************/
	.section ".bss"
	.globl	_init_stack_bottom
	.globl	_init_stack_top

_init_stack_bottom:
.lcomm	init_stack, INIT_STACK_SIZE, 16
_init_stack_top:
