/****************************************************************************
 *
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	platform/hellas/init.cc
 * Description:	Platform initialization.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Martin Christian, Leipzig University
 ***************************************************************************/
#include <macros.h>
#include <config.h>
#include <debug.h>
#include INC_API(kernelinterface.h)

/**
 * Board attributes
 * ================
 * CPU clock: 600 MHz
 * Bus clock: 100 MHz
 * RAM:       128 MB
 */
#define TOTAL_MEM 0x8000000
#define CPU_COUNT 1
#define CPU_CLOCK 600000000
#define BUS_CLOCK 100000000

/* Debug consol */
#if defined(CONFIG_KDB_CONS_MPSC)
extern void mpsc_init_console();
#endif

/* 
 * Return the clock speed and bus speed of the primary CPU. 
 */
SECTION(".init") bool platform_get_cpu_speed( word_t *cpu_hz, word_t *bus_hz )
{
	*cpu_hz = CPU_CLOCK;
	*bus_hz = BUS_CLOCK;
	return true;
}

/* 
 * Return number of CPUs on board.
 */
SECTION(".init") int platform_get_cpu_count()
{
	return CPU_COUNT;
}

/* 
 * Find and install the position-independent copy of the
 * OpenFirmware device tree.
 */
SECTION(".init") void platform_init( word_t r3, word_t r4, word_t r5 )
{
#if defined(CONFIG_KDB_CONS_MPSC)
	mpsc_init_console();
#endif

	kernel_interface_page_t *kip = get_kip();

	// Define the user's virtual address space.
	kip->memory_info.insert( memdesc_t::conventional, false,
	                         (addr_t)0, (addr_t)TOTAL_MEM );

}
