/****************************************************************************
 *
 * Copyright (C) 2002, Karlsruhe University
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	glue/v4-powerpc/kip_sc.S
 * Description:	Defines the user space syscall entry points.  
 *		They are prefixes for the actual system calls.  The linker is
 *		responsible for aligning these entry points with their
 *		respective system calls.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Joshua LeVasseur, Karlsruhe University
 *          Martin Christian, Leipzig University
 ***************************************************************************/

#include <macros.h>
#include <tcb_layout.h>
#include <asmsyms.h>
#include INC_GLUE(syscalls.h)


KIP_SC_ENTRY(".sc_schedule", schedule)
	syscall_entry
	stackify1 SCHEDULE_ABI_DEST

/*****************************************************************************/

KIP_SC_ENTRY(".sc_xchg_registers", xchg_registers)
	syscall_entry
	stackify2 EXREG_ABI_DEST, EXREG_ABI_PAGER

/*****************************************************************************/

KIP_SC_ENTRY(".sc_unmap", unmap)
	/* Fixup the parameters for the C function calling ABI (we are still
	 * in user mode). */
	spill_register_MRs_to_user_UTCB
	mr	%r3, UNMAP_ABI_CONTROL

	/* Enter the kernel and handle the system call. */
	syscall_entry

/*****************************************************************************/

KIP_SC_ENTRY(".sc_memory_ctrl", memory_ctrl)
	/* Fixup the parameters for the C function calling ABI (we are still
	 * in user mode). */
	spill_register_MRs_to_user_UTCB
	mr	%r3, MEM_ABI_CONTROL
	mr	%r4, MEM_ABI_ATTR0
	mr	%r5, MEM_ABI_ATTR1
	mr	%r6, MEM_ABI_ATTR2
	mr	%r7, MEM_ABI_ATTR3

	/* Enter the kernel and handle the system call. */
	syscall_entry

/*****************************************************************************/

KIP_SC_ENTRY(".sc_processor_ctrl", processor_ctrl)
	syscall_entry

/*****************************************************************************/

KIP_SC_ENTRY(".sc_thread_ctrl", thread_ctrl)
	syscall_entry
	stackify6 TCTRL_ABI_DEST, TCTRL_ABI_SPACE, TCTRL_ABI_SCHEDULER, TCTRL_ABI_PAGER, \
	          TCTRL_ABI_SND_REDIR, TCTRL_ABI_RCV_REDIR

/*****************************************************************************/

KIP_SC_ENTRY(".sc_space_ctrl", space_ctrl)
	syscall_entry
	stackify3 SPACE_ABI_SPACE, SPACE_ABI_KIP, SPACE_ABI_UTCB

/*****************************************************************************/

KIP_SC_ENTRY(".sc_perf", perf)
	syscall_entry
	lwz	%r11, SC_REG(SRR0) (%r1)
	lwz	%r12, SC_REG(SRR1) (%r1)
	lwz	%r31, SC_REG(R31)  (%r1)
	lwz	%r30, SC_REG(R30)  (%r1)
	lwz	%r2,  SC_REG(R2)   (%r1)
	lwz	%r1,  SC_REG(R1)   (%r1)
	mtsrr0	%r11
	mtsrr1	%r12
	rfi

/*****************************************************************************/

KIP_SC_ENTRY(".sc_thread_switch", thread_switch)
	syscall_entry
	stackify1 TSWITCH_ABI_DEST

