/****************************************************************************
 *
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	platform/hellas/init.h
 * Description:	Platform declarations.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Martin Christian, Leipzig University
 ***************************************************************************/

#ifndef __PLATFORM__HELLAS__MARVELL_H__
#define __PLATFORM__HELLAS__MARVELL_H__

#define MARVELL_BASE  0x14000000
#define MARVELL_SIZE  0x00010000

#define MPSC_CHANNEL0 (MARVELL_BASE + 0x8000)

/* Interrupt registers */
#define MAIN_CAUSE_L  (MARVELL_BASE + 0x0c18)
#define MAIN_CAUSE_H  (MARVELL_BASE + 0x0c68)
#define CPU_MASK_L    (MARVELL_BASE + 0x0c1c)
#define CPU_MASK_H    (MARVELL_BASE + 0x0c6c)
#define MPSC_CAUSE0   (MARVELL_BASE + 0xb804)
#define MPSC_MASK0    (MARVELL_BASE + 0xb884)

/* Interrupt bits */
#define MPSC_CMR0_RCC        (1 << 30)
#define MAIN_INT_MPSC0       (1 << 16)

/**
 * The registers of the MPSC are mapped to memory region. For convenience
 * this structure allows access to the memory mapped registers of the MPSC.
 */
struct mpsc_uart
{
	u32_t mcr_l;       /* Main Configuration Register Low */
#define MPSC_MCRL_UART_MODE  (4 << 24)
#define MPSC_MCRL_ETX        (1 << 30)
#define MPSC_MCRL_ERX        (1 << 31)

	u32_t mcr_h;       /* Main Configuration Register Low */
#define MPSC_MCRH_RCDV_X8    (1 << 1)

	u32_t pcr;         /* Protocol Configuration Register */
#define MPSC_PCR_ISO         (1 << 31)
#define MPSC_PCR_CHARLEN8    (3 << 20)
#define MPSC_PCR_2STOPBITS   (1 << 22)

	u32_t chr1;        /* Channel Register  1 */
#define MPSC_CHR1_TCS(c)     (c << 24)

	u32_t chr2;        /* Channel Register  2 */
#define MPSC_CHR2_TTCS       (1 << 17)
#define MPSC_CHR2_EHUNT      (1 << 7)

	u32_t chr3;        /* Channel Register  3 */
	u32_t chr4;        /* Channel Register  4 */
#define MPSC_CHR4_BCE(c)      (c << 24)
#define MPSC_CHR4_Z           (1 << 5)

	u32_t chr5;        /* Channel Register  5 */
#define MPSC_CHR5_CHAR(c)    (c << 24)
#define MPSC_CHR5_INT        (1 << 20)
#define MPSC_CHR5_CO         (1 << 21)
#define MPSC_CHR5_R          (1 << 22)
#define MPSC_CHR5_V          (1 << 23)
	u32_t chr6;        /* Channel Register  6 */
	u32_t chr7;        /* Channel Register  7 */
	u32_t chr8;        /* Channel Register  8 */
	u32_t chr9;        /* Channel Register  9 */
	u32_t chr10;       /* Channel Register 10 */
};

#endif	/* __PLATFORM__HELLAS__MARVELL_H__ */
