/****************************************************************************
 *
 * Copyright (C) 2002-2003, Karlsruhe University
 * Copyright (c) 2004 - 2005, University of New South Wales, Australia
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	loaders/elf-loader/src/arch-powerpc/arch.c
 * Description:	Boot loader code for PowerPC
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Joshua LeVasseur, Karlsruhe University
 *          Carl van Schaik, University of New South Wales
 *          Martin Christian, Leipzig University
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "../arch.h"
#include "page.h"

/* Kernel offset if address translation is enabled */
#define KERNEL_OFFSET	0xC0000000

/*****************************************************************************
 * Architecture defined functions of elf-loader
 *****************************************************************************/
void arch_init( void ) {
	/* Create a 1:1 256MB data mapping for the lower 256MB of memory. */
	struct ppc_bat_t bat;

	bat.raw.lower = 0;
	bat.raw.upper = 0;
	bat.x.pp = BAT_PP_READ_WRITE;
	bat.x.vs = 1;
	bat.x.bl = BAT_BL_256M;

	asm volatile ("isync");
	ppc_set_dbat3l( bat.raw.lower );
	ppc_set_dbat3u( bat.raw.upper );
	asm volatile ("isync");
}

void arch_start_kernel( void* entry )
{
	/* Make entry a physical address */
	uint32_t phys_entry = (uint32_t)entry - (uint32_t)KERNEL_OFFSET;
	printf( "elf-loader: phys_entry=0x%x\n", phys_entry );

 /*  jumping to l4_powerpc_init(word_t r3, word_t r4, word_t r5) */
	__asm__ __volatile__ (
	    "	eieio \n"
	    "	isync \n"
	    " xor %%r0, %%r0, %%r0 \n"
	    /* Initialize the system reserved register */
	    " xor %%r2, %%r2, %%r2 \n"
	    " xor %%r13, %%r13, %%r13 \n"
	    /* Set parameters to 0 */
	    " xor %%r3, %%r3, %%r3 \n"
	    " xor %%r4, %%r4, %%r4 \n"
	    " xor %%r5, %%r5, %%r5 \n"
	    " mtsrr1 %%r0 \n" // Clear the msr, and disable everything.
	    " mtsrr0 %0 \n"    // Install the kernel's start ip address.
	    " rfi \n"
	    :: "r" (phys_entry)
	);
}
