/****************************************************************************
 *
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	libs/mutex/src/arch-powerpc/try_lock.S
 * Description:	Hardware-backed Mutex implementation for PowerPC
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Martin Christian, Leipzig University
 ***************************************************************************/

/* L4_Word_t try_lock( mutex_t mtx, L4_Word_t me ) 
 *  - mtx: pointer to mutex (r3)
 *  - me:  thread id (r4)
 *  => true if the lock was aquired, false otherwise */

	.text
	.global	try_lock
	.type	try_lock, @function
	.align 2
try_lock:
	lwarx  %r5, 0, %r3  /* r5 = mtx->holder       */
	cmpw   0, %r5, %r4  /* if (mtx->holder == me) */
	beq-   2f           /*   goto return_success  */
	cmpwi  0, %r5, 0    /* if (mtx->holder != 0)  */
	bne    3f           /*   goto return_fail     */
1:	                    /* else                   */
	stwcx. %r4, 0, %r3  /*   mtx->holder = me     */
	bne-   3f           /* if (!success)          */
	                    /*   goto return_fail     */
2:	/* return_success */
	li %r3, 1
	blr
3:	/* return_fail */
	li %r3, 0
	blr
