/*********************************************************************
 *                
 * Copyright (C) 2007,  Leipzig University
 *                
 * File path:     libs/l4/include/l4/powerpc/asm.h
 * Description:   Assembler macros and register aliases
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * Author: Martin Christian, Leipzig University
 ********************************************************************/

#ifndef __L4__POWERPC__ASM_H__
#define __L4__POWERPC__ASM_H__

#define BEGIN_PROC(name)  \
    .global name;         \
    .align 2;             \
    .func name;           \
name:

#define END_PROC(name)  \
    .endfunc

/*
 * LD_ADDR ( reg, symbol )
 *   loads the address of symbol into reg
 */
#define	LD_ADDR(reg, symbol)      \
    lis    reg, symbol##@ha;      \
    addi	   reg, reg, symbol##@l

#define LD_CONST(reg, value)             \
    lis    reg, (((value)>>16)&0xFFFF);  \
    addi    reg, reg, ((value)&0xFFFF)

#define LD_LABEL(reg, label)    \
    lis    reg, (label)@ha;     \
    addi    reg, reg, (label)@l

/*
 * Register names
 */
#define	sp	%r1
#define	utcb	%r2

#endif /* __L4__POWERPC__ASM_H__ */
