/*********************************************************************
 *                
 * Copyright (C) 2007,  Leipzig University
 *                
 * File path:     libs/iguana/src/arch_powerpc/thread_stub.S
 * Description:   Startup code for Iguana threads
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * Author: Martin Christian, Leipzig University
 ********************************************************************/

#include <l4/powerpc/asm.h>

/**
Startup stack on thread entry (see iguana/src/thread.c):

Stack Top     ->  +----------------------+ high address
                  | function address     |
                  +----------------------+
                  | thread argument area |
Stack Pointer ->  +----------------------+ low address
**/

	.section    ".text"
BEGIN_PROC(__thread_stub)
	bl  __tls_init_malloc

	lwz %r3,   0(sp)     /* Load pointer to thread argument area */
	lwz %r11,  4(sp)     /* Load function address */
	addi sp, sp, 8

	mtctr %r11
	bctrl                /* Call function */

	bl  thread_delete_self
END_PROC(__thread_stub)
