/*********************************************************************
 *                
 * Copyright (C) 2007,  Leipzig University
 *                
 * File path:     libs/drv_powerpc_timer/src/powerpc.h
 * Description:   Timer based on PowerPC decremeter
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * Author: Martin Christian, Leipzig University
 ********************************************************************/
#ifndef _TIMER_POWERPC_H_
#define _TIMER_POWERPC_H_

#define BUS_CLOCK 100000000
#define TIMER_RATE (BUS_CLOCK/4) /* Timer frequence for PowerPC 750Cxe */
#define IRQ_LABEL (((~(0UL)) << 20) >> 16) /* Msg tag for timeout IPCs */

/* TIMER_RATE * ticks/10^6 us = 25 ticks/us */
#define TICKS_TO_US(ticks)	((ticks) / 25)
#define US_TO_TICKS(us)		((us) * 25)

#endif
