/*********************************************************************
 *                
 * Copyright (C) 2004,  Karlsruhe University
 * Copyright (C) 2007,  Leipzig University
 *                
 * File path:     bench/pingpong/powerpc.h
 * Description:   PowerPC specific pingpong functions
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * Author: Joshua LeVasseur, Karlsruhe University
 *         Martin Christian, Leipzig University
 ********************************************************************/

#ifndef _CYCLES_H_
#define _CYCLES_H_

#ifdef CONFIG_CPU_POWERPC_750

#include <stdint.h>

#define __HAVE_CYCLE_COUNTER
#define CYCLE_MAX UINT32_MAX
#define CYCLE_REG 937 /* upmc1 */

typedef uint32_t cycle_t;

static inline cycle_t get_cycles( void )
{
	cycle_t cycles;
	/* We assume that the kernel configured upmc1 for cycle counting. */
	asm volatile ( "mfspr %0, %1" : "=r" (cycles) : "i" (CYCLE_REG) );
	return cycles;
}

#else /* CONFIG_CPU_POWERPC_750 */
#undef __HAVE_CYCLE_COUNTER
#endif /* CONFIG_CPU_POWERPC_750 */

#endif /* _CYCLES_H_ */
