/****************************************************************************
 *
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	sys-baremetal/arch-powerpc/sys_stdio.c
 * Description:	C standard I/O functions
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Martin Christian, Leipzig University
 ***************************************************************************/

#include <stdio.h>

static void hellas_putc( char c ) {
	volatile unsigned long *ch0r1, *ch0r2;

	ch0r1 = (unsigned long*)0x1400800C;
	ch0r2 = (unsigned long*)0x14008010;

	*ch0r1 = ( (unsigned long)c ) << 24;
	*ch0r2 = (unsigned long)(1 << 17);
	while ( (*ch0r2) & (unsigned long)(1 << 17) )
		; /* wait until charakter is sent */
}

static size_t hellas_write( void *data, long int position, size_t count,
                            void *handle /*unused*/ )
{
	size_t i;
	for ( i = 0; i < count; i++ ) {
		if ( ((char*)data)[i] == '\n' )
			hellas_putc( '\r' );
		hellas_putc( ((char*)data)[i] );
	}
	return count;
}

struct __file __stdin = {
	.handle	    = NULL,
	.read_fn    = NULL,
	.write_fn   = NULL,
	.close_fn   = NULL,
	.eof_fn	    = NULL,
	.buffering_mode = _IONBF,
	.buffer	    = NULL,
	.unget_pos  = 0,
	.current_pos = 0,
	.eof	    = 0
};

struct __file __stdout = {
	.handle	    = NULL,
	.read_fn    = NULL,
	.write_fn   = hellas_write,
	.close_fn   = NULL,
	.eof_fn	    = NULL,
	.buffering_mode = _IONBF,
	.buffer	    = NULL,
	.unget_pos  = 0,
	.current_pos = 0,
	.eof	    = 0
};

struct __file __stderr = {
	.handle	    = NULL,
	.read_fn    = NULL,
	.write_fn   = hellas_write,
	.close_fn   = NULL,
	.eof_fn	    = NULL,
	.buffering_mode = _IONBF,
	.buffer	    = NULL,
	.unget_pos  = 0,
	.current_pos = 0,
	.eof	    = 0
};

FILE *stdin = &__stdin;
FILE *stdout = &__stdout;
FILE *stderr = &__stderr;
