/****************************************************************************
 *
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	libs/c/src/arch-powerpc/jmp.S
 * Description:	setjmp, longjmp implementation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Martin Christian, Leipzig University
 ***************************************************************************/

#include <l4/powerpc/asm.h>

#ifndef __GNUC__
#error FIXME
#endif

/* assuming _SOFT_FLOAT */

/**
 * Implementation of save points within a function context:
 * -> setjmp: stores all state information of a function
 * -> longjmp: restores the saved state information and
 *             continues execution after the position
 *             setjmp was called
 * State information is stored in a frame similar to the
 * EABI stack frame:
 *         +-- Non-Volatile GPR 13-31  buf[4-22]
 *         |   Non-Volatile CR 2-4     buf[3]
 *         |   UTCB (GPR 2)            buf[2]
 *         |   LR save area            buf[1]
 * SP ---> +-- Stack Pointer (GPR 1)   buf[0]
 */

/**
 * Save function state to buf.
 * paramter: long* buf in r3
 * returns 0
 */
BEGIN_PROC(setjmp)
	mflr  %r10
	mfcr  %r11
	stw   sp,    0(%r3)
	stw   %r10,  4(%r3)
	stw   utcb,  8(%r3)
	stw   %r11, 12(%r3)
	stmw  %r13, 16(%r3) /* store r13 - r31 */
	li    %r3,  0
	blr
END_PROC(setjmp)

/* longjmp( long* buf => r3, int val => r4 ) */

/**
 * Restores function state and continues execution after setjmp call.
 * paramter: long* buf (=> r3)
 * paramter: int val (=> r4)
 * returns (val ? val : 1)
 */
BEGIN_PROC(longjmp)
	lwz   sp,    0(%r3)
	lwz   %r10,  4(%r3)
	lwz   utcb,  8(%r3)
	lwz   %r11, 12(%r3)
	lmw   %r13, 16(%r3) /* load r13 - r31 */
	mtlr  %r10
	mtcrf 0x38, %r11
	mr.   %r3, %r4
	bne   1f
	li    %r3, 1
1:	blr
END_PROC(longjmp)
