/****************************************************************************
 *
 * Copyright (C) 2002-2003, Karlsruhe University
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	libs/c/crt/sys-iguana_server/arch-powerpc/crt0.S
 * Description: PowerPC execution entry point.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Espen Skoglund, Karlsruhe University
 *          Martin Christian, Leipzig University
 ***************************************************************************/

#define STACK_SIZE (4096*3)

/*****************************************************************************
 *  Startup code
 *****************************************************************************/
	.section ".text"
	.globl	_start
	.align	2

_start:
	/* Install our stack. */
	lis     %r1, _iguanaserver_stack_top@ha
	la      %r1, _iguanaserver_stack_top@l(%r1)
	subi    %r1, %r1, 32

	/*  Initialize .bss (which also zeros the stack).  */
	lis     %r11, __bss_start@ha
	la      %r11, __bss_start@l(%r11)
	subi    %r11, %r11, 4 /* else stwu misses the first byte */

	lis     %r12, __end@ha
	la      %r12, __end@l(%r12)
	subi    %r12, %r12, 4 /* we must stop one word before __end */

	xor     %r0, %r0, %r0
1:	cmp     0, %r11, %r12
	beq     2f
	stwu    %r0, 4(%r11) /* [r11+4] = r0 */
	b       1b
2:
	/* Point to 0 for the small data area */
	xor     %r13, %r13, %r13

	bl      __L4_Init
	bl      main
3:	b       3b

/*****************************************************************************
 *  Stack
 *****************************************************************************/
	.section ".bss"
	.globl _iguanaserver_stack_bottom
	.globl _iguanaserver_stack_top

_iguanaserver_stack_bottom:
.lcomm	_iguanaserver_stack, STACK_SIZE, 16
_iguanaserver_stack_top:
