/****************************************************************************
 * File path:   libs/c/crt/sys-baremetal/arch-powerpc/marvell-init.h
 * Description: Hostbridge initialization
 * Comment:     The board defines were taken from gt64260R.h, which is
                the internal registers definition file with Copyright
                by Galileo technology.
 ***************************************************************************/

/* Defines */
#define INTERNAL_BASE   0x1400

/* Masks for setting flags in HID0 */
#define _PPC_HID0_SGE   0x00000080   /* store gathering enable */
#define _PPC_HID0_BTIC  0x00000020   /* Branch Target Instruction Cache */
#define _PPC_HID0_DPM   0x00100000   /* Power management */
#define _PPC_HID0_ICFI  0x00000800   /* Instruction Cache Flash Invalidate */
#define _PPC_HID0_DCFI  0x00000400   /* Data Cache Flash Invalidate */
#define _PPC_HID0_BHTE  0x00000004   /* Branch history table enable */

/* Defines for the flash access functions */
#define  FLASH_ADR_555       0xFFF00AAA
#define  FLASH_ADR_2AA       0xFFF00554
#define  FLASH_CMD_AA        0x0000AAAA
#define  FLASH_CMD_55        0x00005555
#define  FLASH_CMD_PROG      0x0000A0A0
#define  FLASH_CMD_RESET     0x0000F0F0

/* Hardware Implementation Dependend registers */
#define HID0 1008
#define HID1 1009

/* L2 Cache Control register */
#define L2CR 1017

/* SPR code of BAT registers */
#define IBAT0U 528
#define IBAT0L 529
#define IBAT1U 530
#define IBAT1L 531
#define IBAT2U 532
#define IBAT2L 533
#define IBAT3U 534
#define IBAT3L 535

#define DBAT0U 536
#define DBAT0L 537
#define DBAT1U 538
#define DBAT1L 539
#define DBAT2U 540
#define DBAT2L 541
#define DBAT3U 542
#define DBAT3L 543

/* Address bus defines */
#define   ROM_BASE             0xFE000000
#define   BITLOG_BASE          0xFC000000
#define   CACHED_RAM_BASE      0x00000000
#define   NON_CACHED_RAM_BASE  0x04000000
#define   GT_BASE              0x14000000
#define   FPGA_BASE            0x14100000
#define   CPLD_BASE            0xFD000000
#define   GRAPHIC_BASE         0xF8000000

/* SDRAM defines */
#define SCS_0_LOW_DECODE_ADDR						          0x008
#define SCS_0_HIGH_DECODE_ADDR						          0x010
#define SCS_1_LOW_DECODE_ADDR						          0x208
#define SCS_1_HIGH_DECODE_ADDR						          0x210
#define SCS_2_LOW_DECODE_ADDR						          0x018
#define SCS_2_HIGH_DECODE_ADDR						          0x020
#define SCS_3_LOW_DECODE_ADDR						          0x218
#define SCS_3_HIGH_DECODE_ADDR						          0x220

#define SDRAM_CONFIG	 	    					          0x448
#define SDRAM_OPERATION_MODE							      0x474
#define SDRAM_ADDR_DECODE								      0x47C
#define SDRAM_TIMING_PARAMETERS                               0x4b4
#define SDRAM_UMA_CONTROL                                     0x4a4
#define SDRAM_CROSS_BAR_CONTROL_LOW                           0x4a8
#define SDRAM_CROSS_BAR_CONTROL_HIGH                          0x4ac
#define SDRAM_CROSS_BAR_TIMEOUT                               0x4b0

#define SDRAM_BANK0PARAMETERS							      0x44C
#define SDRAM_BANK1PARAMETERS							      0x450
#define SDRAM_BANK2PARAMETERS							      0x454
#define SDRAM_BANK3PARAMETERS							      0x458

#define SDRAM_ERROR_DATA_LOW                                  0x484
#define SDRAM_ERROR_DATA_HIGH                                 0x480
#define SDRAM_AND_DEVICE_ERROR_ADDR                           0x490
#define SDRAM_RECEIVED_ECC                                    0x488
#define SDRAM_CALCULATED_ECC                                  0x48c
#define SDRAM_ECC_CONTROL                                     0x494
#define SDRAM_ECC_ERROR_COUNTER                               0x498

/* Device defines */
#define CS_0_LOW_DECODE_ADDR						          0x028
#define CS_0_HIGH_DECODE_ADDR						          0x030
#define CS_1_LOW_DECODE_ADDR						          0x228
#define CS_1_HIGH_DECODE_ADDR						          0x230
#define CS_2_LOW_DECODE_ADDR						          0x248
#define CS_2_HIGH_DECODE_ADDR						          0x250
#define CS_3_LOW_DECODE_ADDR						          0x038
#define CS_3_HIGH_DECODE_ADDR						          0x040
#define BOOTCS_LOW_DECODE_ADDR						          0x238
#define BOOTCS_HIGH_DECODE_ADDR						          0x240

#define DEVICE_BANK0PARAMETERS							      0x45c
#define DEVICE_BANK1PARAMETERS							      0x460
#define DEVICE_BANK2PARAMETERS							      0x464
#define DEVICE_BANK3PARAMETERS							      0x468
#define DEVICE_BOOT_BANK_PARAMETERS						      0x46c
#define DEVICE_CONTROL                                        0x4c0
#define DEVICE_CROSS_BAR_CONTROL_LOW                          0x4c8
#define DEVICE_CROSS_BAR_CONTROL_HIGH                         0x4cc
#define DEVICE_CROSS_BAR_TIMEOUT                              0x4c4

#define DEVICE_INTERRUPT_CAUSE                                0x4d0
#define DEVICE_INTERRUPT_MASK                                 0x4d4
#define DEVICE_ERROR_ADDR                                     0x4d8

/* MPSC register offsets */
#define   MPSC_MCR0L      0x8000
#define   MPSC_MCR0H      0x8004
#define   MPSC_PCR0       0x8008
#define   MPSC_CH0R1      0x800c
#define   MPSC_CH0R2      0x8010
#define   MPSC_CH0R3      0x8014
#define   MPSC_CH0R4      0x8018
#define   MPSC_CH0R5      0x801c
#define   MPSC_CH0R6      0x8020
#define   MPSC_CH0R7      0x8024
#define   MPSC_CH0R8      0x8028
#define   MPSC_CH0R9      0x802c
#define   MPSC_CH0R10     0x8030
#define   MPSC_MPSC0cr    0xb804
#define   MPSC_MPSC0mr    0xb884
#define   MPSC_RR         0xb400
#define   MPSC_RxCLR      0xb404
#define   MPSC_TxCLR      0xb408
#define   MPSC_SPMX       0xf010
#define   MPSC_BCR0       0xb200

.macro	marvell_init

	/* Zero-out registers: %r0 & SPRGs */
	xor		%r0, %r0, %r0
	mtspr	272, %r0
	mtspr	273, %r0
	mtspr	274, %r0
	mtspr	275, %r0

	/* Turn on FP */
	ori		%r3, %r0, 0x2000   /* 0x2000 enables FP-Unit */
	mtmsr	%r3
	isync

	/* Set EMCP: CPU enters checkstop at machine check */
	lis		%r3, 0x8000
	eieio
	isync
	mtspr	HID0, %r3

	/* Disable L2 Cache */
	eieio
	isync
	mtspr	L2CR, %r0

	/* Init the floating point control/status register */
	mtfsfi	7, 0x0
	mtfsfi	6, 0x0
	mtfsfi	5, 0x0
	mtfsfi	4, 0x0
	mtfsfi	3, 0x0
	mtfsfi	2, 0x0
	mtfsfi	1, 0x0
	mtfsfi	0, 0x0
	isync

	/* Initialize the floating point data registers */
	b		init_fp_regs
	.long	0x3f800000		/* 1.0 */
init_fp_regs:
	mfspr	%r3,8
	lfs		%f0, 0(%r3)
	lfs		%f1, 0(%r3)
	lfs		%f2, 0(%r3)
	lfs		%f3, 0(%r3)
	lfs		%f4, 0(%r3)
	lfs		%f5, 0(%r3)
	lfs		%f6, 0(%r3)
	lfs		%f7, 0(%r3)
	lfs		%f8, 0(%r3)
	lfs		%f9, 0(%r3)
	lfs		%f10, 0(%r3)
	lfs		%f11, 0(%r3)
	lfs		%f12, 0(%r3)
	lfs		%f13, 0(%r3)
	lfs		%f14, 0(%r3)
	lfs		%f15, 0(%r3)
	lfs		%f16, 0(%r3)
	lfs		%f17, 0(%r3)
	lfs		%f18, 0(%r3)
	lfs		%f19, 0(%r3)
	lfs		%f20, 0(%r3)
	lfs		%f21, 0(%r3)
	lfs		%f22, 0(%r3)
	lfs		%f23, 0(%r3)
	lfs		%f24, 0(%r3)
	lfs		%f25, 0(%r3)
	lfs		%f26, 0(%r3)
	lfs		%f27, 0(%r3)
	lfs		%f28, 0(%r3)
	lfs		%f29, 0(%r3)
	lfs		%f30, 0(%r3)
	lfs		%f31, 0(%r3)
	isync

	/* Turn off FP */
	mtmsr	%r0
	isync

	/* Init the Segment registers */
	mtsr	0, %r0
	mtsr	1, %r0
	mtsr	2, %r0
	mtsr	3, %r0
	mtsr	4, %r0
	mtsr	5, %r0
	mtsr	6, %r0
	mtsr	7, %r0
	mtsr	8, %r0
	mtsr	9, %r0
	mtsr	10, %r0
	mtsr	11, %r0
	mtsr	12, %r0
	mtsr	13, %r0
	mtsr	14, %r0
	mtsr	15, %r0
	isync

	/* Turn off data and instruction cache control bits */
	mfspr	%r3, HID0
	isync
	rlwinm  %r4, %r3, 0, 18, 15 /* %r4 has ICE and DCE bits cleared */
	isync
	mtspr	HID0, %r4
	isync

	/* flush and invalidate I and D caches */
	oris	%r4, %r4, (_PPC_HID0_ICFI | _PPC_HID0_DCFI)@ha
	ori		%r4, %r4, (_PPC_HID0_ICFI | _PPC_HID0_DCFI)@l
	eieio
	isync
	mtspr	HID0, %r4
	isync

	oris	%r3, %r0, ~(_PPC_HID0_ICFI | _PPC_HID0_DCFI)@ha
	ori		%r3, %r0, ~(_PPC_HID0_ICFI | _PPC_HID0_DCFI)@l
	and		%r4, %r4, %r3
	eieio
	isync
	mtspr	HID0, %r4
	isync

	/* enable Store Gathering, Branch Target Instruction Cache,
	   Branch History Table and Dynamic Power Management */
	oris	%r4, %r4, (_PPC_HID0_SGE | _PPC_HID0_BTIC | _PPC_HID0_BHTE | _PPC_HID0_DPM )@ha
	ori		%r4, %r4, (_PPC_HID0_SGE | _PPC_HID0_BTIC | _PPC_HID0_BHTE | _PPC_HID0_DPM )@l

	/* Clear ILOCK  */
	oris	%r3, %r0, 0xFFFF
	ori		%r3, %r3, 0xDFFF	/* sign extends */
	and		%r4, %r4, %r3		/* clear bit from previous HID0 read */

	/* Set HID0 */
	eieio
	isync
	mtspr	HID0, %r4
	isync

	/* initialize the BAT registers */
	mtspr	IBAT0U, %r0	
	mtspr	IBAT0L, %r0

	mtspr	IBAT1U, %r0
	mtspr	IBAT1L, %r0

	mtspr	IBAT2U, %r0
	mtspr	IBAT2L, %r0

	mtspr	IBAT3U, %r0
	mtspr	IBAT3L, %r0

	mtspr	DBAT0U, %r0
	mtspr	DBAT0L, %r0

	mtspr	DBAT1U, %r0
	mtspr	DBAT1L, %r0

	mtspr	DBAT2U, %r0
	mtspr	DBAT2L, %r0

	mtspr	DBAT3U, %r0
	mtspr	DBAT3L, %r0
	isync

	/* Initialize debugging output */
	bl _init_UART_debug

	/* Set SCS0 for 128 MB SD-RAM (0x0 to 0x07FF.FFFF) */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_0_LOW_DECODE_ADDR
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_0_HIGH_DECODE_ADDR
	lis		%r6, 0x0000007F@h
	ori		%r6, %r6, 0x0000007F@l
	stwbrx  %r6, 0, %r9
	sync

	/* Set other banks to invalid */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_1_LOW_DECODE_ADDR
	lis		%r6, 0x00000FFF@h
	ori		%r6, %r6, 0x00000FFF@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_1_HIGH_DECODE_ADDR
	xor		%r6, %r6, %r6
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_2_LOW_DECODE_ADDR
	lis		%r6, 0x00000FFF@h
	ori		%r6, %r6, 0x00000FFF@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_2_HIGH_DECODE_ADDR
	xor		%r6, %r6, %r6
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_3_LOW_DECODE_ADDR
	lis		%r6, 0x00000FFF@h
	ori		%r6, %r6, 0x00000FFF@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SCS_3_HIGH_DECODE_ADDR
	xor		%r6, %r6, %r6
	stwbrx  %r6, 0, %r9
	sync

	/* Set addresses for chip selects */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_0_LOW_DECODE_ADDR
	lis		%r6, 0x00000FC0@h
	ori		%r6, %r6, 0x00000FC0@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_0_HIGH_DECODE_ADDR
	lis		%r6, 0x00000FDF@h
	ori		%r6, %r6, 0x00000FDF@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_1_LOW_DECODE_ADDR
	lis		%r6, 0x00000142@h
	ori		%r6, %r6, 0x00000142@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_1_HIGH_DECODE_ADDR
	lis		%r6, 0x00000142@h
	ori		%r6, %r6, 0x00000142@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_2_LOW_DECODE_ADDR
	lis		%r6, 0x00000141@h
	ori		%r6, %r6, 0x00000141@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_2_HIGH_DECODE_ADDR
	lis		%r6, 0x00000141@h
	ori		%r6, %r6, 0x00000141@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_3_LOW_DECODE_ADDR
	lis		%r6, 0x00000F80@h
	ori		%r6, %r6, 0x00000F80@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, CS_3_HIGH_DECODE_ADDR
	lis		%r6, 0x00000FBF@h
	ori		%r6, %r6, 0x00000FBF@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, BOOTCS_LOW_DECODE_ADDR
	lis		%r6, 0x00000FE0@h
	ori		%r6, %r6, 0x00000FE0@l
	stwbrx  %r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, BOOTCS_HIGH_DECODE_ADDR
	lis		%r6, 0x00000FFF@h
	ori		%r6, %r6, 0x00000FFF@l
	stwbrx  %r6, 0, %r9
	sync

	/* SD-RAM Config */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_CONFIG
	lis		%r6, 0x4BC18300@h
	ori		%r6, %r6, 0x4BC18300@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_TIMING_PARAMETERS
	lis		%r6, 0x00002515@h
	ori		%r6, %r6, 0x00002515@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_UMA_CONTROL
	lis		%r6, 0x00000100@h
	ori		%r6, %r6, 0x00000100@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_CROSS_BAR_CONTROL_LOW
	lis		%r6, 0x00765432@h
	ori		%r6, %r6, 0x00765432@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_CROSS_BAR_CONTROL_HIGH
	lis		%r6, 0x00765432@h
	ori		%r6, %r6, 0x00765432@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_BANK0PARAMETERS
	lis		%r6, 0x000FC000@h
	ori		%r6, %r6, 0x000FC000@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_BANK1PARAMETERS
	lis		%r6, 0x000FC000@h
	ori		%r6, %r6, 0x000FC000@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_BANK2PARAMETERS
	lis		%r6, 0x000FC000@h
	ori		%r6, %r6, 0x000FC000@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_BANK3PARAMETERS
	lis		%r6, 0x000FC000@h
	ori		%r6, %r6, 0x000FC000@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_ERROR_DATA_LOW
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_ERROR_DATA_HIGH
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_AND_DEVICE_ERROR_ADDR
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_RECEIVED_ECC
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_CALCULATED_ECC
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_ECC_CONTROL
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_ECC_ERROR_COUNTER
	xor		%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	/* SD-RAM init */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_ADDR_DECODE
	lis		%r6, 0x0000002@h
	ori		%r6, %r6, 0x00000002@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_OPERATION_MODE
	lis		%r6, 0x0000003@h
	ori		%r6, %r6, 0x00000003@l
	stwbrx	%r6, 0, %r9
	sync

	/* ->write to address 0x00000023 the value 0x00000000 */
	lis		%r3, 0x00000023@h
	ori		%r3, %r3, 0x00000023@l
	xor 	%r4, %r4, %r4
	stw		%r4, 0(%r3)

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, SDRAM_OPERATION_MODE
	xor 	%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	/* ->write to address 0x00000023 the value 0x00000000 */
	lis		%r3, 0x00000023@h
	ori		%r3, %r3, 0x00000023@l
	xor 	%r4, %r4, %r4
	stw		%r4, 0(%r3)

	/* Set device parameters */
	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_BANK0PARAMETERS
	lis		%r6, 0x859CAA23@h
	ori		%r6, %r6, 0x859CAA23@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_BANK1PARAMETERS
	lis		%r6, 0x8A1FFFFB@h
	ori		%r6, %r6, 0x8A1FFFFB@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_BANK2PARAMETERS
	lis		%r6, 0x88259C43@h
	ori		%r6, %r6, 0x88259C43@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_BANK3PARAMETERS
	lis		%r6, 0x88259C43@h
	ori		%r6, %r6, 0x88259C43@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_BOOT_BANK_PARAMETERS
	lis		%r6, 0x859CAA23@h
	ori		%r6, %r6, 0x859CAA23@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_CONTROL
	lis		%r6, 0x00070064@h
	ori		%r6, %r6, 0x00070064@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_CROSS_BAR_CONTROL_LOW
	lis		%r6, 0x11765432@h
	ori		%r6, %r6, 0x11765432@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_CROSS_BAR_CONTROL_HIGH
	lis		%r6, 0x11765432@h
	ori		%r6, %r6, 0x11765432@l
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_INTERRUPT_CAUSE
	xor 	%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_INTERRUPT_MASK
	xor 	%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	lis		%r9, INTERNAL_BASE
	ori		%r9, %r9, DEVICE_ERROR_ADDR
	xor 	%r6, %r6, %r6
	stwbrx	%r6, 0, %r9
	sync

	/* Output "Marvell" */
	addi	 %r7, %r0, 'R'
	bl	  _putc
	addi	 %r7, %r0, 'A'
	bl	  _putc
	addi	 %r7, %r0, 'M'
	bl	  _putc
	addi	 %r7, %r0, '\r'
	bl	  _putc
	addi	 %r7, %r0, '\n'
	bl	  _putc

	b	_end_marvell

/*********************************************************
 * Initialize MPSC UART for debug I/O. Enable debug
 * output only. Input is not nedded here.
 *********************************************************/
_init_UART_debug:
  /* Connect ports to MPSC */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_RR
	lis	 %r5, 0x007F
	ori	 %r5, %r5, 0xFE38 /* MR1=S1, MR0=S0 */
	stwbrx %r5, 0, %r6

	/* Serial port multiplex */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_SPMX
	xor	 %r5, %r5, %r5
	ori	 %r5, %r5, 0x100 /* Bit 8: Connected to MPSC0 */
	stwbrx %r5, 0, %r6

	/* Receive clock routing*/
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_RxCLR
	xor	 %r5, %r5, %r5
	ori	 %r5, %r5, 0x100 /* CRR0 -> BRG0 and CRR1 -> BRG1*/
	stwbrx %r5, 0, %r6

	/* Transmit clock routing */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_TxCLR
	xor	 %r5, %r5, %r5
	ori	 %r5, %r5, 0x100 /* CRT0 -> BRG0 and CRT1 -> BRG1 */
	stwbrx %r5, 0, %r6

	/* BRG engine: set baudrate */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_BCR0
	lis	 %r5, 0x00210035@h
	ori	 %r5, %r5, 0x00210035@l
	stwbrx %r5,0,%r6

	/* MPSC0 protocol config */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_PCR0
	xor  %r5, %r5, %r5
	ori	 %r5, %r5, 0x3000 /* CL=8 Bit */
	stwbrx %r5, 0, %r6

	/* Main configuration register:low */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_MCR0L
	xor  %r5, %r5, %r5
	ori	 %r5, %r5, 0x4C4 /* ERx=ETx=1, RCDV=x8, UART Mode, NLM */
	stwbrx %r5, 0, %r6

	/* Main configuration register:high */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_MCR0H
	lis	 %r5, 0x020003F8@h
	ori	 %r5, %r5, 0x020003F8@l /* TPL=16 Byte, TPPT=0xf, TCDV=8x, RCDV=8x  */
	stwbrx %r5, 0, %r6

	eieio
	isync
	blr
/* End InitializeUartP0 ************************** */

/* ------------------------------------------------------------------------ */
/* Start _putc:                                                             */
/* Sends characters in debug mode via UART                                  */
_putc:
	/* store char in CHR1.TCS */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_CH0R1
	stwbrx %r7, 0, %r6

	/* start transmission: CHR2.TTCS=1 */
	lis	 %r6, INTERNAL_BASE
	ori	 %r6, %r6, MPSC_CH0R2
	xor  %r5, %r5, %r5
	ori	 %r5, %r5, 0x200
	stwbrx %r5, 0, %r6
	eieio

	/* wait until char is sent */
_wait_ttcs:
	lwbrx %r5, 0, %r6
	andi.  %r5, %r5, 0x200
	bne	 _wait_ttcs /* if ttcs==1 then wait */

	blr
/* End _putc                                                                */
/* ------------------------------------------------------------------------ */
_end_marvell:
	xor		%r0, %r0, %r0
.endm
