/****************************************************************************
 *
 * Copyright (C) 2002-2003, Karlsruhe University
 * Copyright (C) 2007, Leipzig University
 *
 * File path:	libs/c/crt/sys-baremetal/arch-powerpc/crt0.S
 * Description:	Jumps to C code for the loader.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Authors: Joshua LeVasseur, Karlsruhe University
 *          Martin Christian, Leipzig University
 ***************************************************************************/

#define STACK_SIZE (4096*3)
#define CMD_RFI 0x4c000064

/*****************************************************************************
 *  Main entry point.
 *****************************************************************************/
	.section ".text"
	.align	2
	.globl	_start
	.space (0x100)

#include "marvell-init.h"

_start:
	/* Reset machine state register */
	xor     %r0, %r0, %r0
	mtmsr   %r0

	/* Load rfi as exception handler for decrementer exception */
	lis     %r1, CMD_RFI@ha
	la      %r1, CMD_RFI@l(%r1)
	stw     %r1, 0x900(%r0)

	/* Install our stack. */
	lis     %r1, _stack@ha
	la      %r1, _stack@l(%r1)
	addi    %r1, %r1, STACK_SIZE-32

	/*  Initialize .bss (which also zeros the stack).  */
	lis     %r11, __bss_start@ha
	la      %r11, __bss_start@l(%r11)
	subi    %r11, %r11, 4 /* else stwu misses the first byte */

	lis     %r12, __bss_end@ha
	la      %r12, __bss_end@l(%r12)
	subi    %r12, %r12, 4 /* we must stop one word before __end */

	li      %r0, 0
1:	cmp     0, %r11, %r12
	beq     2f
	stwu    %r0, 4(%r11)
	b       1b
2:
	/* Initialize Marvell bridge */
	marvell_init

	/* Initialize the system reserved register */
	xor     %r2, %r2, %r2
	/* Point to 0 for the small data area */
	xor     %r13, %r13, %r13

	/*  Jump into C code.  */
	bl      main

3:	b       3b /* We should never execute this line.  */

/*****************************************************************************
 *  Stack
 *****************************************************************************/
	.section ".bss"
	.globl _stack_bottom
	.globl _stack_top

_stack_bottom:
.lcomm	_stack, STACK_SIZE, 16
_stack_top:
